/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.monitor;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.apache.lucene.monitor.MonitorQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.store.InputStreamDataInput;
import org.apache.lucene.store.OutputStreamDataOutput;
import org.apache.lucene.util.BytesRef;

public interface MonitorQuerySerializer {
    public MonitorQuery deserialize(BytesRef var1);

    public BytesRef serialize(MonitorQuery var1);

    public static MonitorQuerySerializer fromParser(final Function<String, Query> parser) {
        return new MonitorQuerySerializer(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public MonitorQuery deserialize(BytesRef binaryValue) {
                ByteArrayInputStream is = new ByteArrayInputStream(binaryValue.bytes, binaryValue.offset, binaryValue.length);
                try (InputStreamDataInput data = new InputStreamDataInput((InputStream)is);){
                    String id = data.readString();
                    String query = data.readString();
                    HashMap<String, String> metadata = new HashMap<String, String>();
                    for (int i = data.readInt(); i > 0; --i) {
                        metadata.put(data.readString(), data.readString());
                    }
                    MonitorQuery monitorQuery = new MonitorQuery(id, (Query)parser.apply(query), query, metadata);
                    return monitorQuery;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public BytesRef serialize(MonitorQuery query) {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                try (OutputStreamDataOutput data = new OutputStreamDataOutput((OutputStream)os);){
                    data.writeString(query.getId());
                    data.writeString(query.getQueryString());
                    data.writeInt(query.getMetadata().size());
                    for (Map.Entry<String, String> entry : query.getMetadata().entrySet()) {
                        data.writeString(entry.getKey());
                        data.writeString(entry.getValue());
                    }
                    BytesRef bytesRef = new BytesRef(os.toByteArray());
                    return bytesRef;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }
}

