/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.uniformsplit;

import java.io.Closeable;
import java.io.IOException;
import org.apache.lucene.codecs.BlockTermState;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.FieldsConsumer;
import org.apache.lucene.codecs.NormsProducer;
import org.apache.lucene.codecs.PostingsWriterBase;
import org.apache.lucene.codecs.uniformsplit.BlockEncoder;
import org.apache.lucene.codecs.uniformsplit.BlockWriter;
import org.apache.lucene.codecs.uniformsplit.FSTDictionary;
import org.apache.lucene.codecs.uniformsplit.FieldMetadata;
import org.apache.lucene.codecs.uniformsplit.IndexDictionary;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.store.ByteBuffersDataOutput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;

public class UniformSplitTermsWriter
extends FieldsConsumer {
    public static final int DEFAULT_TARGET_NUM_BLOCK_LINES = 32;
    public static final int DEFAULT_DELTA_NUM_LINES = 3;
    protected static final int MAX_NUM_BLOCK_LINES = 1000;
    protected final FieldInfos fieldInfos;
    protected final PostingsWriterBase postingsWriter;
    protected final int maxDoc;
    protected final int targetNumBlockLines;
    protected final int deltaNumLines;
    protected final BlockEncoder blockEncoder;
    protected final IndexOutput blockOutput;
    protected final IndexOutput dictionaryOutput;

    public UniformSplitTermsWriter(PostingsWriterBase postingsWriter, SegmentWriteState state, BlockEncoder blockEncoder) throws IOException {
        this(postingsWriter, state, 32, 3, blockEncoder);
    }

    public UniformSplitTermsWriter(PostingsWriterBase postingsWriter, SegmentWriteState state, int targetNumBlockLines, int deltaNumLines, BlockEncoder blockEncoder) throws IOException {
        this(postingsWriter, state, targetNumBlockLines, deltaNumLines, blockEncoder, "UniformSplit", 0, "ustb", "ustd");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected UniformSplitTermsWriter(PostingsWriterBase postingsWriter, SegmentWriteState state, int targetNumBlockLines, int deltaNumLines, BlockEncoder blockEncoder, String codecName, int versionCurrent, String termsBlocksExtension, String dictionaryExtension) throws IOException {
        UniformSplitTermsWriter.validateSettings(targetNumBlockLines, deltaNumLines);
        IndexOutput blockOutput = null;
        IndexOutput dictionaryOutput = null;
        boolean success = false;
        try {
            this.fieldInfos = state.fieldInfos;
            this.postingsWriter = postingsWriter;
            this.maxDoc = state.segmentInfo.maxDoc();
            this.targetNumBlockLines = targetNumBlockLines;
            this.deltaNumLines = deltaNumLines;
            this.blockEncoder = blockEncoder;
            String termsName = IndexFileNames.segmentFileName((String)state.segmentInfo.name, (String)state.segmentSuffix, (String)termsBlocksExtension);
            blockOutput = state.directory.createOutput(termsName, state.context);
            CodecUtil.writeIndexHeader((DataOutput)blockOutput, (String)codecName, (int)versionCurrent, (byte[])state.segmentInfo.getId(), (String)state.segmentSuffix);
            String indexName = IndexFileNames.segmentFileName((String)state.segmentInfo.name, (String)state.segmentSuffix, (String)dictionaryExtension);
            dictionaryOutput = state.directory.createOutput(indexName, state.context);
            CodecUtil.writeIndexHeader((DataOutput)dictionaryOutput, (String)codecName, (int)versionCurrent, (byte[])state.segmentInfo.getId(), (String)state.segmentSuffix);
            postingsWriter.init(blockOutput, state);
            this.blockOutput = blockOutput;
            this.dictionaryOutput = dictionaryOutput;
            return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{blockOutput, dictionaryOutput});
            throw throwable;
        }
    }

    protected static void validateSettings(int targetNumBlockLines, int deltaNumLines) {
        if (targetNumBlockLines <= 0) {
            throw new IllegalArgumentException("Invalid negative or nul targetNumBlockLines=" + targetNumBlockLines);
        }
        if (deltaNumLines < 0) {
            throw new IllegalArgumentException("Invalid negative deltaNumLines=" + deltaNumLines);
        }
        if (deltaNumLines >= targetNumBlockLines) {
            throw new IllegalArgumentException("Invalid too large deltaNumLines=" + deltaNumLines + ", it must be < targetNumBlockLines=" + targetNumBlockLines);
        }
        if (targetNumBlockLines + deltaNumLines > 1000) {
            throw new IllegalArgumentException("Invalid (targetNumBlockLines + deltaNumLines)=" + (targetNumBlockLines + deltaNumLines) + ", it must be <= MAX_NUM_BLOCK_LINES=" + 1000);
        }
    }

    public void write(Fields fields, NormsProducer normsProducer) throws IOException {
        BlockWriter blockWriter = new BlockWriter(this.blockOutput, this.targetNumBlockLines, this.deltaNumLines, this.blockEncoder);
        ByteBuffersDataOutput fieldsOutput = new ByteBuffersDataOutput();
        int fieldsNumber = 0;
        for (String field : fields) {
            Terms terms = fields.terms(field);
            if (terms == null) continue;
            TermsEnum termsEnum = terms.iterator();
            FieldInfo fieldInfo = this.fieldInfos.fieldInfo(field);
            fieldsNumber += this.writeFieldTerms(blockWriter, (DataOutput)fieldsOutput, termsEnum, fieldInfo, normsProducer);
        }
        this.writeFieldsMetadata(fieldsNumber, fieldsOutput);
        CodecUtil.writeFooter((IndexOutput)this.dictionaryOutput);
    }

    protected void writeFieldsMetadata(int fieldsNumber, ByteBuffersDataOutput fieldsOutput) throws IOException {
        long fieldsStartPosition = this.blockOutput.getFilePointer();
        this.blockOutput.writeVInt(fieldsNumber);
        fieldsOutput.copyTo((DataOutput)this.blockOutput);
        this.blockOutput.writeLong(fieldsStartPosition);
        CodecUtil.writeFooter((IndexOutput)this.blockOutput);
    }

    protected int writeFieldTerms(BlockWriter blockWriter, DataOutput fieldsOutput, TermsEnum termsEnum, FieldInfo fieldInfo, NormsProducer normsProducer) throws IOException {
        FieldMetadata fieldMetadata = new FieldMetadata(fieldInfo, this.maxDoc);
        fieldMetadata.setDictionaryStartFP(this.dictionaryOutput.getFilePointer());
        this.postingsWriter.setField(fieldInfo);
        blockWriter.setField(fieldMetadata);
        FSTDictionary.Builder dictionaryBuilder = new FSTDictionary.Builder();
        BytesRef lastTerm = null;
        while (termsEnum.next() != null) {
            BlockTermState blockTermState = this.writePostingLine(termsEnum, fieldMetadata, normsProducer);
            if (blockTermState == null) continue;
            lastTerm = BytesRef.deepCopyOf((BytesRef)termsEnum.term());
            blockWriter.addLine(lastTerm, blockTermState, dictionaryBuilder);
        }
        blockWriter.finishLastBlock(dictionaryBuilder);
        if (fieldMetadata.getNumTerms() > 0) {
            fieldMetadata.setLastTerm(lastTerm);
            fieldMetadata.write(fieldsOutput);
            this.writeDictionary(dictionaryBuilder);
            return 1;
        }
        return 0;
    }

    protected BlockTermState writePostingLine(TermsEnum termsEnum, FieldMetadata fieldMetadata, NormsProducer normsProducer) throws IOException {
        BlockTermState state = this.postingsWriter.writeTerm(termsEnum.term(), termsEnum, fieldMetadata.getDocsSeen(), normsProducer);
        if (state == null) {
            return null;
        }
        fieldMetadata.updateStats(state);
        return state;
    }

    protected void writeDictionary(IndexDictionary.Builder dictionaryBuilder) throws IOException {
        dictionaryBuilder.build().write((DataOutput)this.dictionaryOutput, this.blockEncoder);
    }

    public void close() throws IOException {
        IOUtils.close((Closeable[])new Closeable[]{this.blockOutput, this.dictionaryOutput, this.postingsWriter});
    }
}

