/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.spatial4j.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.prep.PreparedGeometry;
import org.locationtech.jts.geom.prep.PreparedGeometryFactory;
import org.locationtech.spatial4j.util.GeomBuilder;

public class Geom {
    public static final GeometryFactory factory = new GeometryFactory();

    public static GeomBuilder build() {
        return new GeomBuilder();
    }

    public static Point point(double x, double y) {
        return Geom.build().point(x, y).toPoint();
    }

    public static LineString lineString(double ... ord) {
        return Geom.build().points(ord).toLineString();
    }

    public static Polygon polygon(double ... ord) {
        return Geom.build().points(ord).toPolygon();
    }

    public static Iterable<Point> iterate(MultiPoint mp) {
        return new GeometryIterable<Point>((GeometryCollection)mp);
    }

    public static Iterable<LineString> iterate(MultiLineString ml) {
        return new GeometryIterable<LineString>((GeometryCollection)ml);
    }

    public static Iterable<Polygon> iterate(MultiPolygon mp) {
        return new GeometryIterable<Polygon>((GeometryCollection)mp);
    }

    public static Iterable<Geometry> iterate(GeometryCollection gc) {
        return new GeometryIterable<Geometry>(gc);
    }

    public static Iterable<LineString> holes(final Polygon p) {
        return new Iterable<LineString>(){
            int i = 0;

            @Override
            public Iterator<LineString> iterator() {
                return new Iterator<LineString>(){

                    @Override
                    public boolean hasNext() {
                        return i < p.getNumInteriorRing();
                    }

                    @Override
                    public LineString next() {
                        return p.getInteriorRingN(i++);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public static Point first(MultiPoint mp) {
        return mp.getNumGeometries() > 0 ? (Point)mp.getGeometryN(0) : null;
    }

    public static LineString first(MultiLineString ml) {
        return ml.getNumGeometries() > 0 ? (LineString)ml.getGeometryN(0) : null;
    }

    public static Polygon first(MultiPolygon mp) {
        return mp.getNumGeometries() > 0 ? (Polygon)mp.getGeometryN(0) : null;
    }

    public static <T extends Geometry> T[] array(GeometryCollection gc, T[] array) {
        for (int i = 0; i < gc.getNumGeometries(); ++i) {
            array[i] = gc.getGeometryN(i);
        }
        return array;
    }

    public static <T extends Geometry> T narrow(GeometryCollection gc) {
        if (gc.getNumGeometries() == 0) {
            return (T)gc;
        }
        ArrayList<Geometry> objects = new ArrayList<Geometry>(gc.getNumGeometries());
        for (Geometry g : Geom.iterate(gc)) {
            objects.add(g);
        }
        return (T)gc.getFactory().buildGeometry(objects);
    }

    public static <T extends Geometry> List<T> flatten(GeometryCollection gc) {
        return Geom.flatten(Collections.singletonList(gc));
    }

    public static <T extends Geometry> List<T> flatten(List<Geometry> gl) {
        ArrayList<Geometry> flat = new ArrayList<Geometry>();
        LinkedList<Geometry> q = new LinkedList<Geometry>();
        q.addAll(gl);
        while (!q.isEmpty()) {
            Geometry g = (Geometry)q.removeFirst();
            if (g instanceof GeometryCollection) {
                for (Geometry h : Geom.iterate((GeometryCollection)g)) {
                    q.addLast(h);
                }
                continue;
            }
            flat.add(g);
        }
        return flat;
    }

    public static Geometry singlify(Geometry geom) {
        while (geom instanceof GeometryCollection && geom.getNumGeometries() == 1) {
            geom = geom.getGeometryN(0);
        }
        return geom;
    }

    public static PreparedGeometry prepare(Geometry g) {
        return PreparedGeometryFactory.prepare((Geometry)g);
    }

    public static GeometryCollection multi(Geometry g) {
        switch (Type.from(g)) {
            case POINT: {
                return factory.createMultiPoint(new Point[]{(Point)g});
            }
            case LINESTRING: {
                return factory.createMultiLineString(new LineString[]{(LineString)g});
            }
            case POLYGON: {
                return factory.createMultiPolygon(new Polygon[]{(Polygon)g});
            }
        }
        return (GeometryCollection)g;
    }

    private static class GeometryIterator<T extends Geometry>
    implements Iterator<T> {
        int i = 0;
        GeometryCollection gc;

        GeometryIterator(GeometryCollection gc) {
            this.gc = gc;
        }

        @Override
        public boolean hasNext() {
            return this.i < this.gc.getNumGeometries();
        }

        @Override
        public T next() {
            return (T)this.gc.getGeometryN(this.i++);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class GeometryIterable<T extends Geometry>
    implements Iterable<T> {
        GeometryCollection gc;

        GeometryIterable(GeometryCollection gc) {
            this.gc = gc;
        }

        @Override
        public Iterator<T> iterator() {
            return new GeometryIterator(this.gc);
        }
    }

    public static enum Type {
        POINT(Point.class),
        LINESTRING(LineString.class),
        POLYGON(Polygon.class),
        MULTIPOINT(MultiPoint.class),
        MULTILINESTRING(MultiLineString.class),
        MULTIPOLYGON(MultiPolygon.class),
        GEOMETRY(Geometry.class),
        GEOMETRYCOLLECTION(GeometryCollection.class);

        private final Class<? extends Geometry> type;
        private final String name;
        private final String simpleName;

        private Type(Class<? extends Geometry> type) {
            this.type = type;
            this.name = type.getSimpleName();
            this.simpleName = this.name.startsWith("Multi") ? this.name.substring(5) : this.name;
        }

        public Class<? extends Geometry> getType() {
            return this.type;
        }

        public String toString() {
            return this.name;
        }

        public String getName() {
            return this.name;
        }

        public String getSimpleName() {
            return this.simpleName;
        }

        public static Type from(Geometry geom) {
            if (geom != null) {
                return Type.from(geom.getClass());
            }
            return null;
        }

        public static Type from(Class<?> geomClass) {
            for (Type gt : Type.values()) {
                if (gt.type != geomClass) continue;
                return gt;
            }
            Type match = null;
            for (Type gt : Type.values()) {
                if (gt == GEOMETRY || gt == GEOMETRYCOLLECTION || !gt.type.isAssignableFrom(geomClass)) continue;
                if (match == null) {
                    match = gt;
                    continue;
                }
                return null;
            }
            if (match == null) {
                if (GeometryCollection.class.isAssignableFrom(geomClass)) {
                    return GEOMETRYCOLLECTION;
                }
                if (Geometry.class.isAssignableFrom(geomClass)) {
                    return GEOMETRY;
                }
            }
            return match;
        }

        public static Type from(String name) {
            for (Type gt : Type.values()) {
                if (!gt.getName().equalsIgnoreCase(name)) continue;
                return gt;
            }
            return null;
        }
    }
}

