/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.spatial4j.shape;

import com.carrotsearch.randomizedtesting.annotations.ParametersFactory;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.spatial4j.context.SpatialContext;
import org.locationtech.spatial4j.context.SpatialContextFactory;
import org.locationtech.spatial4j.context.jts.JtsSpatialContextFactory;
import org.locationtech.spatial4j.exception.InvalidShapeException;
import org.locationtech.spatial4j.shape.AbstractTestShapes;
import org.locationtech.spatial4j.shape.Circle;
import org.locationtech.spatial4j.shape.Point;
import org.locationtech.spatial4j.shape.Rectangle;
import org.locationtech.spatial4j.shape.Shape;
import org.locationtech.spatial4j.shape.ShapeCollection;
import org.locationtech.spatial4j.shape.SpatialRelation;
import org.locationtech.spatial4j.shape.impl.BufferedLine;
import org.locationtech.spatial4j.shape.impl.BufferedLineString;
import org.locationtech.spatial4j.shape.impl.CircleImpl;
import org.locationtech.spatial4j.shape.impl.PointImpl;
import org.locationtech.spatial4j.shape.impl.RectangleImpl;

public class TestShapes2D
extends AbstractTestShapes {
    @ParametersFactory
    public static Iterable<Object[]> parameters() {
        RectangleImpl WB = new RectangleImpl(-2000.0, 2000.0, -300.0, 300.0, null);
        ArrayList<Object[]> ctxs = new ArrayList<Object[]>();
        ctxs.add(TestShapes2D.$((Object[])new Object[]{new SpatialContextFactory((Rectangle)WB){
            final /* synthetic */ Rectangle val$WB;
            {
                this.val$WB = rectangle;
                this.geo = false;
                this.worldBounds = this.val$WB;
            }
        }.newSpatialContext()}));
        ctxs.add(TestShapes2D.$((Object[])new Object[]{new JtsSpatialContextFactory((Rectangle)WB){
            final /* synthetic */ Rectangle val$WB;
            {
                this.val$WB = rectangle;
                this.geo = false;
                this.worldBounds = this.val$WB;
            }
        }.newSpatialContext()}));
        return ctxs;
    }

    public TestShapes2D(SpatialContext ctx) {
        super(ctx);
    }

    @Test
    public void testSimplePoint() {
        try {
            this.ctx.makePoint(2001.0, 0.0);
            Assert.fail();
        }
        catch (InvalidShapeException invalidShapeException) {
            // empty catch block
        }
        try {
            this.ctx.makePoint(0.0, -301.0);
            Assert.fail();
        }
        catch (InvalidShapeException invalidShapeException) {
            // empty catch block
        }
        Point pt = this.ctx.makePoint(0.0, 0.0);
        String msg = pt.toString();
        Point pt2 = this.ctx.makePoint(0.0, 0.0);
        Assert.assertEquals((String)msg, (Object)pt, (Object)pt2);
        Assert.assertEquals((String)msg, (long)pt.hashCode(), (long)pt2.hashCode());
        Assert.assertFalse((String)msg, (boolean)pt.hasArea());
        Assert.assertEquals((String)msg, (Object)pt.getCenter(), (Object)pt);
        Rectangle bbox = pt.getBoundingBox();
        Assert.assertFalse((String)msg, (boolean)bbox.hasArea());
        Assert.assertEquals((String)msg, (Object)pt, (Object)bbox.getCenter());
        this.assertRelation(msg, SpatialRelation.CONTAINS, (Shape)pt, (Shape)pt2);
        this.assertRelation(msg, SpatialRelation.DISJOINT, (Shape)pt, (Shape)this.ctx.makePoint(0.0, 1.0));
        this.assertRelation(msg, SpatialRelation.DISJOINT, (Shape)pt, (Shape)this.ctx.makePoint(1.0, 0.0));
        this.assertRelation(msg, SpatialRelation.DISJOINT, (Shape)pt, (Shape)this.ctx.makePoint(1.0, 1.0));
        pt.reset(1.0, 2.0);
        Assert.assertEquals((Object)this.ctx.makePoint(1.0, 2.0), (Object)pt);
        Assert.assertEquals((Object)this.ctx.makeCircle(pt, 3.0), (Object)pt.getBuffered(3.0, this.ctx));
        this.testEmptiness((Shape)this.ctx.makePoint(Double.NaN, Double.NaN));
    }

    @Test
    public void testSimpleRectangle() {
        double[] minXs;
        double v = 2001 * (TestShapes2D.randomBoolean() ? -1 : 1);
        try {
            this.ctx.makeRectangle(v, 0.0, 0.0, 0.0);
            Assert.fail();
        }
        catch (InvalidShapeException invalidShapeException) {
            // empty catch block
        }
        try {
            this.ctx.makeRectangle(0.0, v, 0.0, 0.0);
            Assert.fail();
        }
        catch (InvalidShapeException invalidShapeException) {
            // empty catch block
        }
        try {
            this.ctx.makeRectangle(0.0, 0.0, v, 0.0);
            Assert.fail();
        }
        catch (InvalidShapeException invalidShapeException) {
            // empty catch block
        }
        try {
            this.ctx.makeRectangle(0.0, 0.0, 0.0, v);
            Assert.fail();
        }
        catch (InvalidShapeException invalidShapeException) {
            // empty catch block
        }
        try {
            this.ctx.makeRectangle(0.0, 0.0, 10.0, -10.0);
            Assert.fail();
        }
        catch (InvalidShapeException invalidShapeException) {
            // empty catch block
        }
        try {
            this.ctx.makeRectangle(10.0, -10.0, 0.0, 0.0);
            Assert.fail();
        }
        catch (InvalidShapeException invalidShapeException) {
            // empty catch block
        }
        for (double minX : minXs = new double[]{-1000.0, -360.0, -180.0, -20.0, 0.0, 20.0, 180.0, 1000.0}) {
            double[] widths;
            for (double width : widths = new double[]{0.0, 10.0, 180.0, 360.0, 400.0}) {
                this.testRectangle(minX, width, 0.0, 0.0);
                this.testRectangle(minX, width, -10.0, 10.0);
                this.testRectangle(minX, width, 5.0, 10.0);
            }
        }
        Rectangle r = this.ctx.makeRectangle(0.0, 0.0, 0.0, 0.0);
        r.reset(1.0, 2.0, 3.0, 4.0);
        Assert.assertEquals((Object)this.ctx.makeRectangle(1.0, 2.0, 3.0, 4.0), (Object)r);
        this.testRectIntersect();
        if (!this.ctx.isGeo()) {
            Assert.assertEquals((Object)this.ctx.makeRectangle(0.9, 2.1, 2.9, 4.1), (Object)this.ctx.makeRectangle(1.0, 2.0, 3.0, 4.0).getBuffered(0.1, this.ctx));
        }
        this.testEmptiness((Shape)this.ctx.makeRectangle(Double.NaN, Double.NaN, Double.NaN, Double.NaN));
    }

    @Test
    public void testSimpleCircle() {
        double[] theXs;
        for (double x : theXs = new double[]{-10.0, 0.0, 10.0}) {
            double[] theYs;
            for (double y : theYs = new double[]{-20.0, 0.0, 20.0}) {
                this.testCircle(x, y, 0.0);
                this.testCircle(x, y, 5.0);
            }
        }
        TestShapes2D.testCircleReset(this.ctx);
        Assert.assertEquals((String)"getX not getY", (Object)SpatialRelation.INTERSECTS, (Object)this.ctx.makeCircle(107.0, -81.0, 147.0).relate((Shape)this.ctx.makeRectangle(92.0, 121.0, -89.0, 74.0)));
        this.testCircleIntersect();
        Assert.assertEquals((Object)this.ctx.makeCircle(1.0, 2.0, 10.0), (Object)this.ctx.makeCircle(1.0, 2.0, 6.0).getBuffered(4.0, this.ctx));
        this.testEmptiness((Shape)this.ctx.makeCircle(Double.NaN, Double.NaN, TestShapes2D.randomBoolean() ? 0.0 : Double.NaN));
    }

    static void testCircleReset(SpatialContext ctx) {
        Circle c = ctx.makeCircle(3.0, 4.0, 5.0);
        Circle c2 = ctx.makeCircle(5.0, 6.0, 7.0);
        c2.reset(3.0, 4.0, 5.0);
        Assert.assertEquals((Object)c, (Object)c2);
        Assert.assertEquals((Object)c.getBoundingBox(), (Object)c2.getBoundingBox());
    }

    @Test
    public void testLineString() {
        Shape shape = this.ctx.getShapeFactory().lineString().buffer((double)TestShapes2D.randomInt((int)3)).build();
        this.testEmptiness(shape);
    }

    @Test
    public void testImplementsEqualsAndHash() throws Exception {
        TestShapes2D.checkShapesImplementEquals(new Class[]{PointImpl.class, CircleImpl.class, RectangleImpl.class, ShapeCollection.class, BufferedLineString.class, BufferedLine.class});
    }
}

