/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.spatial4j.io;

import java.text.ParseException;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.spatial4j.context.SpatialContext;
import org.locationtech.spatial4j.context.SpatialContextFactory;
import org.locationtech.spatial4j.io.WKTReader;
import org.locationtech.spatial4j.io.WktShapeParserTest;
import org.locationtech.spatial4j.shape.Shape;
import org.locationtech.spatial4j.shape.impl.PointImpl;

public class WktCustomShapeParserTest
extends WktShapeParserTest {
    public WktCustomShapeParserTest() {
        super(WktCustomShapeParserTest.makeCtx());
    }

    private static SpatialContext makeCtx() {
        SpatialContextFactory factory = new SpatialContextFactory();
        factory.readers.clear();
        factory.readers.add(MyWKTShapeParser.class);
        return factory.newSpatialContext();
    }

    @Test
    public void testCustomShape() throws ParseException {
        Assert.assertEquals((Object)"customShape", (Object)((CustomShape)this.wkt("customShape()")).name);
        Assert.assertEquals((Object)"custom3d", (Object)((CustomShape)this.wkt("custom3d ()")).name);
    }

    @Test
    public void testNextSubShapeString() throws ParseException {
        WKTReader.State state = ((WKTReader)this.ctx.getFormats().getWktReader()).newState("OUTER(INNER(3, 5))");
        state.offset = 0;
        Assert.assertEquals((Object)"OUTER(INNER(3, 5))", (Object)state.nextSubShapeString());
        Assert.assertEquals((long)"OUTER(INNER(3, 5))".length(), (long)state.offset);
        state.offset = "OUTER(".length();
        Assert.assertEquals((Object)"INNER(3, 5)", (Object)state.nextSubShapeString());
        Assert.assertEquals((long)"OUTER(INNER(3, 5)".length(), (long)state.offset);
        state.offset = "OUTER(INNER(".length();
        Assert.assertEquals((Object)"3", (Object)state.nextSubShapeString());
        Assert.assertEquals((long)"OUTER(INNER(3".length(), (long)state.offset);
    }

    public static class MyWKTShapeParser
    extends WKTReader {
        public MyWKTShapeParser(SpatialContext ctx, SpatialContextFactory factory) {
            super(ctx, factory);
        }

        protected WKTReader.State newState(String wkt) {
            Object other = null;
            return new WKTReader.State((WKTReader)this, wkt);
        }

        public Shape parseShapeByType(WKTReader.State state, String shapeType) throws ParseException {
            Shape result = super.parseShapeByType(state, shapeType);
            if (result == null && shapeType.contains("custom")) {
                state.nextExpect('(');
                state.nextExpect(')');
                return new CustomShape(shapeType, this.ctx);
            }
            return result;
        }
    }

    static class CustomShape
    extends PointImpl {
        private final String name;

        public CustomShape(String name, SpatialContext ctx) {
            super(0.0, 0.0, ctx);
            this.name = name;
        }
    }
}

