/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.byTask.tasks;

import java.text.BreakIterator;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.benchmark.byTask.PerfRunData;
import org.apache.lucene.benchmark.byTask.tasks.SearchTravTask;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.highlight.DefaultEncoder;
import org.apache.lucene.search.highlight.Encoder;
import org.apache.lucene.search.highlight.Formatter;
import org.apache.lucene.search.highlight.Highlighter;
import org.apache.lucene.search.highlight.QueryScorer;
import org.apache.lucene.search.highlight.Scorer;
import org.apache.lucene.search.highlight.SimpleHTMLFormatter;
import org.apache.lucene.search.highlight.TokenSources;
import org.apache.lucene.search.uhighlight.UnifiedHighlighter;
import org.apache.lucene.search.vectorhighlight.BoundaryScanner;
import org.apache.lucene.search.vectorhighlight.BreakIteratorBoundaryScanner;
import org.apache.lucene.search.vectorhighlight.FastVectorHighlighter;
import org.apache.lucene.search.vectorhighlight.FieldQuery;
import org.apache.lucene.search.vectorhighlight.FragListBuilder;
import org.apache.lucene.search.vectorhighlight.FragmentsBuilder;
import org.apache.lucene.search.vectorhighlight.ScoreOrderFragmentsBuilder;
import org.apache.lucene.search.vectorhighlight.WeightedFragListBuilder;
import org.apache.lucene.util.ArrayUtil;

public class SearchTravRetHighlightTask
extends SearchTravTask {
    private int maxDocCharsToAnalyze;
    private int maxFrags = 1;
    private Set<String> hlFields = Collections.singleton("body");
    private String type;
    private HLImpl hlImpl;
    private Analyzer analyzer;
    private volatile int preventOptimizeAway = 0;

    public SearchTravRetHighlightTask(PerfRunData runData) {
        super(runData);
    }

    @Override
    public void setParams(String params) {
        String[] splits;
        this.params = params;
        for (String split : splits = params.split(",")) {
            if (split.startsWith("type[")) {
                this.type = split.substring("type[".length(), split.length() - 1);
                continue;
            }
            if (split.startsWith("maxFrags[")) {
                this.maxFrags = (int)Float.parseFloat(split.substring("maxFrags[".length(), split.length() - 1));
                continue;
            }
            if (!split.startsWith("fields[")) continue;
            String fieldNames = split.substring("fields[".length(), split.length() - 1);
            String[] fieldSplits = fieldNames.split(";");
            this.hlFields = new HashSet<String>(Arrays.asList(fieldSplits));
        }
    }

    @Override
    public void setup() throws Exception {
        super.setup();
        PerfRunData data = this.getRunData();
        if (!data.getConfig().get("doc.stored", false)) {
            throw new Exception("doc.stored must be set to true");
        }
        this.maxDocCharsToAnalyze = data.getConfig().get("highlighter.maxDocCharsToAnalyze", 51200);
        this.analyzer = data.getAnalyzer();
        String type = this.type;
        if (type == null) {
            type = data.getConfig().get("highlighter", null);
        }
        switch (type) {
            case "NONE": {
                this.hlImpl = new NoHLImpl();
                break;
            }
            case "SH_A": {
                this.hlImpl = new StandardHLImpl(false);
                break;
            }
            case "SH_V": {
                this.hlImpl = new StandardHLImpl(true);
                break;
            }
            case "FVH_V": {
                this.hlImpl = new FastVectorHLImpl();
                break;
            }
            case "UH": {
                this.hlImpl = new UnifiedHLImpl(null);
                break;
            }
            case "UH_A": {
                this.hlImpl = new UnifiedHLImpl(UnifiedHighlighter.OffsetSource.ANALYSIS);
                break;
            }
            case "UH_V": {
                this.hlImpl = new UnifiedHLImpl(UnifiedHighlighter.OffsetSource.TERM_VECTORS);
                break;
            }
            case "UH_P": {
                this.hlImpl = new UnifiedHLImpl(UnifiedHighlighter.OffsetSource.POSTINGS);
                break;
            }
            case "UH_PV": {
                this.hlImpl = new UnifiedHLImpl(UnifiedHighlighter.OffsetSource.POSTINGS_WITH_TERM_VECTORS);
                break;
            }
            default: {
                throw new Exception("unrecognized highlighter type: " + type + " (try 'UH')");
            }
        }
    }

    @Override
    protected int withTopDocs(IndexSearcher searcher, Query q, TopDocs hits) throws Exception {
        this.hlImpl.withTopDocs(searcher, q, hits);
        return hits.scoreDocs.length;
    }

    private ScoreDoc[] docIdOrder(ScoreDoc[] scoreDocs) {
        Object[] clone = new ScoreDoc[scoreDocs.length];
        System.arraycopy(scoreDocs, 0, clone, 0, scoreDocs.length);
        ArrayUtil.introSort((Object[])clone, (a, b) -> Integer.compare(a.doc, b.doc));
        return clone;
    }

    private class NoHLImpl
    implements HLImpl {
        private NoHLImpl() {
        }

        @Override
        public void withTopDocs(IndexSearcher searcher, Query q, TopDocs hits) throws Exception {
            for (ScoreDoc scoreDoc : SearchTravRetHighlightTask.this.docIdOrder(hits.scoreDocs)) {
                SearchTravRetHighlightTask.this.preventOptimizeAway = SearchTravRetHighlightTask.this.preventOptimizeAway + (searcher.doc(scoreDoc.doc, SearchTravRetHighlightTask.this.hlFields).iterator().hasNext() ? 2 : 1);
            }
        }
    }

    private class UnifiedHLImpl
    implements HLImpl {
        UnifiedHighlighter highlighter;
        IndexSearcher lastSearcher;
        UnifiedHighlighter.OffsetSource offsetSource;
        String[] fields;
        int[] maxPassages;

        UnifiedHLImpl(UnifiedHighlighter.OffsetSource offsetSource) {
            this.fields = SearchTravRetHighlightTask.this.hlFields.toArray(new String[SearchTravRetHighlightTask.this.hlFields.size()]);
            this.offsetSource = offsetSource;
            this.maxPassages = new int[SearchTravRetHighlightTask.this.hlFields.size()];
            Arrays.fill(this.maxPassages, SearchTravRetHighlightTask.this.maxFrags);
        }

        private void reset(IndexSearcher searcher) {
            if (this.lastSearcher == searcher) {
                return;
            }
            this.lastSearcher = searcher;
            this.highlighter = new UnifiedHighlighter(searcher, SearchTravRetHighlightTask.this.analyzer){

                protected UnifiedHighlighter.OffsetSource getOffsetSource(String field) {
                    return UnifiedHLImpl.this.offsetSource != null ? UnifiedHLImpl.this.offsetSource : super.getOffsetSource(field);
                }
            };
            this.highlighter.setBreakIterator(() -> BreakIterator.getSentenceInstance(Locale.ENGLISH));
            this.highlighter.setMaxLength(SearchTravRetHighlightTask.this.maxDocCharsToAnalyze);
            this.highlighter.setHighlightPhrasesStrictly(true);
            this.highlighter.setHandleMultiTermQuery(true);
        }

        @Override
        public void withTopDocs(IndexSearcher searcher, Query q, TopDocs hits) throws Exception {
            this.reset(searcher);
            Map result = this.highlighter.highlightFields(this.fields, q, hits, this.maxPassages);
            SearchTravRetHighlightTask.this.preventOptimizeAway = result.size();
        }
    }

    private class FastVectorHLImpl
    implements HLImpl {
        int fragSize = 100;
        WeightedFragListBuilder fragListBuilder = new WeightedFragListBuilder();
        BoundaryScanner bs = new BreakIteratorBoundaryScanner(BreakIterator.getSentenceInstance(Locale.ENGLISH));
        ScoreOrderFragmentsBuilder fragmentsBuilder = new ScoreOrderFragmentsBuilder(this.bs);
        String[] preTags = new String[]{"<em>"};
        String[] postTags = new String[]{"</em>"};
        Encoder encoder = new DefaultEncoder();
        FastVectorHighlighter highlighter = new FastVectorHighlighter(true, false);

        private FastVectorHLImpl() {
        }

        @Override
        public void withTopDocs(IndexSearcher searcher, Query q, TopDocs hits) throws Exception {
            IndexReader reader = searcher.getIndexReader();
            FieldQuery fq = this.highlighter.getFieldQuery(q, reader);
            for (ScoreDoc scoreDoc : SearchTravRetHighlightTask.this.docIdOrder(hits.scoreDocs)) {
                for (String hlField : SearchTravRetHighlightTask.this.hlFields) {
                    String[] fragments = this.highlighter.getBestFragments(fq, reader, scoreDoc.doc, hlField, this.fragSize, SearchTravRetHighlightTask.this.maxFrags, (FragListBuilder)this.fragListBuilder, (FragmentsBuilder)this.fragmentsBuilder, this.preTags, this.postTags, this.encoder);
                    SearchTravRetHighlightTask.this.preventOptimizeAway = fragments.length;
                }
            }
        }
    }

    private class StandardHLImpl
    implements HLImpl {
        SimpleHTMLFormatter formatter = new SimpleHTMLFormatter("<em>", "</em>");
        DefaultEncoder encoder = new DefaultEncoder();
        Highlighter highlighter = new Highlighter((Formatter)this.formatter, (Encoder)this.encoder, null);
        boolean termVecs;

        StandardHLImpl(boolean termVecs) {
            this.highlighter.setEncoder((Encoder)new DefaultEncoder());
            this.highlighter.setMaxDocCharsToAnalyze(SearchTravRetHighlightTask.this.maxDocCharsToAnalyze);
            this.termVecs = termVecs;
        }

        @Override
        public void withTopDocs(IndexSearcher searcher, Query q, TopDocs hits) throws Exception {
            IndexReader reader = searcher.getIndexReader();
            this.highlighter.setFragmentScorer((Scorer)new QueryScorer(q));
            for (ScoreDoc scoreDoc : SearchTravRetHighlightTask.this.docIdOrder(hits.scoreDocs)) {
                Document document = reader.document(scoreDoc.doc, SearchTravRetHighlightTask.this.hlFields);
                Fields tvFields = this.termVecs ? reader.getTermVectors(scoreDoc.doc) : null;
                for (IndexableField indexableField : document) {
                    TokenStream tokenStream = this.termVecs ? TokenSources.getTokenStream((String)indexableField.name(), (Fields)tvFields, (String)indexableField.stringValue(), (Analyzer)SearchTravRetHighlightTask.this.analyzer, (int)SearchTravRetHighlightTask.this.maxDocCharsToAnalyze) : SearchTravRetHighlightTask.this.analyzer.tokenStream(indexableField.name(), indexableField.stringValue());
                    String[] fragments = this.highlighter.getBestFragments(tokenStream, indexableField.stringValue(), SearchTravRetHighlightTask.this.maxFrags);
                    SearchTravRetHighlightTask.this.preventOptimizeAway = fragments.length;
                }
            }
        }
    }

    private static interface HLImpl {
        public void withTopDocs(IndexSearcher var1, Query var2, TopDocs var3) throws Exception;
    }
}

