/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.luke.app.desktop.components;

import java.util.Map;
import javax.swing.table.AbstractTableModel;
import org.apache.lucene.luke.app.desktop.components.TableColumnInfo;
import org.apache.lucene.luke.app.desktop.util.TableUtils;

public abstract class TableModelBase<T extends TableColumnInfo>
extends AbstractTableModel {
    private final Map<Integer, T> columnMap = TableUtils.columnMap((TableColumnInfo[])this.columnInfos());
    private final String[] colNames = TableUtils.columnNames((TableColumnInfo[])this.columnInfos());
    protected final Object[][] data;

    protected TableModelBase() {
        this.data = new Object[0][this.colNames.length];
    }

    protected TableModelBase(int rows) {
        this.data = new Object[rows][this.colNames.length];
    }

    protected abstract T[] columnInfos();

    @Override
    public int getRowCount() {
        return this.data.length;
    }

    @Override
    public int getColumnCount() {
        return this.colNames.length;
    }

    @Override
    public String getColumnName(int colIndex) {
        if (this.columnMap.containsKey(colIndex)) {
            return ((TableColumnInfo)this.columnMap.get(colIndex)).getColName();
        }
        return "";
    }

    @Override
    public Class<?> getColumnClass(int colIndex) {
        if (this.columnMap.containsKey(colIndex)) {
            return ((TableColumnInfo)this.columnMap.get(colIndex)).getType();
        }
        return Object.class;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.data[rowIndex][columnIndex];
    }
}

