/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.monitor;

import java.util.Collections;
import java.util.Set;
import java.util.function.BiConsumer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.index.Term;
import org.apache.lucene.monitor.CustomQueryHandler;
import org.apache.lucene.monitor.QueryTree;
import org.apache.lucene.monitor.SuffixingNGramTokenFilter;
import org.apache.lucene.monitor.TermWeightor;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.RegexpQuery;
import org.apache.lucene.util.BytesRef;

public class RegexpQueryHandler
implements CustomQueryHandler {
    public static final String DEFAULT_NGRAM_SUFFIX = "XX";
    public static final int DEFAULT_MAX_TOKEN_SIZE = 30;
    public static final String DEFAULT_WILDCARD_TOKEN = "__WILDCARD__";
    private final String ngramSuffix;
    private final String wildcardToken;
    private final BytesRef wildcardTokenBytes;
    private final int maxTokenSize;
    private final Set<String> excludedFields;

    public RegexpQueryHandler(String ngramSuffix, int maxTokenSize, String wildcardToken, Set<String> excludedFields) {
        this.ngramSuffix = ngramSuffix;
        this.maxTokenSize = maxTokenSize;
        this.wildcardTokenBytes = new BytesRef((CharSequence)wildcardToken);
        this.wildcardToken = wildcardToken;
        this.excludedFields = excludedFields == null ? Collections.emptySet() : excludedFields;
    }

    public RegexpQueryHandler() {
        this(DEFAULT_NGRAM_SUFFIX, 30, DEFAULT_WILDCARD_TOKEN, null);
    }

    public RegexpQueryHandler(int maxTokenSize) {
        this(DEFAULT_NGRAM_SUFFIX, maxTokenSize, DEFAULT_WILDCARD_TOKEN, null);
    }

    @Override
    public TokenStream wrapTermStream(String field, TokenStream ts) {
        if (this.excludedFields.contains(field)) {
            return ts;
        }
        return new SuffixingNGramTokenFilter(ts, this.ngramSuffix, this.wildcardToken, this.maxTokenSize);
    }

    @Override
    public QueryTree handleQuery(Query q, TermWeightor termWeightor) {
        if (!(q instanceof RegexpQuery)) {
            return null;
        }
        RegexpQuery query = (RegexpQuery)q;
        String regexp = RegexpQueryHandler.parseOutRegexp(query.toString(""));
        String selected = RegexpQueryHandler.selectLongestSubstring(regexp);
        final Term term = new Term(query.getField(), selected + this.ngramSuffix);
        final double weight = termWeightor.applyAsDouble(term);
        return new QueryTree(){

            @Override
            public double weight() {
                return weight;
            }

            @Override
            public void collectTerms(BiConsumer<String, BytesRef> termCollector) {
                termCollector.accept(term.field(), term.bytes());
                termCollector.accept(term.field(), RegexpQueryHandler.this.wildcardTokenBytes);
            }

            @Override
            public boolean advancePhase(double minWeight) {
                return false;
            }

            @Override
            public String toString(int depth) {
                return this.space(depth) + "WILDCARD_NGRAM[" + term.toString() + "]^" + weight;
            }
        };
    }

    private static String parseOutRegexp(String rep) {
        int fieldSepPos = rep.indexOf(":");
        int firstSlash = rep.indexOf("/", fieldSepPos);
        int lastSlash = rep.lastIndexOf("/");
        return rep.substring(firstSlash + 1, lastSlash);
    }

    private static String selectLongestSubstring(String regexp) {
        String selected = "";
        for (String substr : regexp.split("\\.|\\*|.\\?")) {
            if (substr.length() <= selected.length()) continue;
            selected = substr;
        }
        return selected;
    }
}

