/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.luke.app.desktop.util;

import java.io.Serializable;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.StringLayout;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.appender.AbstractOutputStreamAppender;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;

@Plugin(name="TextArea", category="Core", elementType="appender", printObject=true)
public final class TextAreaAppender
extends AbstractAppender {
    private static JTextArea textArea;
    private static final ReadWriteLock rwLock;
    private static final Lock readLock;
    private static final Lock writeLock;

    protected TextAreaAppender(String name, Filter filter, Layout<? extends Serializable> layout, boolean ignoreExceptions) {
        super(name, filter, layout, ignoreExceptions, Property.EMPTY_ARRAY);
    }

    public static void setTextArea(JTextArea ta) {
        writeLock.lock();
        try {
            if (textArea != null) {
                throw new IllegalStateException("TextArea already set.");
            }
            textArea = ta;
        }
        finally {
            writeLock.unlock();
        }
    }

    public void append(LogEvent event) {
        readLock.lock();
        try {
            if (textArea == null) {
                return;
            }
            String message = (String)((Object)((StringLayout)this.getLayout()).toSerializable(event));
            SwingUtilities.invokeLater(() -> textArea.append(message));
        }
        finally {
            readLock.unlock();
        }
    }

    @PluginBuilderFactory
    public static <B extends Builder<B>> B newBuilder() {
        return (B)((Object)((Builder)new Builder().asBuilder()));
    }

    static {
        rwLock = new ReentrantReadWriteLock();
        readLock = rwLock.readLock();
        writeLock = rwLock.writeLock();
    }

    public static class Builder<B extends Builder<B>>
    extends AbstractOutputStreamAppender.Builder<B>
    implements org.apache.logging.log4j.core.util.Builder<TextAreaAppender> {
        public TextAreaAppender build() {
            return new TextAreaAppender(this.getName(), this.getFilter(), (Layout<? extends Serializable>)this.getOrCreateLayout(), true);
        }
    }
}

