/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.monitor;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.lucene.monitor.MonitorQuery;
import org.apache.lucene.monitor.QueryDecomposer;
import org.apache.lucene.search.Query;

class QueryCacheEntry {
    final Query matchQuery;
    final String cacheId;
    final String queryId;
    final Map<String, String> metadata;

    private QueryCacheEntry(String cacheId, String queryId, Query matchQuery, Map<String, String> metadata) {
        this.cacheId = cacheId;
        this.queryId = queryId;
        this.matchQuery = matchQuery;
        this.metadata = metadata;
    }

    static List<QueryCacheEntry> decompose(MonitorQuery mq, QueryDecomposer decomposer) {
        int upto = 0;
        ArrayList<QueryCacheEntry> cacheEntries = new ArrayList<QueryCacheEntry>();
        for (Query subquery : decomposer.decompose(mq.getQuery())) {
            cacheEntries.add(new QueryCacheEntry(mq.getId() + "_" + upto, mq.getId(), subquery, mq.getMetadata()));
            ++upto;
        }
        return cacheEntries;
    }

    public String toString() {
        return this.queryId + "/" + this.cacheId + "/" + this.matchQuery;
    }
}

