/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.spatial4j.shape;

import com.carrotsearch.randomizedtesting.RandomizedTest;
import java.util.ArrayList;
import java.util.List;
import org.junit.Test;
import org.locationtech.spatial4j.context.SpatialContext;
import org.locationtech.spatial4j.context.SpatialContextFactory;
import org.locationtech.spatial4j.shape.Point;
import org.locationtech.spatial4j.shape.RectIntersectionTestHelper;
import org.locationtech.spatial4j.shape.Rectangle;
import org.locationtech.spatial4j.shape.impl.BufferedLineString;
import org.locationtech.spatial4j.shape.impl.RectangleImpl;

public class BufferedLineStringTest
extends RandomizedTest {
    private final SpatialContext ctx = new SpatialContextFactory(){
        {
            this.geo = false;
            this.worldBounds = new RectangleImpl(-100.0, 100.0, -50.0, 50.0, null);
        }
    }.newSpatialContext();

    @Test
    public void testRectIntersect() {
        new RectIntersectionTestHelper<BufferedLineString>(this.ctx){

            @Override
            protected BufferedLineString generateRandomShape(Point nearP) {
                Rectangle nearR = this.randomRectangle(nearP);
                int numPoints = 2 + 2.randomInt((int)3);
                ArrayList<Point> points = new ArrayList<Point>(numPoints);
                while (points.size() < numPoints) {
                    points.add(this.randomPointIn(nearR));
                }
                double maxBuf = Math.max(nearR.getWidth(), nearR.getHeight());
                double buf = Math.abs(2.randomGaussian()) * maxBuf / 4.0;
                buf = 2.randomInt((int)((int)this.divisible(buf)));
                return new BufferedLineString(points, buf, this.ctx);
            }

            @Override
            protected Point randomPointInEmptyShape(BufferedLineString shape) {
                List points = shape.getPoints();
                return (Point)points.get(2.randomInt((int)(points.size() - 1)));
            }
        }.testRelateWithRectangle();
    }
}

