/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.luke.util;

import java.nio.charset.StandardCharsets;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.FileAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.config.builder.api.ConfigurationBuilder;
import org.apache.logging.log4j.core.config.builder.api.ConfigurationBuilderFactory;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.lucene.luke.app.desktop.util.TextAreaAppender;

public class LoggerFactory {
    public static void initGuiLogging(String logFile) {
        ConfigurationBuilder builder = ConfigurationBuilderFactory.newConfigurationBuilder();
        builder.add(builder.newRootLogger(Level.INFO));
        LoggerContext context = Configurator.initialize((Configuration)((Configuration)builder.build()));
        PatternLayout layout = PatternLayout.newBuilder().withPattern("[%d{ISO8601}] %5p (%F:%L) - %m%n").withCharset(StandardCharsets.UTF_8).build();
        FileAppender fileAppender = ((FileAppender.Builder)((FileAppender.Builder)FileAppender.newBuilder().setName("File")).setLayout((Layout)layout)).withFileName(logFile).withAppend(false).build();
        fileAppender.start();
        TextAreaAppender textAreaAppender = ((TextAreaAppender.Builder)((TextAreaAppender.Builder)TextAreaAppender.newBuilder().setName("TextArea")).setLayout((Layout)layout)).build();
        textAreaAppender.start();
        context.getRootLogger().addAppender((Appender)fileAppender);
        context.getRootLogger().addAppender((Appender)textAreaAppender);
        context.updateLoggers();
    }

    public static Logger getLogger(Class<?> clazz) {
        return LogManager.getLogger(clazz);
    }
}

