/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.luke.app.desktop.util;

import java.lang.invoke.MethodHandles;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.luke.app.desktop.MessageBroker;
import org.apache.lucene.luke.models.LukeException;
import org.apache.lucene.luke.util.LoggerFactory;

public final class ExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public static void handle(Throwable t, MessageBroker messageBroker) {
        if (t instanceof LukeException) {
            Throwable cause = t.getCause();
            String message = cause == null ? t.getMessage() : t.getMessage() + " " + cause.getMessage();
            log.warn("Uncaught LukeException", t);
            messageBroker.showStatusMessage(message);
        } else {
            log.error("Uncaught Exception", t);
            messageBroker.showUnknownErrorMessage();
        }
    }
}

