/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.demo.facet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.WhitespaceAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.facet.DrillDownQuery;
import org.apache.lucene.facet.DrillSideways;
import org.apache.lucene.facet.FacetField;
import org.apache.lucene.facet.FacetResult;
import org.apache.lucene.facet.FacetsCollector;
import org.apache.lucene.facet.FacetsConfig;
import org.apache.lucene.facet.taxonomy.FastTaxonomyFacetCounts;
import org.apache.lucene.facet.taxonomy.TaxonomyReader;
import org.apache.lucene.facet.taxonomy.TaxonomyWriter;
import org.apache.lucene.facet.taxonomy.directory.DirectoryTaxonomyReader;
import org.apache.lucene.facet.taxonomy.directory.DirectoryTaxonomyWriter;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;

public class SimpleFacetsExample {
    private final Directory indexDir = new RAMDirectory();
    private final Directory taxoDir = new RAMDirectory();
    private final FacetsConfig config = new FacetsConfig();

    public SimpleFacetsExample() {
        this.config.setHierarchical("Publish Date", true);
    }

    private void index() throws IOException {
        IndexWriter indexWriter = new IndexWriter(this.indexDir, new IndexWriterConfig((Analyzer)new WhitespaceAnalyzer()).setOpenMode(IndexWriterConfig.OpenMode.CREATE));
        DirectoryTaxonomyWriter taxoWriter = new DirectoryTaxonomyWriter(this.taxoDir);
        Document doc = new Document();
        doc.add((IndexableField)new FacetField("Author", new String[]{"Bob"}));
        doc.add((IndexableField)new FacetField("Publish Date", new String[]{"2010", "10", "15"}));
        indexWriter.addDocument((Iterable)this.config.build((TaxonomyWriter)taxoWriter, doc));
        doc = new Document();
        doc.add((IndexableField)new FacetField("Author", new String[]{"Lisa"}));
        doc.add((IndexableField)new FacetField("Publish Date", new String[]{"2010", "10", "20"}));
        indexWriter.addDocument((Iterable)this.config.build((TaxonomyWriter)taxoWriter, doc));
        doc = new Document();
        doc.add((IndexableField)new FacetField("Author", new String[]{"Lisa"}));
        doc.add((IndexableField)new FacetField("Publish Date", new String[]{"2012", "1", "1"}));
        indexWriter.addDocument((Iterable)this.config.build((TaxonomyWriter)taxoWriter, doc));
        doc = new Document();
        doc.add((IndexableField)new FacetField("Author", new String[]{"Susan"}));
        doc.add((IndexableField)new FacetField("Publish Date", new String[]{"2012", "1", "7"}));
        indexWriter.addDocument((Iterable)this.config.build((TaxonomyWriter)taxoWriter, doc));
        doc = new Document();
        doc.add((IndexableField)new FacetField("Author", new String[]{"Frank"}));
        doc.add((IndexableField)new FacetField("Publish Date", new String[]{"1999", "5", "5"}));
        indexWriter.addDocument((Iterable)this.config.build((TaxonomyWriter)taxoWriter, doc));
        indexWriter.close();
        taxoWriter.close();
    }

    private List<FacetResult> facetsWithSearch() throws IOException {
        DirectoryReader indexReader = DirectoryReader.open((Directory)this.indexDir);
        IndexSearcher searcher = new IndexSearcher((IndexReader)indexReader);
        DirectoryTaxonomyReader taxoReader = new DirectoryTaxonomyReader(this.taxoDir);
        FacetsCollector fc = new FacetsCollector();
        FacetsCollector.search((IndexSearcher)searcher, (Query)new MatchAllDocsQuery(), (int)10, (Collector)fc);
        ArrayList<FacetResult> results = new ArrayList<FacetResult>();
        FastTaxonomyFacetCounts facets = new FastTaxonomyFacetCounts((TaxonomyReader)taxoReader, this.config, fc);
        results.add(facets.getTopChildren(10, "Author", new String[0]));
        results.add(facets.getTopChildren(10, "Publish Date", new String[0]));
        indexReader.close();
        taxoReader.close();
        return results;
    }

    private List<FacetResult> facetsOnly() throws IOException {
        DirectoryReader indexReader = DirectoryReader.open((Directory)this.indexDir);
        IndexSearcher searcher = new IndexSearcher((IndexReader)indexReader);
        DirectoryTaxonomyReader taxoReader = new DirectoryTaxonomyReader(this.taxoDir);
        FacetsCollector fc = new FacetsCollector();
        searcher.search((Query)new MatchAllDocsQuery(), (Collector)fc);
        ArrayList<FacetResult> results = new ArrayList<FacetResult>();
        FastTaxonomyFacetCounts facets = new FastTaxonomyFacetCounts((TaxonomyReader)taxoReader, this.config, fc);
        results.add(facets.getTopChildren(10, "Author", new String[0]));
        results.add(facets.getTopChildren(10, "Publish Date", new String[0]));
        indexReader.close();
        taxoReader.close();
        return results;
    }

    private FacetResult drillDown() throws IOException {
        DirectoryReader indexReader = DirectoryReader.open((Directory)this.indexDir);
        IndexSearcher searcher = new IndexSearcher((IndexReader)indexReader);
        DirectoryTaxonomyReader taxoReader = new DirectoryTaxonomyReader(this.taxoDir);
        DrillDownQuery q = new DrillDownQuery(this.config);
        q.add("Publish Date", new String[]{"2010"});
        FacetsCollector fc = new FacetsCollector();
        FacetsCollector.search((IndexSearcher)searcher, (Query)q, (int)10, (Collector)fc);
        FastTaxonomyFacetCounts facets = new FastTaxonomyFacetCounts((TaxonomyReader)taxoReader, this.config, fc);
        FacetResult result = facets.getTopChildren(10, "Author", new String[0]);
        indexReader.close();
        taxoReader.close();
        return result;
    }

    private List<FacetResult> drillSideways() throws IOException {
        DirectoryReader indexReader = DirectoryReader.open((Directory)this.indexDir);
        IndexSearcher searcher = new IndexSearcher((IndexReader)indexReader);
        DirectoryTaxonomyReader taxoReader = new DirectoryTaxonomyReader(this.taxoDir);
        DrillDownQuery q = new DrillDownQuery(this.config);
        q.add("Publish Date", new String[]{"2010"});
        DrillSideways ds = new DrillSideways(searcher, this.config, (TaxonomyReader)taxoReader);
        DrillSideways.DrillSidewaysResult result = ds.search(q, 10);
        List facets = result.facets.getAllDims(10);
        indexReader.close();
        taxoReader.close();
        return facets;
    }

    public List<FacetResult> runFacetOnly() throws IOException {
        this.index();
        return this.facetsOnly();
    }

    public List<FacetResult> runSearch() throws IOException {
        this.index();
        return this.facetsWithSearch();
    }

    public FacetResult runDrillDown() throws IOException {
        this.index();
        return this.drillDown();
    }

    public List<FacetResult> runDrillSideways() throws IOException {
        this.index();
        return this.drillSideways();
    }

    public static void main(String[] args) throws Exception {
        System.out.println("Facet counting example:");
        System.out.println("-----------------------");
        SimpleFacetsExample example = new SimpleFacetsExample();
        List<FacetResult> results1 = example.runFacetOnly();
        System.out.println("Author: " + results1.get(0));
        System.out.println("Publish Date: " + results1.get(1));
        System.out.println("Facet counting example (combined facets and search):");
        System.out.println("-----------------------");
        List<FacetResult> results = example.runSearch();
        System.out.println("Author: " + results.get(0));
        System.out.println("Publish Date: " + results.get(1));
        System.out.println("Facet drill-down example (Publish Date/2010):");
        System.out.println("---------------------------------------------");
        System.out.println("Author: " + example.runDrillDown());
        System.out.println("Facet drill-sideways example (Publish Date/2010):");
        System.out.println("---------------------------------------------");
        for (FacetResult result : example.runDrillSideways()) {
            System.out.println(result);
        }
    }
}

