/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.demo.facet;

import java.io.IOException;
import java.text.ParseException;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.WhitespaceAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.expressions.Bindings;
import org.apache.lucene.expressions.Expression;
import org.apache.lucene.expressions.SimpleBindings;
import org.apache.lucene.expressions.js.JavascriptCompiler;
import org.apache.lucene.facet.FacetField;
import org.apache.lucene.facet.FacetResult;
import org.apache.lucene.facet.FacetsCollector;
import org.apache.lucene.facet.FacetsConfig;
import org.apache.lucene.facet.taxonomy.TaxonomyFacetSumValueSource;
import org.apache.lucene.facet.taxonomy.TaxonomyReader;
import org.apache.lucene.facet.taxonomy.TaxonomyWriter;
import org.apache.lucene.facet.taxonomy.directory.DirectoryTaxonomyReader;
import org.apache.lucene.facet.taxonomy.directory.DirectoryTaxonomyWriter;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.DoubleValuesSource;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;

public class ExpressionAggregationFacetsExample {
    private final Directory indexDir = new RAMDirectory();
    private final Directory taxoDir = new RAMDirectory();
    private final FacetsConfig config = new FacetsConfig();

    private void index() throws IOException {
        IndexWriter indexWriter = new IndexWriter(this.indexDir, new IndexWriterConfig((Analyzer)new WhitespaceAnalyzer()).setOpenMode(IndexWriterConfig.OpenMode.CREATE));
        DirectoryTaxonomyWriter taxoWriter = new DirectoryTaxonomyWriter(this.taxoDir);
        Document doc = new Document();
        doc.add((IndexableField)new TextField("c", "foo bar", Field.Store.NO));
        doc.add((IndexableField)new NumericDocValuesField("popularity", 5L));
        doc.add((IndexableField)new FacetField("A", new String[]{"B"}));
        indexWriter.addDocument((Iterable)this.config.build((TaxonomyWriter)taxoWriter, doc));
        doc = new Document();
        doc.add((IndexableField)new TextField("c", "foo foo bar", Field.Store.NO));
        doc.add((IndexableField)new NumericDocValuesField("popularity", 3L));
        doc.add((IndexableField)new FacetField("A", new String[]{"C"}));
        indexWriter.addDocument((Iterable)this.config.build((TaxonomyWriter)taxoWriter, doc));
        indexWriter.close();
        taxoWriter.close();
    }

    private FacetResult search() throws IOException, ParseException {
        DirectoryReader indexReader = DirectoryReader.open((Directory)this.indexDir);
        IndexSearcher searcher = new IndexSearcher((IndexReader)indexReader);
        DirectoryTaxonomyReader taxoReader = new DirectoryTaxonomyReader(this.taxoDir);
        Expression expr = JavascriptCompiler.compile((String)"_score * sqrt(popularity)");
        SimpleBindings bindings = new SimpleBindings();
        bindings.add("_score", DoubleValuesSource.SCORES);
        bindings.add("popularity", DoubleValuesSource.fromLongField((String)"popularity"));
        FacetsCollector fc = new FacetsCollector(true);
        FacetsCollector.search((IndexSearcher)searcher, (Query)new MatchAllDocsQuery(), (int)10, (Collector)fc);
        TaxonomyFacetSumValueSource facets = new TaxonomyFacetSumValueSource((TaxonomyReader)taxoReader, this.config, fc, expr.getDoubleValuesSource((Bindings)bindings));
        FacetResult result = facets.getTopChildren(10, "A", new String[0]);
        indexReader.close();
        taxoReader.close();
        return result;
    }

    public FacetResult runSearch() throws IOException, ParseException {
        this.index();
        return this.search();
    }

    public static void main(String[] args) throws Exception {
        System.out.println("Facet counting example:");
        System.out.println("-----------------------");
        FacetResult result = new ExpressionAggregationFacetsExample().runSearch();
        System.out.println(result);
    }
}

