/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.monitor;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.monitor.CandidateMatcher;
import org.apache.lucene.monitor.MatcherFactory;
import org.apache.lucene.monitor.QueryMatch;
import org.apache.lucene.search.Matches;
import org.apache.lucene.search.MatchesIterator;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Weight;

public class HighlightsMatch
extends QueryMatch {
    public static final MatcherFactory<HighlightsMatch> MATCHER = searcher -> new CandidateMatcher<HighlightsMatch>(searcher){

        @Override
        protected void matchQuery(String queryId, Query matchQuery, Map<String, String> metadata) throws IOException {
            Weight w = this.searcher.createWeight(this.searcher.rewrite(matchQuery), ScoreMode.COMPLETE_NO_SCORES, 1.0f);
            for (LeafReaderContext ctx : this.searcher.getIndexReader().leaves()) {
                for (int i = 0; i < ctx.reader().maxDoc(); ++i) {
                    Matches matches = w.matches(ctx, i);
                    if (matches == null) continue;
                    this.addMatch(this.buildMatch(matches, queryId), i);
                }
            }
        }

        @Override
        public HighlightsMatch resolve(HighlightsMatch match1, HighlightsMatch match2) {
            return HighlightsMatch.merge(match1.getQueryId(), match1, match2);
        }

        private HighlightsMatch buildMatch(Matches matches, String queryId) throws IOException {
            HighlightsMatch m = new HighlightsMatch(queryId);
            for (String field : matches) {
                MatchesIterator mi = matches.getMatches(field);
                while (mi.next()) {
                    MatchesIterator sub = mi.getSubMatches();
                    if (sub != null) {
                        while (sub.next()) {
                            m.addHit(field, sub.startPosition(), sub.endPosition(), sub.startOffset(), sub.endOffset());
                        }
                        continue;
                    }
                    m.addHit(field, mi.startPosition(), mi.endPosition(), mi.startOffset(), mi.endOffset());
                }
            }
            return m;
        }
    };
    private final Map<String, Set<Hit>> hits = new TreeMap<String, Set<Hit>>();

    HighlightsMatch(String queryId) {
        super(queryId);
    }

    public Map<String, Set<Hit>> getHits() {
        return Collections.unmodifiableMap(this.hits);
    }

    public Set<String> getFields() {
        return Collections.unmodifiableSet(this.hits.keySet());
    }

    public Collection<Hit> getHits(String field) {
        Collection found = this.hits.get(field);
        if (found != null) {
            return Collections.unmodifiableCollection(found);
        }
        return Collections.emptyList();
    }

    public int getHitCount() {
        int c = 0;
        for (Set<Hit> fieldhits : this.hits.values()) {
            c += fieldhits.size();
        }
        return c;
    }

    static HighlightsMatch merge(String queryId, HighlightsMatch ... matches) {
        HighlightsMatch newMatch = new HighlightsMatch(queryId);
        for (HighlightsMatch match : matches) {
            for (String field : match.getFields()) {
                Set hitSet = newMatch.hits.computeIfAbsent(field, f -> new TreeSet());
                hitSet.addAll(match.getHits(field));
            }
        }
        return newMatch;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HighlightsMatch)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HighlightsMatch that = (HighlightsMatch)o;
        return !(this.hits != null ? !this.hits.equals(that.hits) : that.hits != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.hits != null ? this.hits.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return super.toString() + "{hits=" + this.hits + "}";
    }

    void addHit(String field, int startPos, int endPos, int startOffset, int endOffset) {
        Set hitSet = this.hits.computeIfAbsent(field, f -> new TreeSet());
        hitSet.add(new Hit(startPos, startOffset, endPos, endOffset));
    }

    public static class Hit
    implements Comparable<Hit> {
        public final int startPosition;
        public final int startOffset;
        public final int endPosition;
        public final int endOffset;

        public Hit(int startPosition, int startOffset, int endPosition, int endOffset) {
            this.startPosition = startPosition;
            this.startOffset = startOffset;
            this.endPosition = endPosition;
            this.endOffset = endOffset;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Hit)) {
                return false;
            }
            Hit other = (Hit)obj;
            return this.startOffset == other.startOffset && this.endOffset == other.endOffset && this.startPosition == other.startPosition && this.endPosition == other.endPosition;
        }

        public int hashCode() {
            int result = this.startPosition;
            result = 31 * result + this.startOffset;
            result = 31 * result + this.endPosition;
            result = 31 * result + this.endOffset;
            return result;
        }

        public String toString() {
            return String.format(Locale.ROOT, "%d(%d)->%d(%d)", this.startPosition, this.startOffset, this.endPosition, this.endOffset);
        }

        @Override
        public int compareTo(Hit other) {
            if (this.startPosition != other.startPosition) {
                return Integer.compare(this.startPosition, other.startPosition);
            }
            return Integer.compare(this.endPosition, other.endPosition);
        }
    }
}

