/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.spatial4j.shape.impl;

import com.carrotsearch.randomizedtesting.annotations.Repeat;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.spatial4j.context.SpatialContext;
import org.locationtech.spatial4j.shape.RandomizedShapeTest;
import org.locationtech.spatial4j.shape.Rectangle;
import org.locationtech.spatial4j.shape.Shape;
import org.locationtech.spatial4j.shape.SpatialRelation;
import org.locationtech.spatial4j.shape.impl.BBoxCalculator;

public class BBoxCalculatorTest
extends RandomizedShapeTest {
    public BBoxCalculatorTest() {
        super(SpatialContext.GEO);
    }

    @Test
    @Repeat(iterations=100)
    public void testGeoLongitude() {
        BBoxCalculator calc = new BBoxCalculator(this.ctx);
        int numShapes = BBoxCalculatorTest.randomIntBetween((int)1, (int)4);
        ArrayList<Rectangle> rects = new ArrayList<Rectangle>(numShapes);
        for (int i = 0; i < numShapes; ++i) {
            Rectangle rect = this.randomRectangle(30);
            rects.add(rect);
            calc.expandRange(rect);
        }
        Rectangle boundary = calc.getBoundary();
        if (numShapes == 1) {
            Assert.assertEquals(rects.get(0), (Object)boundary);
            return;
        }
        if (boundary.getMinX() == -180.0 && boundary.getMaxX() == 180.0) {
            for (int lon = -180; lon <= 180; ++lon) {
                Assert.assertTrue((boolean)this.atLeastOneRectHasLon(rects, lon));
            }
            return;
        }
        for (Rectangle rect : rects) {
            this.assertRelation(SpatialRelation.CONTAINS, (Shape)boundary, (Shape)rect);
        }
        Assert.assertTrue((boolean)this.atLeastOneRectHasLon(rects, boundary.getMinX()));
        Assert.assertFalse((boolean)this.atLeastOneRectHasLon(rects, this.normX(boundary.getMinX() - 0.5)));
        Assert.assertTrue((boolean)this.atLeastOneRectHasLon(rects, boundary.getMaxX()));
        Assert.assertFalse((boolean)this.atLeastOneRectHasLon(rects, this.normX(boundary.getMaxX() + 0.5)));
        if (boundary.getWidth() > 180.0) {
            double biggerGap = 360.0 - boundary.getWidth() + 0.5;
            for (Rectangle rect : rects) {
                double gapRectLeft = rect.getMaxX() + 0.25;
                double gapRectRight = gapRectLeft + biggerGap;
                Rectangle testGap = this.makeNormRect(gapRectLeft, gapRectRight, -90.0, 90.0);
                boolean fits = true;
                for (Rectangle rect2 : rects) {
                    if (!rect2.relate((Shape)testGap).intersects()) continue;
                    fits = false;
                    break;
                }
                Assert.assertFalse((boolean)fits);
            }
        }
    }

    private boolean atLeastOneRectHasLon(List<Rectangle> rects, double lon) {
        for (Rectangle rect : rects) {
            if (!rect.relateXRange(lon, lon).intersects()) continue;
            return true;
        }
        return false;
    }
}

