/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.spatial4j.io.jackson;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import org.junit.Test;
import org.locationtech.spatial4j.context.SpatialContext;
import org.locationtech.spatial4j.context.jts.JtsSpatialContext;
import org.locationtech.spatial4j.io.jackson.ObjectWithGeometry;
import org.locationtech.spatial4j.io.jackson.ShapesAsGeoJSONModule;
import org.locationtech.spatial4j.shape.RandomizedShapeTest;
import org.locationtech.spatial4j.util.GeomBuilder;

public class SimpleJacksonTest
extends RandomizedShapeTest {
    public SimpleJacksonTest() {
        super((SpatialContext)JtsSpatialContext.GEO);
    }

    @Test
    public void testReadWrite() throws IOException {
        GeomBuilder builder = new GeomBuilder();
        ObjectWithGeometry obj = new ObjectWithGeometry();
        obj.name = "Hello";
        obj.shape = this.randomPointIn(this.ctx.getWorldBounds());
        obj.geo = null;
        ObjectMapper mapper = new ObjectMapper();
        mapper.enable(SerializationFeature.INDENT_OUTPUT);
        mapper.registerModule((Module)new ShapesAsGeoJSONModule());
        String json = mapper.writeValueAsString((Object)obj);
        System.out.println(json);
        ObjectWithGeometry out = (ObjectWithGeometry)mapper.readValue(json, ObjectWithGeometry.class);
        System.out.println(">> AFTER <<");
        System.out.println(mapper.writeValueAsString((Object)out));
    }
}

