/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.spatial4j.io;

import com.carrotsearch.randomizedtesting.RandomizedTest;
import java.text.ParseException;
import java.util.Collections;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.spatial4j.context.SpatialContext;
import org.locationtech.spatial4j.io.WKTReader;
import org.locationtech.spatial4j.shape.Point;
import org.locationtech.spatial4j.shape.Rectangle;
import org.locationtech.spatial4j.shape.Shape;
import org.locationtech.spatial4j.shape.ShapeFactory;

public class WktShapeParserTest
extends RandomizedTest {
    final SpatialContext ctx;

    protected WktShapeParserTest(SpatialContext ctx) {
        this.ctx = ctx;
    }

    public WktShapeParserTest() {
        this(SpatialContext.GEO);
    }

    protected void assertParses(String wkt, Shape expected) throws ParseException {
        Assert.assertEquals((Object)this.wkt(wkt), (Object)expected);
    }

    protected Shape wkt(String wkt) throws ParseException {
        return this.wkt(this.ctx, wkt);
    }

    protected Shape wkt(SpatialContext ctx, String wkt) throws ParseException {
        return ((WKTReader)ctx.getFormats().getWktReader()).parse(wkt);
    }

    protected void assertFails(String wkt) {
        try {
            this.wkt(wkt);
            Assert.fail((String)"ParseException expected");
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    @Test
    public void testNoOp() throws ParseException {
        WKTReader wktShapeParser = (WKTReader)this.ctx.getFormats().getWktReader();
        Assert.assertNull((Object)wktShapeParser.parseIfSupported(""));
        Assert.assertNull((Object)wktShapeParser.parseIfSupported("  "));
        Assert.assertNull((Object)wktShapeParser.parseIfSupported("BogusShape()"));
        Assert.assertNull((Object)wktShapeParser.parseIfSupported("BogusShape"));
    }

    @Test
    public void testParsePoint() throws ParseException {
        this.assertParses("POINT (100 90)", (Shape)this.ctx.makePoint(100.0, 90.0));
        this.assertParses(" POINT (100 90) ", (Shape)this.ctx.makePoint(100.0, 90.0));
        this.assertParses("point (100 90)", (Shape)this.ctx.makePoint(100.0, 90.0));
        this.assertParses("POINT ( 100 90 )", (Shape)this.ctx.makePoint(100.0, 90.0));
        this.assertParses("POINT(100 90)", (Shape)this.ctx.makePoint(100.0, 90.0));
        this.assertParses("POINT (-45 90 )", (Shape)this.ctx.makePoint(-45.0, 90.0));
        Point expected = this.ctx.makePoint(-45.3, 80.4);
        this.assertParses("POINT (-45.3 80.4 )", (Shape)expected);
        this.assertParses("POINT (-45.3 +80.4 )", (Shape)expected);
        this.assertParses("POINT (-45.3 8.04e1 )", (Shape)expected);
        this.assertParses("POINT EMPTY", (Shape)this.ctx.makePoint(Double.NaN, Double.NaN));
        this.assertParses("POINT (100 90 2)", (Shape)this.ctx.makePoint(100.0, 90.0));
        this.assertParses("POINT (100 90 2 3)", (Shape)this.ctx.makePoint(100.0, 90.0));
        this.assertParses("POINT ZM ( 100 90 )", (Shape)this.ctx.makePoint(100.0, 90.0));
        this.assertParses("POINT ZM ( 100 90 -3 -4)", (Shape)this.ctx.makePoint(100.0, 90.0));
    }

    @Test
    public void testParsePoint_invalidDefinitions() {
        this.assertFails("POINT 100 90");
        this.assertFails("POINT (100 90");
        this.assertFails("POINT (100, 90)");
        this.assertFails("POINT 100 90)");
        this.assertFails("POINT (100)");
        this.assertFails("POINT (10f0 90)");
        this.assertFails("POINT (EMPTY)");
        this.assertFails("POINT (1 2), POINT (2 3)");
        this.assertFails("POINT EMPTY (1 2)");
        this.assertFails("POINT ZM EMPTY (1 2)");
        this.assertFails("POINT ZM EMPTY 1");
    }

    @Test
    public void testParseMultiPoint() throws ParseException {
        Shape s1 = ((ShapeFactory.MultiPointBuilder)this.ctx.getShapeFactory().multiPoint().pointXY(10.0, 40.0)).build();
        this.assertParses("MULTIPOINT (10 40)", s1);
        Shape s4 = ((ShapeFactory.MultiPointBuilder)((ShapeFactory.MultiPointBuilder)((ShapeFactory.MultiPointBuilder)((ShapeFactory.MultiPointBuilder)this.ctx.getShapeFactory().multiPoint().pointXY(10.0, 40.0)).pointXY(40.0, 30.0)).pointXY(20.0, 20.0)).pointXY(30.0, 10.0)).build();
        this.assertParses("MULTIPOINT ((10 40), (40 30), (20 20), (30 10))", s4);
        this.assertParses("MULTIPOINT (10 40, 40 30, 20 20, 30 10)", s4);
        this.assertParses("MULTIPOINT Z EMPTY", this.ctx.getShapeFactory().multiPoint().build());
    }

    @Test
    public void testParseEnvelope() throws ParseException {
        Rectangle r = this.ctx.makeRectangle(this.ctx.makePoint(10.0, 25.0), this.ctx.makePoint(30.0, 45.0));
        this.assertParses(" ENVELOPE ( 10 , 30 , 45 , 25 ) ", (Shape)r);
        this.assertParses("ENVELOPE(10,30,45,25) ", (Shape)r);
        this.assertFails("ENVELOPE (10 30 45 25)");
    }

    @Test
    public void testLineStringShape() throws ParseException {
        Shape ls = ((ShapeFactory.LineStringBuilder)((ShapeFactory.LineStringBuilder)((ShapeFactory.LineStringBuilder)this.ctx.getShapeFactory().lineString().pointXY(1.0, 10.0)).pointXY(2.0, 20.0)).pointXY(3.0, 30.0)).build();
        this.assertParses("LINESTRING (1 10, 2 20, 3 30)", ls);
        this.assertParses("LINESTRING EMPTY", this.ctx.makeLineString(Collections.emptyList()));
    }

    @Test
    public void testMultiLineStringShape() throws ParseException {
        ShapeFactory.MultiLineStringBuilder builder = this.ctx.getShapeFactory().multiLineString();
        builder.add((ShapeFactory.LineStringBuilder)((ShapeFactory.LineStringBuilder)((ShapeFactory.LineStringBuilder)builder.lineString().pointXY(10.0, 10.0)).pointXY(20.0, 20.0)).pointXY(10.0, 40.0));
        builder.add((ShapeFactory.LineStringBuilder)((ShapeFactory.LineStringBuilder)((ShapeFactory.LineStringBuilder)((ShapeFactory.LineStringBuilder)builder.lineString().pointXY(40.0, 40.0)).pointXY(30.0, 30.0)).pointXY(40.0, 20.0)).pointXY(30.0, 10.0));
        Shape s = builder.build();
        this.assertParses("MULTILINESTRING ((10 10, 20 20, 10 40),\n(40 40, 30 30, 40 20, 30 10))", s);
        this.assertParses("MULTILINESTRING M EMPTY", this.ctx.getShapeFactory().multiLineString().build());
    }

    @Test
    public void testGeomCollection() throws ParseException {
        ShapeFactory shapeFactory = this.ctx.getShapeFactory();
        Shape s1 = shapeFactory.multiShape(Shape.class).add((Shape)shapeFactory.pointXY(1.0, 2.0)).build();
        Shape s2 = shapeFactory.multiShape(Shape.class).add((Shape)shapeFactory.rect(1.0, 2.0, 3.0, 4.0)).add((Shape)shapeFactory.pointXY(-1.0, -2.0)).build();
        this.assertParses("GEOMETRYCOLLECTION (POINT (1 2) )", s1);
        this.assertParses("GEOMETRYCOLLECTION ( ENVELOPE(1,2,4,3), POINT(-1 -2)) ", s2);
        this.assertParses("GEOMETRYCOLLECTION EMPTY", shapeFactory.multiShape(Shape.class).build());
        this.assertParses("GEOMETRYCOLLECTION ( POINT EMPTY )", shapeFactory.multiShape(Shape.class).add((Shape)shapeFactory.pointXY(Double.NaN, Double.NaN)).build());
    }

    @Test
    public void testBuffer() throws ParseException {
        this.assertParses("BUFFER(POINT(1 2), 3)", this.ctx.makePoint(1.0, 2.0).getBuffered(3.0, this.ctx));
    }
}

