/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.spatial4j.io;

import com.carrotsearch.randomizedtesting.RandomizedTest;
import org.junit.Test;
import org.locationtech.spatial4j.context.SpatialContext;
import org.locationtech.spatial4j.io.BinaryCodec;
import org.locationtech.spatial4j.shape.Shape;

public abstract class BaseRoundTripTest<T extends SpatialContext>
extends RandomizedTest {
    protected T ctx = this.initContext();
    protected BinaryCodec binaryCodec = this.ctx.getBinaryCodec();

    protected BaseRoundTripTest() {
    }

    public abstract T initContext();

    public boolean shouldBeEqualAfterRoundTrip() {
        return true;
    }

    @Test
    public void testPoint() throws Exception {
        this.assertRoundTrip(this.wkt("POINT(-10 80.3)"));
    }

    protected Shape wkt(String wkt) {
        try {
            return this.ctx.getFormats().getWktReader().read((Object)wkt);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected Shape randomShape() {
        switch (BaseRoundTripTest.randomInt((int)2)) {
            case 0: {
                return this.wkt("POINT(-10 80.3)");
            }
            case 1: {
                return this.wkt("ENVELOPE(-10, 180, 42.3, 0)");
            }
            case 2: {
                return this.wkt("BUFFER(POINT(-10 30), 5.2)");
            }
        }
        throw new Error();
    }

    protected final void assertRoundTrip(Shape shape) throws Exception {
        this.assertRoundTrip(shape, this.shouldBeEqualAfterRoundTrip());
    }

    protected abstract void assertRoundTrip(Shape var1, boolean var2) throws Exception;
}

