/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.luke.util.reflection;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.jar.JarInputStream;
import java.util.zip.ZipEntry;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.luke.util.LoggerFactory;

final class SubtypeCollector<T>
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final Set<URL> urls = new HashSet<URL>();
    private final Class<T> superType;
    private final String packageName;
    private final ClassLoader[] classLoaders;
    private final Set<Class<? extends T>> types = new HashSet<Class<? extends T>>();

    SubtypeCollector(Class<T> superType, String packageName, ClassLoader ... classLoaders) {
        this.superType = superType;
        this.packageName = packageName;
        this.classLoaders = classLoaders;
    }

    void addUrl(URL url) {
        this.urls.add(url);
    }

    Set<Class<? extends T>> getTypes() {
        return Collections.unmodifiableSet(this.types);
    }

    @Override
    public void run() {
        block13: for (URL url : this.urls) {
            try {
                JarInputStream jis = new JarInputStream(url.openStream());
                Throwable throwable = null;
                block14: while (true) {
                    try {
                        ZipEntry entry;
                        while ((entry = jis.getNextEntry()) != null) {
                            String fqcn;
                            String name = entry.getName();
                            if (!name.endsWith(".class") || name.indexOf(36) >= 0 || name.contains("package-info") || name.startsWith("META-INF") || !(fqcn = SubtypeCollector.convertToFQCN(name)).startsWith(this.packageName)) continue;
                            for (ClassLoader cl : this.classLoaders) {
                                try {
                                    Class<?> clazz = Class.forName(fqcn, false, cl);
                                    if (!this.superType.isAssignableFrom(clazz) || Objects.equals(this.superType, clazz)) continue block14;
                                    this.types.add(clazz.asSubclass(this.superType));
                                    continue block14;
                                }
                                catch (Throwable throwable2) {
                                }
                            }
                        }
                        continue block13;
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                }
                finally {
                    if (jis == null) continue;
                    if (throwable != null) {
                        try {
                            jis.close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                        continue;
                    }
                    jis.close();
                }
            }
            catch (IOException e) {
                log.error("Cannot load jar {}", (Object)url, (Object)e);
            }
        }
    }

    private static String convertToFQCN(String name) {
        if (name == null || name.equals("")) {
            return name;
        }
        int index = name.lastIndexOf(".class");
        return name.replace('/', '.').substring(0, index);
    }
}

