/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.luke.util.reflection;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.luke.util.LoggerFactory;
import org.apache.lucene.luke.util.reflection.SubtypeCollector;
import org.apache.lucene.util.NamedThreadFactory;

public class ClassScanner {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final String packageName;
    private final ClassLoader[] classLoaders;

    public ClassScanner(String packageName, ClassLoader ... classLoaders) {
        this.packageName = packageName;
        this.classLoaders = classLoaders;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> Set<Class<? extends T>> scanSubTypes(Class<T> superType) {
        int numThreads = Runtime.getRuntime().availableProcessors();
        ArrayList<SubtypeCollector<T>> collectors = new ArrayList<SubtypeCollector<T>>();
        for (int i = 0; i < numThreads; ++i) {
            collectors.add(new SubtypeCollector<T>(superType, this.packageName, this.classLoaders));
        }
        try {
            List<URL> urls = this.getJarUrls();
            for (int i = 0; i < urls.size(); ++i) {
                ((SubtypeCollector)collectors.get(i % numThreads)).addUrl(urls.get(i));
            }
            ExecutorService executorService = Executors.newFixedThreadPool(numThreads, (ThreadFactory)new NamedThreadFactory("scanner-scan-subtypes"));
            for (SubtypeCollector subtypeCollector : collectors) {
                executorService.submit(subtypeCollector);
            }
            try {
                executorService.shutdown();
                executorService.awaitTermination(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                executorService.shutdownNow();
            }
            HashSet<Class<T>> types = new HashSet<Class<T>>();
            for (SubtypeCollector subtypeCollector : collectors) {
                types.addAll(subtypeCollector.getTypes());
            }
            return types;
        }
        catch (IOException e) {
            log.error("Cannot load jar file entries", (Throwable)e);
            return Collections.emptySet();
        }
    }

    private List<URL> getJarUrls() throws IOException {
        ArrayList<URL> urls = new ArrayList<URL>();
        String resourceName = ClassScanner.resourceName(this.packageName);
        for (ClassLoader loader : this.classLoaders) {
            Enumeration<URL> e = loader.getResources(resourceName);
            while (e.hasMoreElements()) {
                URL url = e.nextElement();
                int index = url.getPath().lastIndexOf(".jar");
                if (index <= 0) continue;
                String path = url.getPath().substring(0, index + 4);
                urls.add(new URL(path));
            }
        }
        return urls;
    }

    private static String resourceName(String packageName) {
        if (packageName == null || packageName.equals("")) {
            return packageName;
        }
        return packageName.replace('.', '/');
    }
}

