/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.luke.models.search;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class MLTConfig {
    private final List<String> fields;
    private final int maxDocFreq;
    private final int minDocFreq;
    private final int minTermFreq;

    private MLTConfig(Builder builder) {
        this.fields = Collections.unmodifiableList(builder.fields);
        this.maxDocFreq = builder.maxDocFreq;
        this.minDocFreq = builder.minDocFreq;
        this.minTermFreq = builder.minTermFreq;
    }

    public String[] getFieldNames() {
        return this.fields.toArray(new String[this.fields.size()]);
    }

    public int getMaxDocFreq() {
        return this.maxDocFreq;
    }

    public int getMinDocFreq() {
        return this.minDocFreq;
    }

    public int getMinTermFreq() {
        return this.minTermFreq;
    }

    public static class Builder {
        private final List<String> fields = new ArrayList<String>();
        private int maxDocFreq = Integer.MAX_VALUE;
        private int minDocFreq = 5;
        private int minTermFreq = 2;

        public Builder fields(Collection<String> val) {
            this.fields.addAll(val);
            return this;
        }

        public Builder maxDocFreq(int val) {
            this.maxDocFreq = val;
            return this;
        }

        public Builder minDocFreq(int val) {
            this.minDocFreq = val;
            return this;
        }

        public Builder minTermFreq(int val) {
            this.minTermFreq = val;
            return this;
        }

        public MLTConfig build() {
            return new MLTConfig(this);
        }
    }
}

