/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.luke.app.desktop.components;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellRenderer;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.Term;
import org.apache.lucene.luke.app.IndexHandler;
import org.apache.lucene.luke.app.IndexObserver;
import org.apache.lucene.luke.app.LukeState;
import org.apache.lucene.luke.app.desktop.MessageBroker;
import org.apache.lucene.luke.app.desktop.components.ComponentOperatorRegistry;
import org.apache.lucene.luke.app.desktop.components.DocumentsTabOperator;
import org.apache.lucene.luke.app.desktop.components.SearchTabOperator;
import org.apache.lucene.luke.app.desktop.components.TabSwitcherProxy;
import org.apache.lucene.luke.app.desktop.components.TabbedPaneProvider;
import org.apache.lucene.luke.app.desktop.components.TableColumnInfo;
import org.apache.lucene.luke.app.desktop.components.TableModelBase;
import org.apache.lucene.luke.app.desktop.components.dialog.HelpDialogFactory;
import org.apache.lucene.luke.app.desktop.components.dialog.documents.AddDocumentDialogFactory;
import org.apache.lucene.luke.app.desktop.components.dialog.documents.DocValuesDialogFactory;
import org.apache.lucene.luke.app.desktop.components.dialog.documents.StoredValueDialogFactory;
import org.apache.lucene.luke.app.desktop.components.dialog.documents.TermVectorDialogFactory;
import org.apache.lucene.luke.app.desktop.util.DialogOpener;
import org.apache.lucene.luke.app.desktop.util.FontUtils;
import org.apache.lucene.luke.app.desktop.util.HelpHeaderRenderer;
import org.apache.lucene.luke.app.desktop.util.MessageUtils;
import org.apache.lucene.luke.app.desktop.util.StyleConstants;
import org.apache.lucene.luke.app.desktop.util.TableUtils;
import org.apache.lucene.luke.models.documents.DocValues;
import org.apache.lucene.luke.models.documents.DocumentField;
import org.apache.lucene.luke.models.documents.Documents;
import org.apache.lucene.luke.models.documents.DocumentsFactory;
import org.apache.lucene.luke.models.documents.TermPosting;
import org.apache.lucene.luke.models.documents.TermVectorEntry;
import org.apache.lucene.luke.util.BytesRefUtils;

public final class DocumentsPanelProvider
implements DocumentsTabOperator {
    private final DocumentsFactory documentsFactory = new DocumentsFactory();
    private final MessageBroker messageBroker;
    private final ComponentOperatorRegistry operatorRegistry;
    private final TabSwitcherProxy tabSwitcher;
    private final AddDocumentDialogFactory addDocDialogFactory;
    private final TermVectorDialogFactory tvDialogFactory;
    private final DocValuesDialogFactory dvDialogFactory;
    private final StoredValueDialogFactory valueDialogFactory;
    private final TableCellRenderer tableHeaderRenderer;
    private final JComboBox<String> fieldsCombo = new JComboBox();
    private final JButton firstTermBtn = new JButton();
    private final JTextField termTF = new JTextField();
    private final JButton nextTermBtn = new JButton();
    private final JTextField selectedTermTF = new JTextField();
    private final JButton firstTermDocBtn = new JButton();
    private final JTextField termDocIdxTF = new JTextField();
    private final JButton nextTermDocBtn = new JButton();
    private final JLabel termDocsNumLbl = new JLabel();
    private final JTable posTable = new JTable();
    private final JSpinner docNumSpnr = new JSpinner();
    private final JLabel maxDocsLbl = new JLabel();
    private final JButton mltBtn = new JButton();
    private final JButton addDocBtn = new JButton();
    private final JButton copyDocValuesBtn = new JButton();
    private final JTable documentTable = new JTable();
    private final JPopupMenu documentContextMenu = new JPopupMenu();
    private final ListenerFunctions listeners = new ListenerFunctions();
    private Documents documentsModel;

    public DocumentsPanelProvider() throws IOException {
        this.messageBroker = MessageBroker.getInstance();
        this.operatorRegistry = ComponentOperatorRegistry.getInstance();
        this.tabSwitcher = TabSwitcherProxy.getInstance();
        this.addDocDialogFactory = AddDocumentDialogFactory.getInstance();
        this.tvDialogFactory = TermVectorDialogFactory.getInstance();
        this.dvDialogFactory = DocValuesDialogFactory.getInstance();
        this.valueDialogFactory = StoredValueDialogFactory.getInstance();
        HelpDialogFactory helpDialogFactory = HelpDialogFactory.getInstance();
        this.tableHeaderRenderer = new HelpHeaderRenderer("About Flags", "Format: IdfpoNPSB#txxVDtxxxxTx/x", this.createFlagsHelpDialog(), helpDialogFactory);
        IndexHandler.getInstance().addObserver(new Observer());
        this.operatorRegistry.register(DocumentsTabOperator.class, this);
    }

    private JComponent createFlagsHelpDialog() {
        String[] values = new String[]{"I - index options(docs, frequencies, positions, offsets)", "N - norms", "P - payloads", "S - stored", "B - binary stored values", "#txx - numeric stored values(type, precision)", "V - term vectors", "Dtxxxxx - doc values(type)", "Tx/x - point values(num bytes/dimension)"};
        JList<String> list = new JList<String>(values);
        return new JScrollPane(list);
    }

    public JPanel get() {
        JPanel panel = new JPanel(new GridLayout(1, 1));
        panel.setOpaque(false);
        panel.setBorder(BorderFactory.createLineBorder(Color.gray));
        JSplitPane splitPane = new JSplitPane(0, this.initUpperPanel(), this.initLowerPanel());
        splitPane.setOpaque(false);
        splitPane.setDividerLocation(0.4);
        panel.add(splitPane);
        this.setUpDocumentContextMenu();
        return panel;
    }

    private JPanel initUpperPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setOpaque(false);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.5;
        c.anchor = 23;
        c.fill = 2;
        panel.add((Component)this.initBrowseTermsPanel(), c);
        c.gridx = 1;
        c.gridy = 0;
        c.weightx = 0.5;
        c.anchor = 23;
        c.fill = 2;
        panel.add((Component)this.initBrowseDocsByTermPanel(), c);
        return panel;
    }

    private JPanel initBrowseTermsPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setOpaque(false);
        panel.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        JPanel top = new JPanel(new FlowLayout(3));
        top.setOpaque(false);
        JLabel label = new JLabel(MessageUtils.getLocalizedMessage("documents.label.browse_terms"));
        top.add(label);
        panel.add((Component)top, "First");
        JPanel center = new JPanel(new GridBagLayout());
        center.setOpaque(false);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        this.fieldsCombo.addActionListener(this.listeners::showFirstTerm);
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(5, 5, 5, 5);
        c.weightx = 0.0;
        c.gridwidth = 2;
        center.add(this.fieldsCombo, c);
        this.firstTermBtn.setText(FontUtils.elegantIconHtml("&#x38;", MessageUtils.getLocalizedMessage("documents.button.first_term")));
        this.firstTermBtn.setMaximumSize(new Dimension(80, 30));
        this.firstTermBtn.addActionListener(this.listeners::showFirstTerm);
        c.gridx = 0;
        c.gridy = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.weightx = 0.2;
        c.gridwidth = 1;
        center.add((Component)this.firstTermBtn, c);
        this.termTF.setColumns(20);
        this.termTF.setMinimumSize(new Dimension(50, 25));
        this.termTF.setFont(StyleConstants.FONT_MONOSPACE_LARGE);
        this.termTF.addActionListener(this.listeners::seekNextTerm);
        c.gridx = 1;
        c.gridy = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.weightx = 0.5;
        c.gridwidth = 1;
        center.add((Component)this.termTF, c);
        this.nextTermBtn.setText(MessageUtils.getLocalizedMessage("documents.button.next"));
        this.nextTermBtn.addActionListener(this.listeners::showNextTerm);
        c.gridx = 2;
        c.gridy = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.weightx = 0.1;
        c.gridwidth = 1;
        center.add((Component)this.nextTermBtn, c);
        panel.add((Component)center, "Center");
        JPanel footer = new JPanel(new FlowLayout(3, 20, 5));
        footer.setOpaque(false);
        JLabel hintLbl = new JLabel(MessageUtils.getLocalizedMessage("documents.label.browse_terms_hint"));
        footer.add(hintLbl);
        panel.add((Component)footer, "Last");
        return panel;
    }

    private JPanel initBrowseDocsByTermPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setOpaque(false);
        panel.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        JPanel center = new JPanel(new GridBagLayout());
        center.setOpaque(false);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        JLabel label = new JLabel(MessageUtils.getLocalizedMessage("documents.label.browse_doc_by_term"));
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        c.gridwidth = 2;
        c.insets = new Insets(5, 5, 5, 5);
        center.add((Component)label, c);
        this.selectedTermTF.setColumns(20);
        this.selectedTermTF.setFont(StyleConstants.FONT_MONOSPACE_LARGE);
        this.selectedTermTF.setEditable(false);
        this.selectedTermTF.setBackground(Color.white);
        c.gridx = 0;
        c.gridy = 1;
        c.weightx = 0.0;
        c.gridwidth = 2;
        c.insets = new Insets(5, 5, 5, 5);
        center.add((Component)this.selectedTermTF, c);
        this.firstTermDocBtn.setText(FontUtils.elegantIconHtml("&#x38;", MessageUtils.getLocalizedMessage("documents.button.first_termdoc")));
        this.firstTermDocBtn.addActionListener(this.listeners::showFirstTermDoc);
        c.gridx = 0;
        c.gridy = 2;
        c.weightx = 0.2;
        c.gridwidth = 1;
        c.insets = new Insets(5, 3, 5, 5);
        center.add((Component)this.firstTermDocBtn, c);
        this.termDocIdxTF.setEditable(false);
        this.termDocIdxTF.setBackground(Color.white);
        c.gridx = 1;
        c.gridy = 2;
        c.weightx = 0.5;
        c.gridwidth = 1;
        c.insets = new Insets(5, 5, 5, 5);
        center.add((Component)this.termDocIdxTF, c);
        this.nextTermDocBtn.setText(MessageUtils.getLocalizedMessage("documents.button.next"));
        this.nextTermDocBtn.addActionListener(this.listeners::showNextTermDoc);
        c.gridx = 2;
        c.gridy = 2;
        c.weightx = 0.2;
        c.gridwidth = 1;
        c.insets = new Insets(5, 5, 5, 5);
        center.add((Component)this.nextTermDocBtn, c);
        this.termDocsNumLbl.setText("in ? docs");
        c.gridx = 3;
        c.gridy = 2;
        c.weightx = 0.3;
        c.gridwidth = 1;
        c.insets = new Insets(5, 5, 5, 5);
        center.add((Component)this.termDocsNumLbl, c);
        TableUtils.setupTable(this.posTable, 0, new PosTableModel(), null, PosTableModel.Column.POSITION.getColumnWidth(), PosTableModel.Column.OFFSETS.getColumnWidth(), PosTableModel.Column.PAYLOAD.getColumnWidth());
        JScrollPane scrollPane = new JScrollPane(this.posTable);
        scrollPane.setMinimumSize(new Dimension(100, 100));
        c.gridx = 0;
        c.gridy = 3;
        c.gridwidth = 4;
        c.insets = new Insets(5, 5, 5, 5);
        center.add((Component)scrollPane, c);
        panel.add((Component)center, "Center");
        return panel;
    }

    private JPanel initLowerPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setOpaque(false);
        panel.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        JPanel browseDocsPanel = new JPanel();
        browseDocsPanel.setOpaque(false);
        browseDocsPanel.setLayout(new BoxLayout(browseDocsPanel, 3));
        browseDocsPanel.add(this.initBrowseDocsBar());
        JPanel browseDocsNote1 = new JPanel(new FlowLayout(3));
        browseDocsNote1.setOpaque(false);
        browseDocsNote1.add(new JLabel(MessageUtils.getLocalizedMessage("documents.label.doc_table_note1")));
        browseDocsPanel.add(browseDocsNote1);
        JPanel browseDocsNote2 = new JPanel(new FlowLayout(3));
        browseDocsNote2.setOpaque(false);
        browseDocsNote2.add(new JLabel(MessageUtils.getLocalizedMessage("documents.label.doc_table_note2")));
        browseDocsPanel.add(browseDocsNote2);
        panel.add((Component)browseDocsPanel, "First");
        TableUtils.setupTable(this.documentTable, 2, new DocumentsTableModel(), new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                DocumentsPanelProvider.this.listeners.showDocumentContextMenu(e);
            }
        }, DocumentsTableModel.Column.FIELD.getColumnWidth(), DocumentsTableModel.Column.FLAGS.getColumnWidth(), DocumentsTableModel.Column.NORM.getColumnWidth(), DocumentsTableModel.Column.VALUE.getColumnWidth());
        JPanel flagsHeader = new JPanel(new FlowLayout(1));
        flagsHeader.setOpaque(false);
        flagsHeader.add(new JLabel("Flags"));
        flagsHeader.add(new JLabel("Help"));
        this.documentTable.getColumnModel().getColumn(DocumentsTableModel.Column.FLAGS.getIndex()).setHeaderValue(flagsHeader);
        JScrollPane scrollPane = new JScrollPane(this.documentTable);
        scrollPane.getHorizontalScrollBar().setAutoscrolls(false);
        panel.add((Component)scrollPane, "Center");
        return panel;
    }

    private JPanel initBrowseDocsBar() {
        JPanel panel = new JPanel(new GridLayout(1, 2));
        panel.setOpaque(false);
        panel.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 5));
        JPanel left = new JPanel(new FlowLayout(3, 10, 2));
        left.setOpaque(false);
        JLabel label = new JLabel(FontUtils.elegantIconHtml("&#x68;", MessageUtils.getLocalizedMessage("documents.label.browse_doc_by_idx")));
        label.setHorizontalTextPosition(2);
        left.add(label);
        this.docNumSpnr.setPreferredSize(new Dimension(100, 25));
        this.docNumSpnr.addChangeListener(this.listeners::showCurrentDoc);
        left.add(this.docNumSpnr);
        this.maxDocsLbl.setText("in ? docs");
        left.add(this.maxDocsLbl);
        panel.add(left);
        JPanel right = new JPanel(new FlowLayout(4));
        right.setOpaque(false);
        this.copyDocValuesBtn.setText(FontUtils.elegantIconHtml("&#xe0e6;", MessageUtils.getLocalizedMessage("documents.buttont.copy_values")));
        this.copyDocValuesBtn.setMargin(new Insets(5, 0, 5, 0));
        this.copyDocValuesBtn.addActionListener(this.listeners::copySelectedOrAllStoredValues);
        right.add(this.copyDocValuesBtn);
        this.mltBtn.setText(FontUtils.elegantIconHtml("&#xe030;", MessageUtils.getLocalizedMessage("documents.button.mlt")));
        this.mltBtn.setMargin(new Insets(5, 0, 5, 0));
        this.mltBtn.addActionListener(this.listeners::mltSearch);
        right.add(this.mltBtn);
        this.addDocBtn.setText(FontUtils.elegantIconHtml("&#x59;", MessageUtils.getLocalizedMessage("documents.button.add")));
        this.addDocBtn.setMargin(new Insets(5, 0, 5, 0));
        this.addDocBtn.addActionListener(this.listeners::showAddDocumentDialog);
        right.add(this.addDocBtn);
        panel.add(right);
        return panel;
    }

    private void setUpDocumentContextMenu() {
        JMenuItem item1 = new JMenuItem(MessageUtils.getLocalizedMessage("documents.doctable.menu.item1"));
        item1.addActionListener(this.listeners::showTermVectorDialog);
        this.documentContextMenu.add(item1);
        JMenuItem item2 = new JMenuItem(MessageUtils.getLocalizedMessage("documents.doctable.menu.item2"));
        item2.addActionListener(this.listeners::showDocValuesDialog);
        this.documentContextMenu.add(item2);
        JMenuItem item3 = new JMenuItem(MessageUtils.getLocalizedMessage("documents.doctable.menu.item3"));
        item3.addActionListener(this.listeners::showStoredValueDialog);
        this.documentContextMenu.add(item3);
        JMenuItem item4 = new JMenuItem(MessageUtils.getLocalizedMessage("documents.doctable.menu.item4"));
        item4.addActionListener(this.listeners::copyStoredValue);
        this.documentContextMenu.add(item4);
    }

    private void showFirstTerm() {
        String fieldName = (String)this.fieldsCombo.getSelectedItem();
        if (fieldName == null || fieldName.length() == 0) {
            this.messageBroker.showStatusMessage(MessageUtils.getLocalizedMessage("documents.field.message.not_selected"));
            return;
        }
        this.termDocIdxTF.setText("");
        this.clearPosTable();
        Optional<Term> firstTerm = this.documentsModel.firstTerm(fieldName);
        String firstTermText = firstTerm.map(Term::text).orElse("");
        this.termTF.setText(firstTermText);
        this.selectedTermTF.setText(firstTermText);
        if (firstTerm.isPresent()) {
            String num = this.documentsModel.getDocFreq().map(String::valueOf).orElse("?");
            this.termDocsNumLbl.setText("in " + num + " docs");
            this.nextTermBtn.setEnabled(true);
            this.termTF.setEditable(true);
            this.firstTermDocBtn.setEnabled(true);
        } else {
            this.nextTermBtn.setEnabled(false);
            this.termTF.setEditable(false);
            this.firstTermDocBtn.setEnabled(false);
        }
        this.nextTermDocBtn.setEnabled(false);
        this.messageBroker.clearStatusMessage();
    }

    private void showNextTerm() {
        this.termDocIdxTF.setText("");
        this.clearPosTable();
        Optional<Term> nextTerm = this.documentsModel.nextTerm();
        String nextTermText = nextTerm.map(Term::text).orElse("");
        this.termTF.setText(nextTermText);
        this.selectedTermTF.setText(nextTermText);
        if (nextTerm.isPresent()) {
            String num = this.documentsModel.getDocFreq().map(String::valueOf).orElse("?");
            this.termDocsNumLbl.setText("in " + num + " docs");
            this.termTF.setEditable(true);
            this.firstTermDocBtn.setEnabled(true);
        } else {
            this.nextTermBtn.setEnabled(false);
            this.termTF.setEditable(false);
            this.firstTermDocBtn.setEnabled(false);
        }
        this.nextTermDocBtn.setEnabled(false);
        this.messageBroker.clearStatusMessage();
    }

    @Override
    public void seekNextTerm() {
        this.termDocIdxTF.setText("");
        this.posTable.setModel(new PosTableModel());
        String termText = this.termTF.getText();
        Optional<Term> nextTerm = this.documentsModel.seekTerm(termText);
        String nextTermText = nextTerm.map(Term::text).orElse("");
        this.termTF.setText(nextTermText);
        this.selectedTermTF.setText(nextTermText);
        if (nextTerm.isPresent()) {
            String num = this.documentsModel.getDocFreq().map(String::valueOf).orElse("?");
            this.termDocsNumLbl.setText("in " + num + " docs");
            this.termTF.setEditable(true);
            this.firstTermDocBtn.setEnabled(true);
        } else {
            this.nextTermBtn.setEnabled(false);
            this.termTF.setEditable(false);
            this.firstTermDocBtn.setEnabled(false);
        }
        this.nextTermDocBtn.setEnabled(false);
        this.messageBroker.clearStatusMessage();
    }

    private void clearPosTable() {
        TableUtils.setupTable(this.posTable, 0, new PosTableModel(), null, PosTableModel.Column.POSITION.getColumnWidth(), PosTableModel.Column.OFFSETS.getColumnWidth(), PosTableModel.Column.PAYLOAD.getColumnWidth());
    }

    @Override
    public void showFirstTermDoc() {
        int docid = this.documentsModel.firstTermDoc().orElse(-1);
        if (docid < 0) {
            this.nextTermDocBtn.setEnabled(false);
            this.messageBroker.showStatusMessage(MessageUtils.getLocalizedMessage("documents.termdocs.message.not_available"));
            return;
        }
        this.termDocIdxTF.setText(String.valueOf(1));
        this.displayDoc(docid);
        List<TermPosting> postings = this.documentsModel.getTermPositions();
        this.posTable.setModel(new PosTableModel(postings));
        this.posTable.getColumnModel().getColumn(PosTableModel.Column.POSITION.getIndex()).setPreferredWidth(PosTableModel.Column.POSITION.getColumnWidth());
        this.posTable.getColumnModel().getColumn(PosTableModel.Column.OFFSETS.getIndex()).setPreferredWidth(PosTableModel.Column.OFFSETS.getColumnWidth());
        this.posTable.getColumnModel().getColumn(PosTableModel.Column.PAYLOAD.getIndex()).setPreferredWidth(PosTableModel.Column.PAYLOAD.getColumnWidth());
        this.nextTermDocBtn.setEnabled(true);
        this.messageBroker.clearStatusMessage();
    }

    private void showNextTermDoc() {
        int docid = this.documentsModel.nextTermDoc().orElse(-1);
        if (docid < 0) {
            this.nextTermDocBtn.setEnabled(false);
            this.messageBroker.showStatusMessage(MessageUtils.getLocalizedMessage("documents.termdocs.message.not_available"));
            return;
        }
        int curIdx = Integer.parseInt(this.termDocIdxTF.getText());
        this.termDocIdxTF.setText(String.valueOf(curIdx + 1));
        this.displayDoc(docid);
        List<TermPosting> postings = this.documentsModel.getTermPositions();
        this.posTable.setModel(new PosTableModel(postings));
        this.nextTermDocBtn.setDefaultCapable(true);
        this.messageBroker.clearStatusMessage();
    }

    private void showCurrentDoc() {
        int docid = (Integer)this.docNumSpnr.getValue();
        this.displayDoc(docid);
    }

    private void mltSearch() {
        int docNum = (Integer)this.docNumSpnr.getValue();
        this.operatorRegistry.get(SearchTabOperator.class).ifPresent(operator -> {
            operator.mltSearch(docNum);
            this.tabSwitcher.switchTab(TabbedPaneProvider.Tab.SEARCH);
        });
    }

    private void showAddDocumentDialog() {
        new DialogOpener<AddDocumentDialogFactory>(this.addDocDialogFactory).open("Add document", 600, 500, factory -> {}, new String[0]);
    }

    private void showTermVectorDialog() {
        String field;
        int docid = (Integer)this.docNumSpnr.getValue();
        List<TermVectorEntry> tvEntries = this.documentsModel.getTermVectors(docid, field = (String)this.documentTable.getModel().getValueAt(this.documentTable.getSelectedRow(), DocumentsTableModel.Column.FIELD.getIndex()));
        if (tvEntries.isEmpty()) {
            this.messageBroker.showStatusMessage(MessageUtils.getLocalizedMessage("documents.termvector.message.not_available", field, docid));
            return;
        }
        new DialogOpener<TermVectorDialogFactory>(this.tvDialogFactory).open("Term Vector", 600, 400, factory -> {
            factory.setField(field);
            factory.setTvEntries(tvEntries);
        }, new String[0]);
        this.messageBroker.clearStatusMessage();
    }

    private void showDocValuesDialog() {
        String field;
        int docid = (Integer)this.docNumSpnr.getValue();
        Optional<DocValues> docValues = this.documentsModel.getDocValues(docid, field = (String)this.documentTable.getModel().getValueAt(this.documentTable.getSelectedRow(), DocumentsTableModel.Column.FIELD.getIndex()));
        if (docValues.isPresent()) {
            new DialogOpener<DocValuesDialogFactory>(this.dvDialogFactory).open("Doc Values", 400, 300, factory -> factory.setValue(field, (DocValues)docValues.get()), new String[0]);
            this.messageBroker.clearStatusMessage();
        } else {
            this.messageBroker.showStatusMessage(MessageUtils.getLocalizedMessage("documents.docvalues.message.not_available", field, docid));
        }
    }

    private void showStoredValueDialog() {
        int docid = (Integer)this.docNumSpnr.getValue();
        String field = (String)this.documentTable.getModel().getValueAt(this.documentTable.getSelectedRow(), DocumentsTableModel.Column.FIELD.getIndex());
        String value = (String)this.documentTable.getModel().getValueAt(this.documentTable.getSelectedRow(), DocumentsTableModel.Column.VALUE.getIndex());
        if (Objects.isNull(value)) {
            this.messageBroker.showStatusMessage(MessageUtils.getLocalizedMessage("documents.stored.message.not_availabe", field, docid));
            return;
        }
        new DialogOpener<StoredValueDialogFactory>(this.valueDialogFactory).open("Stored Value", 400, 300, factory -> {
            factory.setField(field);
            factory.setValue(value);
        }, new String[0]);
        this.messageBroker.clearStatusMessage();
    }

    private void copyStoredValue() {
        int docid = (Integer)this.docNumSpnr.getValue();
        String field = (String)this.documentTable.getModel().getValueAt(this.documentTable.getSelectedRow(), DocumentsTableModel.Column.FIELD.getIndex());
        String value = (String)this.documentTable.getModel().getValueAt(this.documentTable.getSelectedRow(), DocumentsTableModel.Column.VALUE.getIndex());
        if (Objects.isNull(value)) {
            this.messageBroker.showStatusMessage(MessageUtils.getLocalizedMessage("documents.stored.message.not_availabe", field, docid));
            return;
        }
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection selection = new StringSelection(value);
        clipboard.setContents(selection, null);
        this.messageBroker.clearStatusMessage();
    }

    private void copySelectedOrAllStoredValues() {
        StringSelection selection = this.documentTable.getSelectedRowCount() == 0 ? this.copyAllValues() : this.copySelectedValues();
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(selection, null);
        this.messageBroker.clearStatusMessage();
    }

    private StringSelection copyAllValues() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.documentTable.getRowCount(); ++i) {
            String value = (String)this.documentTable.getModel().getValueAt(i, DocumentsTableModel.Column.VALUE.getIndex());
            if (!Objects.nonNull(value)) continue;
            sb.append(i == 0 ? value : System.lineSeparator() + value);
        }
        return new StringSelection(sb.toString());
    }

    private StringSelection copySelectedValues() {
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (int rowIndex : this.documentTable.getSelectedRows()) {
            String value = (String)this.documentTable.getModel().getValueAt(rowIndex, DocumentsTableModel.Column.VALUE.getIndex());
            if (!Objects.nonNull(value)) continue;
            sb.append(isFirst ? value : System.lineSeparator() + value);
            isFirst = false;
        }
        return new StringSelection(sb.toString());
    }

    @Override
    public void browseTerm(String field, String term) {
        this.fieldsCombo.setSelectedItem(field);
        this.termTF.setText(term);
        this.seekNextTerm();
        this.showFirstTermDoc();
    }

    @Override
    public void displayLatestDoc() {
        int docid = this.documentsModel.getMaxDoc() - 1;
        this.showDoc(docid);
    }

    @Override
    public void displayDoc(int docid) {
        this.showDoc(docid);
    }

    private void showDoc(int docid) {
        this.docNumSpnr.setValue(docid);
        List<DocumentField> doc = this.documentsModel.getDocumentFields(docid);
        this.documentTable.setModel(new DocumentsTableModel(doc));
        this.documentTable.setFont(StyleConstants.FONT_MONOSPACE_LARGE);
        this.documentTable.getColumnModel().getColumn(DocumentsTableModel.Column.FIELD.getIndex()).setPreferredWidth(DocumentsTableModel.Column.FIELD.getColumnWidth());
        this.documentTable.getColumnModel().getColumn(DocumentsTableModel.Column.FLAGS.getIndex()).setMinWidth(DocumentsTableModel.Column.FLAGS.getColumnWidth());
        this.documentTable.getColumnModel().getColumn(DocumentsTableModel.Column.FLAGS.getIndex()).setMaxWidth(DocumentsTableModel.Column.FIELD.getColumnWidth());
        this.documentTable.getColumnModel().getColumn(DocumentsTableModel.Column.NORM.getIndex()).setMinWidth(DocumentsTableModel.Column.NORM.getColumnWidth());
        this.documentTable.getColumnModel().getColumn(DocumentsTableModel.Column.NORM.getIndex()).setMaxWidth(DocumentsTableModel.Column.NORM.getColumnWidth());
        this.documentTable.getColumnModel().getColumn(DocumentsTableModel.Column.VALUE.getIndex()).setPreferredWidth(DocumentsTableModel.Column.VALUE.getColumnWidth());
        this.documentTable.getColumnModel().getColumn(DocumentsTableModel.Column.FLAGS.getIndex()).setHeaderRenderer(this.tableHeaderRenderer);
        this.messageBroker.clearStatusMessage();
    }

    static final class DocumentsTableModel
    extends TableModelBase<Column> {
        DocumentsTableModel() {
        }

        DocumentsTableModel(List<DocumentField> doc) {
            super(doc.size());
            for (int i = 0; i < doc.size(); ++i) {
                DocumentField docField = doc.get(i);
                String field = docField.getName();
                String flags = DocumentsTableModel.flags(docField);
                long norm = docField.getNorm();
                String value = null;
                if (docField.getStringValue() != null) {
                    value = docField.getStringValue();
                } else if (docField.getNumericValue() != null) {
                    value = String.valueOf(docField.getNumericValue());
                } else if (docField.getBinaryValue() != null) {
                    value = String.valueOf(docField.getBinaryValue());
                }
                this.data[i] = new Object[]{field, flags, norm, value};
            }
        }

        private static String flags(DocumentField f) {
            StringBuilder sb = new StringBuilder();
            if (f.getIdxOptions() == null || f.getIdxOptions() == IndexOptions.NONE) {
                sb.append("-----");
            } else {
                sb.append("I");
                switch (f.getIdxOptions()) {
                    case DOCS: {
                        sb.append("d---");
                        break;
                    }
                    case DOCS_AND_FREQS: {
                        sb.append("df--");
                        break;
                    }
                    case DOCS_AND_FREQS_AND_POSITIONS: {
                        sb.append("dfp-");
                        break;
                    }
                    case DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS: {
                        sb.append("dfpo");
                        break;
                    }
                    default: {
                        sb.append("----");
                    }
                }
            }
            if (f.hasNorms()) {
                sb.append("N");
            } else {
                sb.append("-");
            }
            if (f.hasPayloads()) {
                sb.append("P");
            } else {
                sb.append("-");
            }
            if (f.isStored()) {
                sb.append("S");
            } else {
                sb.append("-");
            }
            if (f.getBinaryValue() != null) {
                sb.append("B");
            } else {
                sb.append("-");
            }
            if (f.getNumericValue() == null) {
                sb.append("----");
            } else {
                sb.append("#");
                Number numeric = f.getNumericValue();
                if (numeric instanceof Integer) {
                    sb.append("i32");
                } else if (numeric instanceof Long) {
                    sb.append("i64");
                } else if (numeric instanceof Float) {
                    sb.append("f32");
                } else if (numeric instanceof Double) {
                    sb.append("f64");
                } else if (numeric instanceof Short) {
                    sb.append("i16");
                } else if (numeric instanceof Byte) {
                    sb.append("i08");
                } else if (numeric instanceof BigDecimal) {
                    sb.append("b^d");
                } else if (numeric instanceof BigInteger) {
                    sb.append("b^i");
                } else {
                    sb.append("???");
                }
            }
            if (f.hasTermVectors()) {
                sb.append("V");
            } else {
                sb.append("-");
            }
            if (f.getDvType() == null || f.getDvType() == DocValuesType.NONE) {
                sb.append("-------");
            } else {
                sb.append("D");
                switch (f.getDvType()) {
                    case NUMERIC: {
                        sb.append("number");
                        break;
                    }
                    case BINARY: {
                        sb.append("binary");
                        break;
                    }
                    case SORTED: {
                        sb.append("sorted");
                        break;
                    }
                    case SORTED_NUMERIC: {
                        sb.append("srtnum");
                        break;
                    }
                    case SORTED_SET: {
                        sb.append("srtset");
                        break;
                    }
                    default: {
                        sb.append("??????");
                    }
                }
            }
            if (f.getPointDimensionCount() == 0) {
                sb.append("----");
            } else {
                sb.append("T");
                sb.append(f.getPointNumBytes());
                sb.append("/");
                sb.append(f.getPointDimensionCount());
            }
            return sb.toString();
        }

        protected Column[] columnInfos() {
            return Column.values();
        }

        static enum Column implements TableColumnInfo
        {
            FIELD("Field", 0, String.class, 150),
            FLAGS("Flags", 1, String.class, 200),
            NORM("Norm", 2, Long.class, 80),
            VALUE("Value", 3, String.class, 500);

            private final String colName;
            private final int index;
            private final Class<?> type;
            private final int width;

            private Column(String colName, int index, Class<?> type, int width) {
                this.colName = colName;
                this.index = index;
                this.type = type;
                this.width = width;
            }

            @Override
            public String getColName() {
                return this.colName;
            }

            @Override
            public int getIndex() {
                return this.index;
            }

            @Override
            public Class<?> getType() {
                return this.type;
            }

            @Override
            public int getColumnWidth() {
                return this.width;
            }
        }
    }

    static final class PosTableModel
    extends TableModelBase<Column> {
        PosTableModel() {
        }

        PosTableModel(List<TermPosting> postings) {
            super(postings.size());
            for (int i = 0; i < postings.size(); ++i) {
                TermPosting p = postings.get(i);
                int position = postings.get(i).getPosition();
                String offset = null;
                if (p.getStartOffset() >= 0 && p.getEndOffset() >= 0) {
                    offset = p.getStartOffset() + "-" + p.getEndOffset();
                }
                String payload = null;
                if (p.getPayload() != null) {
                    payload = BytesRefUtils.decode(p.getPayload());
                }
                this.data[i] = new Object[]{position, offset, payload};
            }
        }

        protected Column[] columnInfos() {
            return Column.values();
        }

        static enum Column implements TableColumnInfo
        {
            POSITION("Position", 0, Integer.class, 80),
            OFFSETS("Offsets", 1, String.class, 120),
            PAYLOAD("Payload", 2, String.class, 300);

            private final String colName;
            private final int index;
            private final Class<?> type;
            private final int width;

            private Column(String colName, int index, Class<?> type, int width) {
                this.colName = colName;
                this.index = index;
                this.type = type;
                this.width = width;
            }

            @Override
            public String getColName() {
                return this.colName;
            }

            @Override
            public int getIndex() {
                return this.index;
            }

            @Override
            public Class<?> getType() {
                return this.type;
            }

            @Override
            public int getColumnWidth() {
                return this.width;
            }
        }
    }

    private class Observer
    implements IndexObserver {
        private Observer() {
        }

        @Override
        public void openIndex(LukeState state) {
            DocumentsPanelProvider.this.documentsModel = DocumentsPanelProvider.this.documentsFactory.newInstance(state.getIndexReader());
            DocumentsPanelProvider.this.addDocBtn.setEnabled(!state.readOnly() && state.hasDirectoryReader());
            int maxDoc = DocumentsPanelProvider.this.documentsModel.getMaxDoc();
            DocumentsPanelProvider.this.maxDocsLbl.setText("in " + maxDoc + " docs");
            if (maxDoc > 0) {
                int max = Math.max(maxDoc - 1, 0);
                SpinnerNumberModel spinnerModel = new SpinnerNumberModel(0, 0, max, 1);
                DocumentsPanelProvider.this.docNumSpnr.setModel(spinnerModel);
                DocumentsPanelProvider.this.docNumSpnr.setEnabled(true);
                DocumentsPanelProvider.this.displayDoc(0);
            } else {
                DocumentsPanelProvider.this.docNumSpnr.setEnabled(false);
            }
            DocumentsPanelProvider.this.documentsModel.getFieldNames().stream().sorted().forEach(DocumentsPanelProvider.this.fieldsCombo::addItem);
        }

        @Override
        public void closeIndex() {
            DocumentsPanelProvider.this.maxDocsLbl.setText("in ? docs");
            DocumentsPanelProvider.this.docNumSpnr.setEnabled(false);
            DocumentsPanelProvider.this.fieldsCombo.removeAllItems();
            DocumentsPanelProvider.this.termTF.setText("");
            DocumentsPanelProvider.this.selectedTermTF.setText("");
            DocumentsPanelProvider.this.termDocsNumLbl.setText("");
            DocumentsPanelProvider.this.termDocIdxTF.setText("");
            DocumentsPanelProvider.this.posTable.setModel(new PosTableModel());
            DocumentsPanelProvider.this.documentTable.setModel(new DocumentsTableModel());
        }
    }

    private class ListenerFunctions {
        private ListenerFunctions() {
        }

        void showFirstTerm(ActionEvent e) {
            DocumentsPanelProvider.this.showFirstTerm();
        }

        void seekNextTerm(ActionEvent e) {
            DocumentsPanelProvider.this.seekNextTerm();
        }

        void showNextTerm(ActionEvent e) {
            DocumentsPanelProvider.this.showNextTerm();
        }

        void showFirstTermDoc(ActionEvent e) {
            DocumentsPanelProvider.this.showFirstTermDoc();
        }

        void showNextTermDoc(ActionEvent e) {
            DocumentsPanelProvider.this.showNextTermDoc();
        }

        void showCurrentDoc(ChangeEvent e) {
            DocumentsPanelProvider.this.showCurrentDoc();
        }

        void mltSearch(ActionEvent e) {
            DocumentsPanelProvider.this.mltSearch();
        }

        void showAddDocumentDialog(ActionEvent e) {
            DocumentsPanelProvider.this.showAddDocumentDialog();
        }

        void showDocumentContextMenu(MouseEvent e) {
            if (e.getClickCount() == 2 && !e.isConsumed()) {
                int row = DocumentsPanelProvider.this.documentTable.rowAtPoint(e.getPoint());
                if (row != DocumentsPanelProvider.this.documentTable.getSelectedRow()) {
                    DocumentsPanelProvider.this.documentTable.changeSelection(row, DocumentsPanelProvider.this.documentTable.getSelectedColumn(), false, false);
                }
                DocumentsPanelProvider.this.documentContextMenu.show(e.getComponent(), e.getX(), e.getY());
            }
        }

        void showTermVectorDialog(ActionEvent e) {
            DocumentsPanelProvider.this.showTermVectorDialog();
        }

        void showDocValuesDialog(ActionEvent e) {
            DocumentsPanelProvider.this.showDocValuesDialog();
        }

        void showStoredValueDialog(ActionEvent e) {
            DocumentsPanelProvider.this.showStoredValueDialog();
        }

        void copyStoredValue(ActionEvent e) {
            DocumentsPanelProvider.this.copyStoredValue();
        }

        void copySelectedOrAllStoredValues(ActionEvent e) {
            DocumentsPanelProvider.this.copySelectedOrAllStoredValues();
        }
    }
}

