/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.luke.models.search;

import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.stream.Collectors;
import org.apache.lucene.document.DateTools;

public final class QueryParserConfig {
    private final boolean useClassicParser;
    private final boolean enablePositionIncrements;
    private final boolean allowLeadingWildcard;
    private final DateTools.Resolution dateResolution;
    private final Operator defaultOperator;
    private final float fuzzyMinSim;
    private final int fuzzyPrefixLength;
    private final Locale locale;
    private final TimeZone timeZone;
    private final int phraseSlop;
    private final boolean autoGenerateMultiTermSynonymsPhraseQuery;
    private final boolean autoGeneratePhraseQueries;
    private final boolean splitOnWhitespace;
    private final Map<String, Class<? extends Number>> typeMap;

    private QueryParserConfig(Builder builder) {
        this.useClassicParser = builder.useClassicParser;
        this.enablePositionIncrements = builder.enablePositionIncrements;
        this.allowLeadingWildcard = builder.allowLeadingWildcard;
        this.dateResolution = builder.dateResolution;
        this.defaultOperator = builder.defaultOperator;
        this.fuzzyMinSim = builder.fuzzyMinSim;
        this.fuzzyPrefixLength = builder.fuzzyPrefixLength;
        this.locale = builder.locale;
        this.timeZone = builder.timeZone;
        this.phraseSlop = builder.phraseSlop;
        this.autoGenerateMultiTermSynonymsPhraseQuery = builder.autoGenerateMultiTermSynonymsPhraseQuery;
        this.autoGeneratePhraseQueries = builder.autoGeneratePhraseQueries;
        this.splitOnWhitespace = builder.splitOnWhitespace;
        this.typeMap = Collections.unmodifiableMap(builder.typeMap);
    }

    public boolean isUseClassicParser() {
        return this.useClassicParser;
    }

    public boolean isAutoGenerateMultiTermSynonymsPhraseQuery() {
        return this.autoGenerateMultiTermSynonymsPhraseQuery;
    }

    public boolean isEnablePositionIncrements() {
        return this.enablePositionIncrements;
    }

    public boolean isAllowLeadingWildcard() {
        return this.allowLeadingWildcard;
    }

    public boolean isAutoGeneratePhraseQueries() {
        return this.autoGeneratePhraseQueries;
    }

    public boolean isSplitOnWhitespace() {
        return this.splitOnWhitespace;
    }

    public DateTools.Resolution getDateResolution() {
        return this.dateResolution;
    }

    public Operator getDefaultOperator() {
        return this.defaultOperator;
    }

    public float getFuzzyMinSim() {
        return this.fuzzyMinSim;
    }

    public int getFuzzyPrefixLength() {
        return this.fuzzyPrefixLength;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public int getPhraseSlop() {
        return this.phraseSlop;
    }

    public Map<String, Class<? extends Number>> getTypeMap() {
        return this.typeMap;
    }

    public String toString() {
        return "QueryParserConfig: [ default operator=" + this.defaultOperator.name() + "; enable position increment=" + this.enablePositionIncrements + "; allow leading wildcard=" + this.allowLeadingWildcard + "; split whitespace=" + this.splitOnWhitespace + "; generate phrase query=" + this.autoGeneratePhraseQueries + "; generate multiterm sysnonymsphrase query=" + this.autoGenerateMultiTermSynonymsPhraseQuery + "; phrase slop=" + this.phraseSlop + "; date resolution=" + this.dateResolution.name() + " locale=" + this.locale.toLanguageTag() + "; time zone=" + this.timeZone.getID() + "; numeric types=" + String.join((CharSequence)",", this.getTypeMap().entrySet().stream().map(e -> (String)e.getKey() + "=" + ((Class)e.getValue()).toString()).collect(Collectors.toSet())) + ";]";
    }

    public static class Builder {
        private boolean useClassicParser = true;
        private boolean enablePositionIncrements = true;
        private boolean allowLeadingWildcard = false;
        private DateTools.Resolution dateResolution = DateTools.Resolution.MILLISECOND;
        private Operator defaultOperator = Operator.OR;
        private float fuzzyMinSim = 2.0f;
        private int fuzzyPrefixLength = 0;
        private Locale locale = Locale.getDefault();
        private TimeZone timeZone = TimeZone.getDefault();
        private int phraseSlop = 0;
        private boolean autoGenerateMultiTermSynonymsPhraseQuery = false;
        private boolean autoGeneratePhraseQueries = false;
        private boolean splitOnWhitespace = false;
        private Map<String, Class<? extends Number>> typeMap = new HashMap<String, Class<? extends Number>>();

        public Builder useClassicParser(boolean value) {
            this.useClassicParser = value;
            return this;
        }

        public Builder enablePositionIncrements(boolean value) {
            this.enablePositionIncrements = value;
            return this;
        }

        public Builder allowLeadingWildcard(boolean value) {
            this.allowLeadingWildcard = value;
            return this;
        }

        public Builder dateResolution(DateTools.Resolution value) {
            this.dateResolution = value;
            return this;
        }

        public Builder defaultOperator(Operator op) {
            this.defaultOperator = op;
            return this;
        }

        public Builder fuzzyMinSim(float val) {
            this.fuzzyMinSim = val;
            return this;
        }

        public Builder fuzzyPrefixLength(int val) {
            this.fuzzyPrefixLength = val;
            return this;
        }

        public Builder locale(Locale val) {
            this.locale = val;
            return this;
        }

        public Builder timeZone(TimeZone val) {
            this.timeZone = val;
            return this;
        }

        public Builder phraseSlop(int val) {
            this.phraseSlop = val;
            return this;
        }

        public Builder autoGenerateMultiTermSynonymsPhraseQuery(boolean val) {
            this.autoGenerateMultiTermSynonymsPhraseQuery = val;
            return this;
        }

        public Builder autoGeneratePhraseQueries(boolean val) {
            this.autoGeneratePhraseQueries = val;
            return this;
        }

        public Builder splitOnWhitespace(boolean val) {
            this.splitOnWhitespace = val;
            return this;
        }

        public Builder typeMap(Map<String, Class<? extends Number>> val) {
            this.typeMap = val;
            return this;
        }

        public QueryParserConfig build() {
            return new QueryParserConfig(this);
        }
    }

    public static enum Operator {
        AND,
        OR;

    }
}

