/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.luke.models.documents;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.util.BytesRef;

public final class DocValues {
    private final DocValuesType dvType;
    private final List<BytesRef> values;
    private final List<Long> numericValues;

    static DocValues of(DocValuesType dvType, List<BytesRef> values, List<Long> numericValues) {
        return new DocValues(dvType, values, numericValues);
    }

    private DocValues(DocValuesType dvType, List<BytesRef> values, List<Long> numericValues) {
        this.dvType = dvType;
        this.values = values;
        this.numericValues = numericValues;
    }

    public DocValuesType getDvType() {
        return this.dvType;
    }

    public List<BytesRef> getValues() {
        return this.values;
    }

    public List<Long> getNumericValues() {
        return this.numericValues;
    }

    public String toString() {
        String numValuesStr = this.numericValues.stream().map(String::valueOf).collect(Collectors.joining(","));
        return "DocValues{dvType=" + this.dvType + ", values=" + this.values + ", numericValues=[" + numValuesStr + "]" + '}';
    }
}

