/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.spatial4j.io.jackson;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Reader;
import java.text.ParseException;
import org.locationtech.spatial4j.exception.InvalidShapeException;
import org.locationtech.spatial4j.io.ShapeReader;
import org.locationtech.spatial4j.shape.Shape;

public class JacksonShapeReader
implements ShapeReader {
    final ObjectMapper mapper;

    public JacksonShapeReader(ObjectMapper m) {
        this.mapper = m;
    }

    public String getFormatName() {
        return this.getClass().getSimpleName();
    }

    public Shape read(Object value) throws IOException, ParseException, InvalidShapeException {
        String str = value.toString();
        return (Shape)this.mapper.readValue(str, Shape.class);
    }

    public Shape readIfSupported(Object value) throws InvalidShapeException {
        try {
            return this.read(value);
        }
        catch (IOException | ParseException e) {
            return null;
        }
    }

    public Shape read(Reader reader) throws IOException, ParseException, InvalidShapeException {
        return (Shape)this.mapper.readValue(reader, Shape.class);
    }
}

