/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.spatial4j.io;

import java.text.ParseException;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.spatial4j.context.SpatialContext;
import org.locationtech.spatial4j.context.jts.DatelineRule;
import org.locationtech.spatial4j.context.jts.JtsSpatialContext;
import org.locationtech.spatial4j.context.jts.JtsSpatialContextFactory;
import org.locationtech.spatial4j.context.jts.ValidationRule;
import org.locationtech.spatial4j.exception.InvalidShapeException;
import org.locationtech.spatial4j.io.WktShapeParserTest;
import org.locationtech.spatial4j.shape.Rectangle;
import org.locationtech.spatial4j.shape.Shape;
import org.locationtech.spatial4j.shape.ShapeFactory;
import org.locationtech.spatial4j.shape.SpatialRelation;

public class JtsWktShapeParserTest
extends WktShapeParserTest {
    final JtsSpatialContext ctx;

    public JtsWktShapeParserTest() {
        super((SpatialContext)JtsWktShapeParserTest.createSpatialContext());
        this.ctx = (JtsSpatialContext)((WktShapeParserTest)this).ctx;
    }

    static JtsSpatialContext createSpatialContext() {
        JtsSpatialContextFactory factory = new JtsSpatialContextFactory();
        factory.useJtsMulti = false;
        return factory.newSpatialContext();
    }

    @Test
    public void testParsePolygon() throws ParseException {
        Shape polygonNoHoles = ((ShapeFactory.PolygonBuilder)((ShapeFactory.PolygonBuilder)((ShapeFactory.PolygonBuilder)((ShapeFactory.PolygonBuilder)((ShapeFactory.PolygonBuilder)this.ctx.getShapeFactory().polygon().pointXY(100.0, 0.0)).pointXY(101.0, 0.0)).pointXY(101.0, 1.0)).pointXY(100.0, 2.0)).pointXY(100.0, 0.0)).build();
        String polygonNoHolesSTR = "POLYGON ((100 0, 101 0, 101 1, 100 2, 100 0))";
        this.assertParses(polygonNoHolesSTR, polygonNoHoles);
        this.assertParses("POLYGON((100 0,101 0,101 1,100 2,100 0))", polygonNoHoles);
        this.assertParses("GEOMETRYCOLLECTION ( " + polygonNoHolesSTR + ")", (Shape)this.ctx.makeCollection(Arrays.asList(polygonNoHoles)));
        Shape polygonWithHoles = ((ShapeFactory.PolygonBuilder.HoleBuilder)((ShapeFactory.PolygonBuilder.HoleBuilder)((ShapeFactory.PolygonBuilder.HoleBuilder)((ShapeFactory.PolygonBuilder.HoleBuilder)((ShapeFactory.PolygonBuilder.HoleBuilder)((ShapeFactory.PolygonBuilder)((ShapeFactory.PolygonBuilder)((ShapeFactory.PolygonBuilder)((ShapeFactory.PolygonBuilder)((ShapeFactory.PolygonBuilder)this.ctx.getShapeFactory().polygon().pointXY(100.0, 0.0)).pointXY(101.0, 0.0)).pointXY(101.0, 1.0)).pointXY(100.0, 1.0)).pointXY(100.0, 0.0)).hole().pointXY(100.2, 0.2)).pointXY(100.8, 0.2)).pointXY(100.8, 0.8)).pointXY(100.2, 0.8)).pointXY(100.2, 0.2)).endHole().build();
        this.assertParses("POLYGON ((100 0, 101 0, 101 1, 100 1, 100 0), (100.2 0.2, 100.8 0.2, 100.8 0.8, 100.2 0.8, 100.2 0.2))", polygonWithHoles);
        this.assertParses("POLYGON EMPTY", this.ctx.getShapeFactory().polygon().build());
    }

    @Test
    public void testPolyToRect() throws ParseException {
        this.assertParses("POLYGON((0 5, 10 5, 10 20, 0 20, 0 5))", (Shape)this.ctx.makeRectangle(0.0, 10.0, 5.0, 20.0));
    }

    @Test
    public void polyToRect180Rule() throws ParseException {
        Rectangle expected = this.ctx.makeRectangle(160.0, -170.0, 0.0, 10.0);
        this.assertParses("POLYGON((160 0, -170 0, -170 10, 160 10, 160 0))", (Shape)expected);
        this.assertParses("POLYGON((160 10, -170 10, -170 0, 160 0, 160 10))", (Shape)expected);
    }

    @Test
    public void polyToRectCcwRule() throws ParseException {
        JtsSpatialContext ctx = new JtsSpatialContextFactory(){
            {
                this.datelineRule = DatelineRule.ccwRect;
            }
        }.newSpatialContext();
        Assert.assertEquals((Object)this.wkt((SpatialContext)ctx, "POLYGON((160 0, -170 0, -170 10, 160 10, 160 0))"), (Object)ctx.makeRectangle(160.0, -170.0, 0.0, 10.0));
        Assert.assertEquals((Object)this.wkt((SpatialContext)ctx, "POLYGON((160 10, -170 10, -170 0, 160 0, 160 10))"), (Object)ctx.makeRectangle(-170.0, 160.0, 0.0, 10.0));
    }

    @Test
    public void testParseMultiPolygon() throws ParseException {
        ShapeFactory.MultiPolygonBuilder multiPolygonBuilder = this.ctx.getShapeFactory().multiPolygon();
        multiPolygonBuilder.add((ShapeFactory.PolygonBuilder)((ShapeFactory.PolygonBuilder)((ShapeFactory.PolygonBuilder)((ShapeFactory.PolygonBuilder)((ShapeFactory.PolygonBuilder)multiPolygonBuilder.polygon().pointXY(100.0, 0.0)).pointXY(101.0, 0.0)).pointXY(101.0, 2.0)).pointXY(100.0, 1.0)).pointXY(100.0, 0.0));
        multiPolygonBuilder.add((ShapeFactory.PolygonBuilder)((ShapeFactory.PolygonBuilder)((ShapeFactory.PolygonBuilder)((ShapeFactory.PolygonBuilder)((ShapeFactory.PolygonBuilder)multiPolygonBuilder.polygon().pointXY(0.0, 0.0)).pointXY(2.0, 0.0)).pointXY(2.0, 2.0)).pointXY(0.0, 1.0)).pointXY(0.0, 0.0));
        Shape s = multiPolygonBuilder.build();
        this.assertParses("MULTIPOLYGON(((100 0, 101 0, 101 2, 100 1, 100 0)),((0 0, 2 0, 2 2, 0 1, 0 0)))", s);
        this.assertParses("MULTIPOLYGON EMPTY", this.ctx.getShapeFactory().multiPolygon().build());
    }

    @Test
    public void testLineStringDateline() throws ParseException {
        Shape s = this.wkt("LINESTRING(160 10, -170 15)");
        Assert.assertEquals((double)30.0, (double)s.getBoundingBox().getWidth(), (double)0.0);
    }

    @Test
    public void testWrapTopologyException() throws Exception {
        assert (this.ctx.getValidationRule() != ValidationRule.none);
        try {
            this.wkt("POLYGON((0 0, 10 0, 10 20))");
            Assert.fail();
        }
        catch (InvalidShapeException invalidShapeException) {
            // empty catch block
        }
        try {
            this.wkt("POLYGON((0 0, 10 0, 10 20, 5 -5, 0 20, 0 0))");
            Assert.fail();
        }
        catch (InvalidShapeException invalidShapeException) {
            // empty catch block
        }
    }

    @Test
    public void testPolygonRepair() throws ParseException {
        System.setProperty("spatial4j.JtsGeometry.assertValidate", "false");
        String wkt = "POLYGON((0 0, 10 0, 10 20, 5 -5, 0 20, 0 0))";
        JtsSpatialContextFactory factory = new JtsSpatialContextFactory();
        factory.validationRule = ValidationRule.repairBuffer0;
        JtsSpatialContext ctx = factory.newSpatialContext();
        Shape buffer0 = this.wkt((SpatialContext)ctx, wkt);
        Assert.assertTrue((buffer0.getArea((SpatialContext)ctx) > 0.0 ? 1 : 0) != 0);
        factory = new JtsSpatialContextFactory();
        factory.validationRule = ValidationRule.repairConvexHull;
        ctx = factory.newSpatialContext();
        Shape cvxHull = this.wkt((SpatialContext)ctx, wkt);
        Assert.assertTrue((cvxHull.getArea((SpatialContext)ctx) > 0.0 ? 1 : 0) != 0);
        Assert.assertEquals((Object)SpatialRelation.CONTAINS, (Object)cvxHull.relate(buffer0));
        factory = new JtsSpatialContextFactory();
        factory.validationRule = ValidationRule.none;
        ctx = factory.newSpatialContext();
        this.wkt((SpatialContext)ctx, wkt);
    }
}

