/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.luke.models.overview;

import org.apache.lucene.luke.util.BytesRefUtils;

public final class TermStats {
    private final String decodedTermText;
    private final String field;
    private final int docFreq;

    static TermStats of(org.apache.lucene.misc.TermStats stats) {
        String termText = BytesRefUtils.decode(stats.termtext);
        return new TermStats(termText, stats.field, stats.docFreq);
    }

    private TermStats(String decodedTermText, String field, int docFreq) {
        this.decodedTermText = decodedTermText;
        this.field = field;
        this.docFreq = docFreq;
    }

    public String getDecodedTermText() {
        return this.decodedTermText;
    }

    public String getField() {
        return this.field;
    }

    public int getDocFreq() {
        return this.docFreq;
    }

    public String toString() {
        return "TermStats{decodedTermText='" + this.decodedTermText + '\'' + ", field='" + this.field + '\'' + ", docFreq=" + this.docFreq + '}';
    }
}

