/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.luke.app.desktop.components;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.index.Term;
import org.apache.lucene.luke.app.IndexHandler;
import org.apache.lucene.luke.app.IndexObserver;
import org.apache.lucene.luke.app.LukeState;
import org.apache.lucene.luke.app.desktop.MessageBroker;
import org.apache.lucene.luke.app.desktop.components.AnalysisTabOperator;
import org.apache.lucene.luke.app.desktop.components.ComponentOperatorRegistry;
import org.apache.lucene.luke.app.desktop.components.DocumentsTabOperator;
import org.apache.lucene.luke.app.desktop.components.SearchTabOperator;
import org.apache.lucene.luke.app.desktop.components.TabSwitcherProxy;
import org.apache.lucene.luke.app.desktop.components.TabbedPaneProvider;
import org.apache.lucene.luke.app.desktop.components.TableColumnInfo;
import org.apache.lucene.luke.app.desktop.components.TableModelBase;
import org.apache.lucene.luke.app.desktop.components.dialog.ConfirmDialogFactory;
import org.apache.lucene.luke.app.desktop.components.dialog.search.ExplainDialogFactory;
import org.apache.lucene.luke.app.desktop.components.fragments.search.AnalyzerPaneProvider;
import org.apache.lucene.luke.app.desktop.components.fragments.search.FieldValuesPaneProvider;
import org.apache.lucene.luke.app.desktop.components.fragments.search.FieldValuesTabOperator;
import org.apache.lucene.luke.app.desktop.components.fragments.search.MLTPaneProvider;
import org.apache.lucene.luke.app.desktop.components.fragments.search.MLTTabOperator;
import org.apache.lucene.luke.app.desktop.components.fragments.search.QueryParserPaneProvider;
import org.apache.lucene.luke.app.desktop.components.fragments.search.QueryParserTabOperator;
import org.apache.lucene.luke.app.desktop.components.fragments.search.SimilarityPaneProvider;
import org.apache.lucene.luke.app.desktop.components.fragments.search.SimilarityTabOperator;
import org.apache.lucene.luke.app.desktop.components.fragments.search.SortPaneProvider;
import org.apache.lucene.luke.app.desktop.components.fragments.search.SortTabOperator;
import org.apache.lucene.luke.app.desktop.util.DialogOpener;
import org.apache.lucene.luke.app.desktop.util.FontUtils;
import org.apache.lucene.luke.app.desktop.util.MessageUtils;
import org.apache.lucene.luke.app.desktop.util.StringUtils;
import org.apache.lucene.luke.app.desktop.util.StyleConstants;
import org.apache.lucene.luke.app.desktop.util.TabUtils;
import org.apache.lucene.luke.app.desktop.util.TableUtils;
import org.apache.lucene.luke.models.LukeException;
import org.apache.lucene.luke.models.search.MLTConfig;
import org.apache.lucene.luke.models.search.QueryParserConfig;
import org.apache.lucene.luke.models.search.Search;
import org.apache.lucene.luke.models.search.SearchFactory;
import org.apache.lucene.luke.models.search.SearchResults;
import org.apache.lucene.luke.models.search.SimilarityConfig;
import org.apache.lucene.luke.models.tools.IndexTools;
import org.apache.lucene.luke.models.tools.IndexToolsFactory;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TotalHits;

public final class SearchPanelProvider
implements SearchTabOperator {
    private static final int DEFAULT_PAGE_SIZE = 10;
    private final SearchFactory searchFactory;
    private final IndexToolsFactory toolsFactory;
    private final IndexHandler indexHandler;
    private final MessageBroker messageBroker;
    private final TabSwitcherProxy tabSwitcher;
    private final ComponentOperatorRegistry operatorRegistry;
    private final ConfirmDialogFactory confirmDialogFactory;
    private final ExplainDialogFactory explainDialogProvider;
    private final JTabbedPane tabbedPane = new JTabbedPane();
    private final JScrollPane qparser;
    private final JScrollPane analyzer;
    private final JScrollPane similarity;
    private final JScrollPane sort;
    private final JScrollPane values;
    private final JScrollPane mlt;
    private final JCheckBox termQueryCB = new JCheckBox();
    private final JTextArea queryStringTA = new JTextArea();
    private final JTextArea parsedQueryTA = new JTextArea();
    private final JButton parseBtn = new JButton();
    private final JCheckBox rewriteCB = new JCheckBox();
    private final JButton searchBtn = new JButton();
    private JCheckBox exactHitsCntCB = new JCheckBox();
    private final JButton mltBtn = new JButton();
    private final JFormattedTextField mltDocFTF = new JFormattedTextField();
    private final JLabel totalHitsLbl = new JLabel();
    private final JLabel startLbl = new JLabel();
    private final JLabel endLbl = new JLabel();
    private final JButton prevBtn = new JButton();
    private final JButton nextBtn = new JButton();
    private final JButton delBtn = new JButton();
    private final JTable resultsTable = new JTable();
    private final ListenerFunctions listeners = new ListenerFunctions();
    private Search searchModel;
    private IndexTools toolsModel;

    public SearchPanelProvider() throws IOException {
        this.searchFactory = new SearchFactory();
        this.toolsFactory = new IndexToolsFactory();
        this.indexHandler = IndexHandler.getInstance();
        this.messageBroker = MessageBroker.getInstance();
        this.tabSwitcher = TabSwitcherProxy.getInstance();
        this.operatorRegistry = ComponentOperatorRegistry.getInstance();
        this.confirmDialogFactory = ConfirmDialogFactory.getInstance();
        this.explainDialogProvider = ExplainDialogFactory.getInstance();
        this.qparser = new QueryParserPaneProvider().get();
        this.analyzer = new AnalyzerPaneProvider().get();
        this.similarity = new SimilarityPaneProvider().get();
        this.sort = new SortPaneProvider().get();
        this.values = new FieldValuesPaneProvider().get();
        this.mlt = new MLTPaneProvider().get();
        this.indexHandler.addObserver(new Observer());
        this.operatorRegistry.register(SearchTabOperator.class, this);
    }

    public JPanel get() {
        JPanel panel = new JPanel(new GridLayout(1, 1));
        panel.setOpaque(false);
        panel.setBorder(BorderFactory.createLineBorder(Color.gray));
        JSplitPane splitPane = new JSplitPane(0, this.initUpperPanel(), this.initLowerPanel());
        splitPane.setOpaque(false);
        splitPane.setDividerLocation(350);
        panel.add(splitPane);
        return panel;
    }

    private JSplitPane initUpperPanel() {
        JSplitPane splitPane = new JSplitPane(1, this.initQuerySettingsPane(), this.initQueryPane());
        splitPane.setOpaque(false);
        splitPane.setDividerLocation(570);
        return splitPane;
    }

    private JPanel initQuerySettingsPane() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setOpaque(false);
        panel.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        JLabel label = new JLabel(MessageUtils.getLocalizedMessage("search.label.settings"));
        panel.add((Component)label, "First");
        this.tabbedPane.addTab("Query Parser", this.qparser);
        this.tabbedPane.addTab("Analyzer", this.analyzer);
        this.tabbedPane.addTab("Similarity", this.similarity);
        this.tabbedPane.addTab("Sort", this.sort);
        this.tabbedPane.addTab("Field Values", this.values);
        this.tabbedPane.addTab("More Like This", this.mlt);
        TabUtils.forceTransparent(this.tabbedPane);
        panel.add((Component)this.tabbedPane, "Center");
        return panel;
    }

    private JPanel initQueryPane() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setOpaque(false);
        panel.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.anchor = 21;
        JLabel labelQE = new JLabel(MessageUtils.getLocalizedMessage("search.label.expression"));
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 2;
        c.weightx = 0.5;
        c.insets = new Insets(2, 0, 2, 2);
        panel.add((Component)labelQE, c);
        this.termQueryCB.setText(MessageUtils.getLocalizedMessage("search.checkbox.term"));
        this.termQueryCB.addActionListener(this.listeners::toggleTermQuery);
        this.termQueryCB.setOpaque(false);
        c.gridx = 2;
        c.gridy = 0;
        c.gridwidth = 1;
        c.weightx = 0.2;
        c.insets = new Insets(2, 0, 2, 2);
        panel.add((Component)this.termQueryCB, c);
        this.queryStringTA.setRows(3);
        this.queryStringTA.setLineWrap(true);
        this.queryStringTA.setText("*:*");
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 3;
        c.weightx = 0.0;
        c.insets = new Insets(2, 0, 2, 2);
        panel.add((Component)new JScrollPane(this.queryStringTA, 20, 31), c);
        JLabel labelPQ = new JLabel(MessageUtils.getLocalizedMessage("search.label.parsed"));
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 3;
        c.weightx = 0.0;
        c.insets = new Insets(8, 0, 2, 2);
        panel.add((Component)labelPQ, c);
        this.parsedQueryTA.setRows(3);
        this.parsedQueryTA.setLineWrap(true);
        this.parsedQueryTA.setEditable(false);
        c.gridx = 0;
        c.gridy = 3;
        c.gridwidth = 3;
        c.weightx = 0.0;
        c.insets = new Insets(2, 0, 2, 2);
        panel.add((Component)new JScrollPane(this.parsedQueryTA), c);
        this.parseBtn.setText(FontUtils.elegantIconHtml("&#xe0df;", MessageUtils.getLocalizedMessage("search.button.parse")));
        this.parseBtn.setFont(StyleConstants.FONT_BUTTON_LARGE);
        this.parseBtn.setMargin(new Insets(3, 0, 3, 0));
        this.parseBtn.addActionListener(this.listeners::execParse);
        c.gridx = 0;
        c.gridy = 4;
        c.gridwidth = 1;
        c.weightx = 0.2;
        c.insets = new Insets(5, 0, 0, 2);
        panel.add((Component)this.parseBtn, c);
        this.rewriteCB.setText(MessageUtils.getLocalizedMessage("search.checkbox.rewrite"));
        this.rewriteCB.setOpaque(false);
        c.gridx = 1;
        c.gridy = 4;
        c.gridwidth = 2;
        c.weightx = 0.2;
        c.insets = new Insets(5, 0, 0, 2);
        panel.add((Component)this.rewriteCB, c);
        this.searchBtn.setText(FontUtils.elegantIconHtml("&#x55;", MessageUtils.getLocalizedMessage("search.button.search")));
        this.searchBtn.setFont(StyleConstants.FONT_BUTTON_LARGE);
        this.searchBtn.setMargin(new Insets(3, 0, 3, 0));
        this.searchBtn.addActionListener(this.listeners::execSearch);
        c.gridx = 0;
        c.gridy = 5;
        c.gridwidth = 1;
        c.weightx = 0.2;
        c.insets = new Insets(5, 0, 5, 0);
        panel.add((Component)this.searchBtn, c);
        this.exactHitsCntCB.setText(MessageUtils.getLocalizedMessage("search.checkbox.exact_hits_cnt"));
        this.exactHitsCntCB.setOpaque(false);
        c.gridx = 1;
        c.gridy = 5;
        c.gridwidth = 2;
        c.weightx = 0.2;
        c.insets = new Insets(5, 0, 0, 2);
        panel.add((Component)this.exactHitsCntCB, c);
        this.mltBtn.setText(FontUtils.elegantIconHtml("&#xe030;", MessageUtils.getLocalizedMessage("search.button.mlt")));
        this.mltBtn.setFont(StyleConstants.FONT_BUTTON_LARGE);
        this.mltBtn.setMargin(new Insets(3, 0, 3, 0));
        this.mltBtn.addActionListener(this.listeners::execMLTSearch);
        c.gridx = 0;
        c.gridy = 6;
        c.gridwidth = 1;
        c.weightx = 0.3;
        c.insets = new Insets(10, 0, 2, 0);
        panel.add((Component)this.mltBtn, c);
        JPanel docNo = new JPanel(new FlowLayout(3));
        docNo.setOpaque(false);
        JLabel docNoLabel = new JLabel("with doc #");
        docNo.add(docNoLabel);
        this.mltDocFTF.setColumns(8);
        this.mltDocFTF.setValue(0);
        docNo.add(this.mltDocFTF);
        c.gridx = 1;
        c.gridy = 6;
        c.gridwidth = 2;
        c.weightx = 0.3;
        c.insets = new Insets(8, 0, 0, 2);
        panel.add((Component)docNo, c);
        return panel;
    }

    private JPanel initLowerPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setOpaque(false);
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        panel.add((Component)this.initSearchResultsHeaderPane(), "First");
        panel.add((Component)this.initSearchResultsTablePane(), "Center");
        return panel;
    }

    private JPanel initSearchResultsHeaderPane() {
        JPanel panel = new JPanel(new GridLayout(1, 2));
        panel.setOpaque(false);
        JLabel label = new JLabel(FontUtils.elegantIconHtml("&#xe025;", MessageUtils.getLocalizedMessage("search.label.results")));
        label.setHorizontalTextPosition(2);
        label.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
        panel.add(label);
        JPanel resultsInfo = new JPanel(new FlowLayout(4));
        resultsInfo.setOpaque(false);
        resultsInfo.setOpaque(false);
        JLabel totalLabel = new JLabel(MessageUtils.getLocalizedMessage("search.label.total"));
        resultsInfo.add(totalLabel);
        this.totalHitsLbl.setText("?");
        resultsInfo.add(this.totalHitsLbl);
        this.prevBtn.setText(FontUtils.elegantIconHtml("&#x44;"));
        this.prevBtn.setMargin(new Insets(5, 0, 5, 0));
        this.prevBtn.setPreferredSize(new Dimension(30, 20));
        this.prevBtn.setEnabled(false);
        this.prevBtn.addActionListener(this.listeners::prevPage);
        resultsInfo.add(this.prevBtn);
        this.startLbl.setText("0");
        resultsInfo.add(this.startLbl);
        resultsInfo.add(new JLabel(" ~ "));
        this.endLbl.setText("0");
        resultsInfo.add(this.endLbl);
        this.nextBtn.setText(FontUtils.elegantIconHtml("&#x45;"));
        this.nextBtn.setMargin(new Insets(3, 0, 3, 0));
        this.nextBtn.setPreferredSize(new Dimension(30, 20));
        this.nextBtn.setEnabled(false);
        this.nextBtn.addActionListener(this.listeners::nextPage);
        resultsInfo.add(this.nextBtn);
        JSeparator sep = new JSeparator(1);
        sep.setPreferredSize(new Dimension(5, 1));
        resultsInfo.add(sep);
        this.delBtn.setText(FontUtils.elegantIconHtml("&#xe07d;", MessageUtils.getLocalizedMessage("search.button.del_all")));
        this.delBtn.setMargin(new Insets(5, 0, 5, 0));
        this.delBtn.setEnabled(false);
        this.delBtn.addActionListener(this.listeners::confirmDeletion);
        resultsInfo.add(this.delBtn);
        panel.add((Component)resultsInfo, "Center");
        return panel;
    }

    private JPanel initSearchResultsTablePane() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setOpaque(false);
        JPanel note = new JPanel(new FlowLayout(3, 5, 2));
        note.setOpaque(false);
        note.add(new JLabel(MessageUtils.getLocalizedMessage("search.label.results.note")));
        panel.add((Component)note, "First");
        TableUtils.setupTable(this.resultsTable, 0, new SearchResultsTableModel(), new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                SearchPanelProvider.this.listeners.showContextMenuInResultsTable(e);
            }
        }, SearchResultsTableModel.Column.DOCID.getColumnWidth(), SearchResultsTableModel.Column.SCORE.getColumnWidth());
        JScrollPane scrollPane = new JScrollPane(this.resultsTable);
        panel.add((Component)scrollPane, "Center");
        return panel;
    }

    private void toggleTermQuery() {
        if (this.termQueryCB.isSelected()) {
            this.enableTermQuery();
        } else {
            this.disableTermQuery();
        }
    }

    private void enableTermQuery() {
        this.tabbedPane.setEnabledAt(Tab.QPARSER.index(), false);
        this.tabbedPane.setEnabledAt(Tab.ANALYZER.index(), false);
        this.tabbedPane.setEnabledAt(Tab.SIMILARITY.index(), false);
        if (this.tabbedPane.getSelectedIndex() == Tab.QPARSER.index() || this.tabbedPane.getSelectedIndex() == Tab.ANALYZER.index() || this.tabbedPane.getSelectedIndex() == Tab.SIMILARITY.index() || this.tabbedPane.getSelectedIndex() == Tab.MLT.index()) {
            this.tabbedPane.setSelectedIndex(Tab.SORT.index());
        }
        this.parseBtn.setEnabled(false);
        this.rewriteCB.setEnabled(false);
    }

    private void disableTermQuery() {
        this.tabbedPane.setEnabledAt(Tab.QPARSER.index(), true);
        this.tabbedPane.setEnabledAt(Tab.ANALYZER.index(), true);
        this.tabbedPane.setEnabledAt(Tab.SIMILARITY.index(), true);
        this.parseBtn.setEnabled(true);
        this.rewriteCB.setEnabled(true);
    }

    private void execParse() {
        Query query = this.parse(this.rewriteCB.isSelected());
        this.parsedQueryTA.setText(query.toString());
        this.messageBroker.clearStatusMessage();
    }

    private void doSearch() {
        Query query;
        if (this.termQueryCB.isSelected()) {
            if (StringUtils.isNullOrEmpty(this.queryStringTA.getText())) {
                throw new LukeException("Query is not set.");
            }
            String[] tmp = this.queryStringTA.getText().split(":");
            if (tmp.length < 2) {
                throw new LukeException(String.format(Locale.ENGLISH, "Invalid query [ %s ]", this.queryStringTA.getText()));
            }
            query = new TermQuery(new Term(tmp[0].trim(), tmp[1].trim()));
        } else {
            query = this.parse(false);
        }
        SimilarityConfig simConfig = this.operatorRegistry.get(SimilarityTabOperator.class).map(SimilarityTabOperator::getConfig).orElse(new SimilarityConfig.Builder().build());
        Sort sort = this.operatorRegistry.get(SortTabOperator.class).map(SortTabOperator::getSort).orElse(null);
        Set<String> fieldsToLoad = this.operatorRegistry.get(FieldValuesTabOperator.class).map(FieldValuesTabOperator::getFieldsToLoad).orElse(Collections.emptySet());
        SearchResults results = this.searchModel.search(query, simConfig, sort, fieldsToLoad, 10, this.exactHitsCntCB.isSelected());
        TableUtils.setupTable(this.resultsTable, 0, new SearchResultsTableModel(), null, SearchResultsTableModel.Column.DOCID.getColumnWidth(), SearchResultsTableModel.Column.SCORE.getColumnWidth());
        this.populateResults(results);
        this.messageBroker.clearStatusMessage();
    }

    private void nextPage() {
        this.searchModel.nextPage().ifPresent(this::populateResults);
        this.messageBroker.clearStatusMessage();
    }

    private void prevPage() {
        this.searchModel.prevPage().ifPresent(this::populateResults);
        this.messageBroker.clearStatusMessage();
    }

    private void doMLTSearch() {
        if (Objects.isNull(this.mltDocFTF.getValue())) {
            throw new LukeException("Doc num is not set.");
        }
        int docNum = (Integer)this.mltDocFTF.getValue();
        MLTConfig mltConfig = this.operatorRegistry.get(MLTTabOperator.class).map(MLTTabOperator::getConfig).orElse(new MLTConfig.Builder().build());
        Analyzer analyzer = this.operatorRegistry.get(AnalysisTabOperator.class).map(AnalysisTabOperator::getCurrentAnalyzer).orElse((Analyzer)new StandardAnalyzer());
        Query query = this.searchModel.mltQuery(docNum, mltConfig, analyzer);
        Set<String> fieldsToLoad = this.operatorRegistry.get(FieldValuesTabOperator.class).map(FieldValuesTabOperator::getFieldsToLoad).orElse(Collections.emptySet());
        SearchResults results = this.searchModel.search(query, new SimilarityConfig.Builder().build(), fieldsToLoad, 10, false);
        TableUtils.setupTable(this.resultsTable, 0, new SearchResultsTableModel(), null, SearchResultsTableModel.Column.DOCID.getColumnWidth(), SearchResultsTableModel.Column.SCORE.getColumnWidth());
        this.populateResults(results);
        this.messageBroker.clearStatusMessage();
    }

    private Query parse(boolean rewrite) {
        String expr = StringUtils.isNullOrEmpty(this.queryStringTA.getText()) ? "*:*" : this.queryStringTA.getText();
        String df = this.operatorRegistry.get(QueryParserTabOperator.class).map(QueryParserTabOperator::getDefaultField).orElse("");
        QueryParserConfig config = this.operatorRegistry.get(QueryParserTabOperator.class).map(QueryParserTabOperator::getConfig).orElse(new QueryParserConfig.Builder().build());
        Analyzer analyzer = this.operatorRegistry.get(AnalysisTabOperator.class).map(AnalysisTabOperator::getCurrentAnalyzer).orElse((Analyzer)new StandardAnalyzer());
        return this.searchModel.parseQuery(expr, df, analyzer, config, rewrite);
    }

    private void populateResults(SearchResults res) {
        this.totalHitsLbl.setText(String.valueOf(res.getTotalHits()));
        if (res.getTotalHits().value > 0L) {
            this.startLbl.setText(String.valueOf(res.getOffset() + 1));
            this.endLbl.setText(String.valueOf(res.getOffset() + res.size()));
            this.prevBtn.setEnabled(res.getOffset() > 0);
            this.nextBtn.setEnabled(res.getTotalHits().relation == TotalHits.Relation.GREATER_THAN_OR_EQUAL_TO || res.getTotalHits().value > (long)(res.getOffset() + res.size()));
            if (!this.indexHandler.getState().readOnly() && this.indexHandler.getState().hasDirectoryReader()) {
                this.delBtn.setEnabled(true);
            }
            this.resultsTable.setModel(new SearchResultsTableModel(res));
            this.resultsTable.getColumnModel().getColumn(SearchResultsTableModel.Column.DOCID.getIndex()).setPreferredWidth(SearchResultsTableModel.Column.DOCID.getColumnWidth());
            this.resultsTable.getColumnModel().getColumn(SearchResultsTableModel.Column.SCORE.getIndex()).setPreferredWidth(SearchResultsTableModel.Column.SCORE.getColumnWidth());
            this.resultsTable.getColumnModel().getColumn(SearchResultsTableModel.Column.VALUE.getIndex()).setPreferredWidth(SearchResultsTableModel.Column.VALUE.getColumnWidth());
        } else {
            this.startLbl.setText("0");
            this.endLbl.setText("0");
            this.prevBtn.setEnabled(false);
            this.nextBtn.setEnabled(false);
            this.delBtn.setEnabled(false);
        }
    }

    private void confirmDeletion() {
        new DialogOpener<ConfirmDialogFactory>(this.confirmDialogFactory).open("Confirm Deletion", 400, 200, factory -> {
            factory.setMessage(MessageUtils.getLocalizedMessage("search.message.delete_confirm"));
            factory.setCallback(this::deleteDocs);
        }, new String[0]);
    }

    private void deleteDocs() {
        Query query = this.searchModel.getCurrentQuery();
        if (query != null) {
            this.toolsModel.deleteDocuments(query);
            this.indexHandler.reOpen();
            this.messageBroker.showStatusMessage(MessageUtils.getLocalizedMessage("search.message.delete_success", query.toString()));
        }
        this.delBtn.setEnabled(false);
    }

    private JPopupMenu setupResultsContextMenuPopup() {
        JPopupMenu popup = new JPopupMenu();
        JMenuItem item1 = new JMenuItem(MessageUtils.getLocalizedMessage("search.results.menu.explain"));
        item1.addActionListener(e -> {
            int docid = (Integer)this.resultsTable.getModel().getValueAt(this.resultsTable.getSelectedRow(), SearchResultsTableModel.Column.DOCID.getIndex());
            Explanation explanation = this.searchModel.explain(this.parse(false), docid);
            new DialogOpener<ExplainDialogFactory>(this.explainDialogProvider).open("Explanation", 600, 400, factory -> {
                factory.setDocid(docid);
                factory.setExplanation(explanation);
            }, new String[0]);
        });
        popup.add(item1);
        JMenuItem item2 = new JMenuItem(MessageUtils.getLocalizedMessage("search.results.menu.showdoc"));
        item2.addActionListener(e -> {
            int docid = (Integer)this.resultsTable.getModel().getValueAt(this.resultsTable.getSelectedRow(), SearchResultsTableModel.Column.DOCID.getIndex());
            this.operatorRegistry.get(DocumentsTabOperator.class).ifPresent(operator -> operator.displayDoc(docid));
            this.tabSwitcher.switchTab(TabbedPaneProvider.Tab.DOCUMENTS);
        });
        popup.add(item2);
        return popup;
    }

    @Override
    public void searchByTerm(String field, String term) {
        this.termQueryCB.setSelected(true);
        this.enableTermQuery();
        this.queryStringTA.setText(field + ":" + term);
        this.doSearch();
    }

    @Override
    public void mltSearch(int docNum) {
        this.mltDocFTF.setValue(docNum);
        this.doMLTSearch();
        this.tabbedPane.setSelectedIndex(Tab.MLT.index());
    }

    @Override
    public void enableExactHitsCB(boolean value) {
        this.exactHitsCntCB.setEnabled(value);
    }

    @Override
    public void setExactHits(boolean value) {
        this.exactHitsCntCB.setSelected(value);
    }

    static final class SearchResultsTableModel
    extends TableModelBase<Column> {
        SearchResultsTableModel() {
        }

        SearchResultsTableModel(SearchResults results) {
            super(results.size());
            for (int i = 0; i < results.size(); ++i) {
                SearchResults.Doc doc = results.getHits().get(i);
                this.data[i][Column.DOCID.getIndex()] = doc.getDocId();
                this.data[i][Column.SCORE.getIndex()] = !Float.isNaN(doc.getScore()) ? Float.valueOf(doc.getScore()) : Float.valueOf(1.0f);
                List concatValues = doc.getFieldValues().entrySet().stream().map(e -> {
                    String v = String.join((CharSequence)",", Arrays.asList((Object[])e.getValue()));
                    return (String)e.getKey() + "=" + v + ";";
                }).collect(Collectors.toList());
                this.data[i][Column.VALUE.getIndex()] = String.join((CharSequence)" ", concatValues);
            }
        }

        protected Column[] columnInfos() {
            return Column.values();
        }

        static enum Column implements TableColumnInfo
        {
            DOCID("Doc ID", 0, Integer.class, 50),
            SCORE("Score", 1, Float.class, 100),
            VALUE("Field Values", 2, String.class, 800);

            private final String colName;
            private final int index;
            private final Class<?> type;
            private final int width;

            private Column(String colName, int index, Class<?> type, int width) {
                this.colName = colName;
                this.index = index;
                this.type = type;
                this.width = width;
            }

            @Override
            public String getColName() {
                return this.colName;
            }

            @Override
            public int getIndex() {
                return this.index;
            }

            @Override
            public Class<?> getType() {
                return this.type;
            }

            @Override
            public int getColumnWidth() {
                return this.width;
            }
        }
    }

    public static enum Tab {
        QPARSER(0),
        ANALYZER(1),
        SIMILARITY(2),
        SORT(3),
        VALUES(4),
        MLT(5);

        private int tabIdx;

        private Tab(int tabIdx) {
            this.tabIdx = tabIdx;
        }

        int index() {
            return this.tabIdx;
        }
    }

    private class Observer
    implements IndexObserver {
        private Observer() {
        }

        @Override
        public void openIndex(LukeState state) {
            SearchPanelProvider.this.searchModel = SearchPanelProvider.this.searchFactory.newInstance(state.getIndexReader());
            SearchPanelProvider.this.toolsModel = SearchPanelProvider.this.toolsFactory.newInstance(state.getIndexReader(), state.useCompound(), state.keepAllCommits());
            SearchPanelProvider.this.operatorRegistry.get(QueryParserTabOperator.class).ifPresent(operator -> {
                operator.setSearchableFields(SearchPanelProvider.this.searchModel.getSearchableFieldNames());
                operator.setRangeSearchableFields(SearchPanelProvider.this.searchModel.getRangeSearchableFieldNames());
            });
            SearchPanelProvider.this.operatorRegistry.get(SortTabOperator.class).ifPresent(operator -> {
                operator.setSearchModel(SearchPanelProvider.this.searchModel);
                operator.setSortableFields(SearchPanelProvider.this.searchModel.getSortableFieldNames());
            });
            SearchPanelProvider.this.operatorRegistry.get(FieldValuesTabOperator.class).ifPresent(operator -> operator.setFields(SearchPanelProvider.this.searchModel.getFieldNames()));
            SearchPanelProvider.this.operatorRegistry.get(MLTTabOperator.class).ifPresent(operator -> operator.setFields(SearchPanelProvider.this.searchModel.getFieldNames()));
            SearchPanelProvider.this.queryStringTA.setText("*:*");
            SearchPanelProvider.this.parsedQueryTA.setText("");
            SearchPanelProvider.this.parseBtn.setEnabled(true);
            SearchPanelProvider.this.searchBtn.setEnabled(true);
            SearchPanelProvider.this.mltBtn.setEnabled(true);
        }

        @Override
        public void closeIndex() {
            SearchPanelProvider.this.searchModel = null;
            SearchPanelProvider.this.toolsModel = null;
            SearchPanelProvider.this.queryStringTA.setText("");
            SearchPanelProvider.this.parsedQueryTA.setText("");
            SearchPanelProvider.this.parseBtn.setEnabled(false);
            SearchPanelProvider.this.searchBtn.setEnabled(false);
            SearchPanelProvider.this.mltBtn.setEnabled(false);
            SearchPanelProvider.this.totalHitsLbl.setText("0");
            SearchPanelProvider.this.startLbl.setText("0");
            SearchPanelProvider.this.endLbl.setText("0");
            SearchPanelProvider.this.nextBtn.setEnabled(false);
            SearchPanelProvider.this.prevBtn.setEnabled(false);
            SearchPanelProvider.this.delBtn.setEnabled(false);
            TableUtils.setupTable(SearchPanelProvider.this.resultsTable, 0, new SearchResultsTableModel(), null, SearchResultsTableModel.Column.DOCID.getColumnWidth(), SearchResultsTableModel.Column.SCORE.getColumnWidth());
        }
    }

    private class ListenerFunctions {
        private ListenerFunctions() {
        }

        void toggleTermQuery(ActionEvent e) {
            SearchPanelProvider.this.toggleTermQuery();
        }

        void execParse(ActionEvent e) {
            SearchPanelProvider.this.execParse();
        }

        void execSearch(ActionEvent e) {
            SearchPanelProvider.this.doSearch();
        }

        void nextPage(ActionEvent e) {
            SearchPanelProvider.this.nextPage();
        }

        void prevPage(ActionEvent e) {
            SearchPanelProvider.this.prevPage();
        }

        void execMLTSearch(ActionEvent e) {
            SearchPanelProvider.this.doMLTSearch();
        }

        void confirmDeletion(ActionEvent e) {
            SearchPanelProvider.this.confirmDeletion();
        }

        void showContextMenuInResultsTable(MouseEvent e) {
            if (e.getClickCount() == 2 && !e.isConsumed()) {
                SearchPanelProvider.this.setupResultsContextMenuPopup().show(e.getComponent(), e.getX(), e.getY());
                SearchPanelProvider.this.setupResultsContextMenuPopup().show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }
}

