/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.luke.app.desktop;

import java.awt.GraphicsEnvironment;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.file.FileSystems;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.luke.app.desktop.MessageBroker;
import org.apache.lucene.luke.app.desktop.components.LukeWindowProvider;
import org.apache.lucene.luke.app.desktop.components.dialog.menubar.OpenIndexDialogFactory;
import org.apache.lucene.luke.app.desktop.util.DialogOpener;
import org.apache.lucene.luke.app.desktop.util.ExceptionHandler;
import org.apache.lucene.luke.app.desktop.util.FontUtils;
import org.apache.lucene.luke.app.desktop.util.MessageUtils;
import org.apache.lucene.luke.util.LoggerFactory;

public class LukeMain {
    public static final String LOG_FILE = System.getProperty("user.home") + FileSystems.getDefault().getSeparator() + ".luke.d" + FileSystems.getDefault().getSeparator() + "luke.log";
    private static final Logger log;
    private static JFrame frame;

    public static JFrame getOwnerFrame() {
        return frame;
    }

    private static void createAndShowGUI() {
        MessageBroker messageBroker = MessageBroker.getInstance();
        Thread.setDefaultUncaughtExceptionHandler((thread, cause) -> ExceptionHandler.handle(cause, messageBroker));
        try {
            frame = new LukeWindowProvider().get();
            frame.setLocation(200, 100);
            frame.setDefaultCloseOperation(3);
            frame.pack();
            frame.setVisible(true);
            OpenIndexDialogFactory openIndexDialogFactory = OpenIndexDialogFactory.getInstance();
            new DialogOpener<OpenIndexDialogFactory>(openIndexDialogFactory).open(MessageUtils.getLocalizedMessage("openindex.dialog.title"), 600, 420, factory -> {}, new String[0]);
        }
        catch (IOException e) {
            messageBroker.showUnknownErrorMessage();
            log.error("Cannot initialize components.", (Throwable)e);
        }
    }

    public static void main(String[] args) throws Exception {
        String lookAndFeelClassName = UIManager.getSystemLookAndFeelClassName();
        if (!lookAndFeelClassName.contains("AquaLookAndFeel") && !lookAndFeelClassName.contains("PlasticXPLookAndFeel")) {
            lookAndFeelClassName = "javax.swing.plaf.metal.MetalLookAndFeel";
        }
        UIManager.setLookAndFeel(lookAndFeelClassName);
        GraphicsEnvironment genv = GraphicsEnvironment.getLocalGraphicsEnvironment();
        genv.registerFont(FontUtils.createElegantIconFont());
        SwingUtilities.invokeLater(LukeMain::createAndShowGUI);
    }

    static {
        LoggerFactory.initGuiLogging(LOG_FILE);
        log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    }
}

