/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.luke.app.desktop.components.fragments.analysis;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.util.Collection;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.luke.app.desktop.components.AnalysisTabOperator;
import org.apache.lucene.luke.app.desktop.components.ComponentOperatorRegistry;
import org.apache.lucene.luke.app.desktop.components.fragments.analysis.PresetAnalyzerPanelOperator;
import org.apache.lucene.luke.app.desktop.util.MessageUtils;

public final class PresetAnalyzerPanelProvider
implements PresetAnalyzerPanelOperator {
    private final ComponentOperatorRegistry operatorRegistry;
    private final JComboBox<String> analyzersCB = new JComboBox();
    private final ListenerFunctions listeners = new ListenerFunctions();

    public PresetAnalyzerPanelProvider() {
        this.operatorRegistry = ComponentOperatorRegistry.getInstance();
        this.operatorRegistry.register(PresetAnalyzerPanelOperator.class, this);
    }

    public JPanel get() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setOpaque(false);
        panel.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        JLabel header = new JLabel(MessageUtils.getLocalizedMessage("analysis_preset.label.preset"));
        panel.add((Component)header, "First");
        JPanel center = new JPanel(new FlowLayout(3));
        center.setOpaque(false);
        center.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        center.setPreferredSize(new Dimension(400, 40));
        this.analyzersCB.addActionListener(this.listeners::setAnalyzer);
        this.analyzersCB.setEnabled(false);
        center.add(this.analyzersCB);
        panel.add((Component)center, "Center");
        return panel;
    }

    @Override
    public void setPresetAnalyzers(Collection<Class<? extends Analyzer>> presetAnalyzers) {
        String[] analyzerNames = (String[])presetAnalyzers.stream().map(Class::getName).toArray(String[]::new);
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>(analyzerNames);
        this.analyzersCB.setModel(model);
        this.analyzersCB.setEnabled(true);
    }

    @Override
    public void setSelectedAnalyzer(Class<? extends Analyzer> analyzer) {
        this.analyzersCB.setSelectedItem(analyzer.getName());
    }

    private class ListenerFunctions {
        private ListenerFunctions() {
        }

        void setAnalyzer(ActionEvent e) {
            PresetAnalyzerPanelProvider.this.operatorRegistry.get(AnalysisTabOperator.class).ifPresent(operator -> operator.setAnalyzerByType((String)PresetAnalyzerPanelProvider.this.analyzersCB.getSelectedItem()));
        }
    }
}

