/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.luke.models.analysis;

import java.io.IOException;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.custom.CustomAnalyzer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.util.CharFilterFactory;
import org.apache.lucene.analysis.util.TokenFilterFactory;
import org.apache.lucene.analysis.util.TokenizerFactory;
import org.apache.lucene.luke.models.LukeException;
import org.apache.lucene.luke.models.analysis.Analysis;
import org.apache.lucene.luke.models.analysis.CustomAnalyzerConfig;
import org.apache.lucene.luke.util.reflection.ClassScanner;
import org.apache.lucene.util.AttributeImpl;

public final class AnalysisImpl
implements Analysis {
    private List<Class<? extends Analyzer>> presetAnalyzerTypes;
    private Analyzer analyzer;

    @Override
    public void addExternalJars(List<String> jarFiles) {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (String jarFile : jarFiles) {
            Path path = FileSystems.getDefault().getPath(jarFile, new String[0]);
            if (!Files.exists(path, new LinkOption[0]) || !jarFile.endsWith(".jar")) {
                throw new LukeException(String.format(Locale.ENGLISH, "Invalid jar file path: %s", jarFile));
            }
            try {
                URL url = path.toUri().toURL();
                urls.add(url);
            }
            catch (IOException e) {
                throw new LukeException(e.getMessage(), e);
            }
        }
        URLClassLoader classLoader = new URLClassLoader(urls.toArray(new URL[0]), this.getClass().getClassLoader());
        CharFilterFactory.reloadCharFilters((ClassLoader)classLoader);
        TokenizerFactory.reloadTokenizers((ClassLoader)classLoader);
        TokenFilterFactory.reloadTokenFilters((ClassLoader)classLoader);
    }

    @Override
    public Collection<Class<? extends Analyzer>> getPresetAnalyzerTypes() {
        if (Objects.isNull(this.presetAnalyzerTypes)) {
            ArrayList<Class<Analyzer>> types = new ArrayList<Class<Analyzer>>();
            for (Class<Analyzer> clazz : this.getInstantiableSubTypesBuiltIn(Analyzer.class)) {
                try {
                    clazz.getConstructor(new Class[0]);
                    types.add(clazz);
                }
                catch (NoSuchMethodException noSuchMethodException) {}
            }
            this.presetAnalyzerTypes = Collections.unmodifiableList(types);
        }
        return this.presetAnalyzerTypes;
    }

    @Override
    public Collection<String> getAvailableCharFilters() {
        return CharFilterFactory.availableCharFilters().stream().sorted().collect(Collectors.toList());
    }

    @Override
    public Collection<String> getAvailableTokenizers() {
        return TokenizerFactory.availableTokenizers().stream().sorted().collect(Collectors.toList());
    }

    @Override
    public Collection<String> getAvailableTokenFilters() {
        return TokenFilterFactory.availableTokenFilters().stream().sorted().collect(Collectors.toList());
    }

    private <T> List<Class<? extends T>> getInstantiableSubTypesBuiltIn(Class<T> superType) {
        ClassScanner scanner = new ClassScanner("org.apache.lucene.analysis", this.getClass().getClassLoader());
        Set<Class<T>> types = scanner.scanSubTypes(superType);
        return types.stream().filter(type -> !Modifier.isAbstract(type.getModifiers())).filter(type -> !type.getSimpleName().startsWith("Mock")).sorted(Comparator.comparing(Class::getName)).collect(Collectors.toList());
    }

    @Override
    public List<Analysis.Token> analyze(String text) {
        Objects.requireNonNull(text);
        if (this.analyzer == null) {
            throw new LukeException("Analyzer is not set.");
        }
        try {
            ArrayList<Analysis.Token> result = new ArrayList<Analysis.Token>();
            TokenStream stream = this.analyzer.tokenStream("", text);
            stream.reset();
            CharTermAttribute charAtt = (CharTermAttribute)stream.getAttribute(CharTermAttribute.class);
            while (stream.incrementToken()) {
                ArrayList<Analysis.TokenAttribute> attributes = new ArrayList<Analysis.TokenAttribute>();
                Iterator itr = stream.getAttributeImplsIterator();
                while (itr.hasNext()) {
                    AttributeImpl att = (AttributeImpl)itr.next();
                    LinkedHashMap<String, String> attValues = new LinkedHashMap<String, String>();
                    att.reflectWith((attClass, key, value) -> {
                        if (value != null) {
                            attValues.put(key, value.toString());
                        }
                    });
                    attributes.add(new Analysis.TokenAttribute(att.getClass().getSimpleName(), attValues));
                }
                result.add(new Analysis.Token(charAtt.toString(), attributes));
            }
            stream.close();
            return result;
        }
        catch (IOException e) {
            throw new LukeException(e.getMessage(), e);
        }
    }

    @Override
    public Analyzer createAnalyzerFromClassName(String analyzerType) {
        Objects.requireNonNull(analyzerType);
        try {
            Class<Analyzer> clazz = Class.forName(analyzerType).asSubclass(Analyzer.class);
            this.analyzer = clazz.newInstance();
            return this.analyzer;
        }
        catch (ReflectiveOperationException e) {
            throw new LukeException(String.format(Locale.ENGLISH, "Failed to instantiate class: %s", analyzerType), e);
        }
    }

    @Override
    public Analyzer buildCustomAnalyzer(CustomAnalyzerConfig config) {
        Objects.requireNonNull(config);
        try {
            CustomAnalyzer.Builder builder = config.getConfigDir().map(path -> CustomAnalyzer.builder((Path)FileSystems.getDefault().getPath((String)path, new String[0]))).orElse(CustomAnalyzer.builder());
            builder.withTokenizer(config.getTokenizerConfig().getName(), config.getTokenizerConfig().getParams());
            for (CustomAnalyzerConfig.ComponentConfig cfConf : config.getCharFilterConfigs()) {
                builder.addCharFilter(cfConf.getName(), cfConf.getParams());
            }
            for (CustomAnalyzerConfig.ComponentConfig tfConf : config.getTokenFilterConfigs()) {
                builder.addTokenFilter(tfConf.getName(), tfConf.getParams());
            }
            this.analyzer = builder.build();
            return this.analyzer;
        }
        catch (Exception e) {
            throw new LukeException("Failed to build custom analyzer.", e);
        }
    }

    @Override
    public Analyzer currentAnalyzer() {
        if (this.analyzer == null) {
            throw new LukeException("Analyzer is not set.");
        }
        return this.analyzer;
    }
}

