/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.luke.models.analysis;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.luke.models.analysis.CustomAnalyzerConfig;

public interface Analysis {
    public Collection<Class<? extends Analyzer>> getPresetAnalyzerTypes();

    public Collection<String> getAvailableCharFilters();

    public Collection<String> getAvailableTokenizers();

    public Collection<String> getAvailableTokenFilters();

    public Analyzer createAnalyzerFromClassName(String var1);

    public Analyzer buildCustomAnalyzer(CustomAnalyzerConfig var1);

    public List<Token> analyze(String var1);

    public Analyzer currentAnalyzer();

    public void addExternalJars(List<String> var1);

    public static class TokenAttribute {
        private final String attClass;
        private final Map<String, String> attValues;

        TokenAttribute(String attClass, Map<String, String> attValues) {
            this.attClass = Objects.requireNonNull(attClass);
            this.attValues = Objects.requireNonNull(attValues);
        }

        public String getAttClass() {
            return this.attClass;
        }

        public Map<String, String> getAttValues() {
            return Collections.unmodifiableMap(this.attValues);
        }
    }

    public static class Token {
        private final String term;
        private final List<TokenAttribute> attributes;

        Token(String term, List<TokenAttribute> attributes) {
            this.term = Objects.requireNonNull(term);
            this.attributes = Objects.requireNonNull(attributes);
        }

        public String getTerm() {
            return this.term;
        }

        public List<TokenAttribute> getAttributes() {
            return Collections.unmodifiableList(this.attributes);
        }
    }
}

