/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.luke.app.desktop.components.dialog.documents;

import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.Window;
import java.io.IOException;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.luke.app.desktop.Preferences;
import org.apache.lucene.luke.app.desktop.PreferencesFactory;
import org.apache.lucene.luke.app.desktop.dto.documents.NewField;
import org.apache.lucene.luke.app.desktop.util.DialogOpener;
import org.apache.lucene.luke.app.desktop.util.MessageUtils;

public final class IndexOptionsDialogFactory
implements DialogOpener.DialogFactory {
    private static IndexOptionsDialogFactory instance;
    private final Preferences prefs;
    private final JCheckBox storedCB = new JCheckBox();
    private final JCheckBox tokenizedCB = new JCheckBox();
    private final JCheckBox omitNormsCB = new JCheckBox();
    private final JComboBox<String> idxOptCombo = new JComboBox<String>(IndexOptionsDialogFactory.availableIndexOptions());
    private final JCheckBox storeTVCB = new JCheckBox();
    private final JCheckBox storeTVPosCB = new JCheckBox();
    private final JCheckBox storeTVOffCB = new JCheckBox();
    private final JCheckBox storeTVPayCB = new JCheckBox();
    private final JComboBox<String> dvTypeCombo = new JComboBox<String>(IndexOptionsDialogFactory.availableDocValuesType());
    private final JTextField dimCountTF = new JTextField();
    private final JTextField dimNumBytesTF = new JTextField();
    private JDialog dialog;
    private NewField nf;

    public static synchronized IndexOptionsDialogFactory getInstance() throws IOException {
        if (instance == null) {
            instance = new IndexOptionsDialogFactory();
        }
        return instance;
    }

    private IndexOptionsDialogFactory() throws IOException {
        this.prefs = PreferencesFactory.getInstance();
        this.initialize();
    }

    private void initialize() {
        this.storedCB.setText(MessageUtils.getLocalizedMessage("idx_options.checkbox.stored"));
        this.storedCB.setOpaque(false);
        this.tokenizedCB.setText(MessageUtils.getLocalizedMessage("idx_options.checkbox.tokenized"));
        this.tokenizedCB.setOpaque(false);
        this.omitNormsCB.setText(MessageUtils.getLocalizedMessage("idx_options.checkbox.omit_norm"));
        this.omitNormsCB.setOpaque(false);
        this.idxOptCombo.setPreferredSize(new Dimension(300, this.idxOptCombo.getPreferredSize().height));
        this.storeTVCB.setText(MessageUtils.getLocalizedMessage("idx_options.checkbox.store_tv"));
        this.storeTVCB.setOpaque(false);
        this.storeTVPosCB.setText(MessageUtils.getLocalizedMessage("idx_options.checkbox.store_tv_pos"));
        this.storeTVPosCB.setOpaque(false);
        this.storeTVOffCB.setText(MessageUtils.getLocalizedMessage("idx_options.checkbox.store_tv_off"));
        this.storeTVOffCB.setOpaque(false);
        this.storeTVPayCB.setText(MessageUtils.getLocalizedMessage("idx_options.checkbox.store_tv_pay"));
        this.storeTVPayCB.setOpaque(false);
        this.dimCountTF.setColumns(4);
        this.dimNumBytesTF.setColumns(4);
    }

    @Override
    public JDialog create(Window owner, String title, int width, int height) {
        this.dialog = new JDialog(owner, title, Dialog.ModalityType.APPLICATION_MODAL);
        this.dialog.add(this.content());
        this.dialog.setSize(new Dimension(width, height));
        this.dialog.setLocationRelativeTo(owner);
        this.dialog.getContentPane().setBackground(this.prefs.getColorTheme().getBackgroundColor());
        return this.dialog;
    }

    private JPanel content() {
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        panel.setLayout(new BoxLayout(panel, 3));
        panel.setBorder(BorderFactory.createEmptyBorder(15, 15, 15, 15));
        panel.add(this.indexOptions());
        panel.add(new JSeparator(0));
        panel.add(this.tvOptions());
        panel.add(new JSeparator(0));
        panel.add(this.dvOptions());
        panel.add(new JSeparator(0));
        panel.add(this.pvOptions());
        panel.add(new JSeparator(0));
        panel.add(this.footer());
        return panel;
    }

    private JPanel indexOptions() {
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        panel.setLayout(new BoxLayout(panel, 3));
        JPanel inner1 = new JPanel(new FlowLayout(3, 10, 5));
        inner1.setOpaque(false);
        inner1.add(this.storedCB);
        inner1.add(this.tokenizedCB);
        inner1.add(this.omitNormsCB);
        panel.add(inner1);
        JPanel inner2 = new JPanel(new FlowLayout(3, 10, 1));
        inner2.setOpaque(false);
        JLabel idxOptLbl = new JLabel(MessageUtils.getLocalizedMessage("idx_options.label.index_options"));
        inner2.add(idxOptLbl);
        inner2.add(this.idxOptCombo);
        panel.add(inner2);
        return panel;
    }

    private JPanel tvOptions() {
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        panel.setLayout(new BoxLayout(panel, 3));
        JPanel inner1 = new JPanel(new FlowLayout(3, 10, 2));
        inner1.setOpaque(false);
        inner1.add(this.storeTVCB);
        panel.add(inner1);
        JPanel inner2 = new JPanel(new FlowLayout(3, 10, 2));
        inner2.setOpaque(false);
        inner2.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
        inner2.add(this.storeTVPosCB);
        inner2.add(this.storeTVOffCB);
        inner2.add(this.storeTVPayCB);
        panel.add(inner2);
        return panel;
    }

    private JPanel dvOptions() {
        JPanel panel = new JPanel(new FlowLayout(3, 10, 2));
        panel.setOpaque(false);
        JLabel dvTypeLbl = new JLabel(MessageUtils.getLocalizedMessage("idx_options.label.dv_type"));
        panel.add(dvTypeLbl);
        panel.add(this.dvTypeCombo);
        return panel;
    }

    private JPanel pvOptions() {
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        panel.setLayout(new BoxLayout(panel, 3));
        JPanel inner1 = new JPanel(new FlowLayout(3, 10, 2));
        inner1.setOpaque(false);
        inner1.add(new JLabel(MessageUtils.getLocalizedMessage("idx_options.label.point_dims")));
        panel.add(inner1);
        JPanel inner2 = new JPanel(new FlowLayout(3, 10, 2));
        inner2.setOpaque(false);
        inner2.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
        inner2.add(new JLabel(MessageUtils.getLocalizedMessage("idx_options.label.point_dc")));
        inner2.add(this.dimCountTF);
        inner2.add(new JLabel(MessageUtils.getLocalizedMessage("idx_options.label.point_nb")));
        inner2.add(this.dimNumBytesTF);
        panel.add(inner2);
        return panel;
    }

    private JPanel footer() {
        JPanel panel = new JPanel(new FlowLayout(4));
        panel.setOpaque(false);
        JButton okBtn = new JButton(MessageUtils.getLocalizedMessage("button.ok"));
        okBtn.setMargin(new Insets(3, 3, 3, 3));
        okBtn.addActionListener(e -> this.saveOptions());
        panel.add(okBtn);
        JButton cancelBtn = new JButton(MessageUtils.getLocalizedMessage("button.cancel"));
        cancelBtn.setMargin(new Insets(3, 3, 3, 3));
        cancelBtn.addActionListener(e -> this.dialog.dispose());
        panel.add(cancelBtn);
        return panel;
    }

    public void setNewField(NewField nf) {
        this.nf = nf;
        this.storedCB.setSelected(nf.isStored());
        IndexableFieldType fieldType = nf.getFieldType();
        this.tokenizedCB.setSelected(fieldType.tokenized());
        this.omitNormsCB.setSelected(fieldType.omitNorms());
        this.idxOptCombo.setSelectedItem(fieldType.indexOptions().name());
        this.storeTVCB.setSelected(fieldType.storeTermVectors());
        this.storeTVPosCB.setSelected(fieldType.storeTermVectorPositions());
        this.storeTVOffCB.setSelected(fieldType.storeTermVectorOffsets());
        this.storeTVPayCB.setSelected(fieldType.storeTermVectorPayloads());
        this.dvTypeCombo.setSelectedItem(fieldType.docValuesType().name());
        this.dimCountTF.setText(String.valueOf(fieldType.pointDataDimensionCount()));
        this.dimNumBytesTF.setText(String.valueOf(fieldType.pointNumBytes()));
        if (nf.getType().equals(TextField.class) || nf.getType().equals(StringField.class) || nf.getType().equals(Field.class)) {
            this.storedCB.setEnabled(true);
        } else {
            this.storedCB.setEnabled(false);
        }
        if (nf.getType().equals(Field.class)) {
            this.tokenizedCB.setEnabled(true);
            this.omitNormsCB.setEnabled(true);
            this.idxOptCombo.setEnabled(true);
            this.storeTVCB.setEnabled(true);
            this.storeTVPosCB.setEnabled(true);
            this.storeTVOffCB.setEnabled(true);
            this.storeTVPosCB.setEnabled(true);
        } else {
            this.tokenizedCB.setEnabled(false);
            this.omitNormsCB.setEnabled(false);
            this.idxOptCombo.setEnabled(false);
            this.storeTVCB.setEnabled(false);
            this.storeTVPosCB.setEnabled(false);
            this.storeTVOffCB.setEnabled(false);
            this.storeTVPayCB.setEnabled(false);
        }
        this.dvTypeCombo.setEnabled(false);
        this.dimCountTF.setEnabled(false);
        this.dimNumBytesTF.setEnabled(false);
    }

    private void saveOptions() {
        this.nf.setStored(this.storedCB.isSelected());
        if (this.nf.getType().equals(Field.class)) {
            FieldType ftype = (FieldType)this.nf.getFieldType();
            ftype.setStored(this.storedCB.isSelected());
            ftype.setTokenized(this.tokenizedCB.isSelected());
            ftype.setOmitNorms(this.omitNormsCB.isSelected());
            ftype.setIndexOptions(IndexOptions.valueOf((String)((String)this.idxOptCombo.getSelectedItem())));
            ftype.setStoreTermVectors(this.storeTVCB.isSelected());
            ftype.setStoreTermVectorPositions(this.storeTVPosCB.isSelected());
            ftype.setStoreTermVectorOffsets(this.storeTVOffCB.isSelected());
            ftype.setStoreTermVectorPayloads(this.storeTVPayCB.isSelected());
        }
        this.dialog.dispose();
    }

    private static String[] availableIndexOptions() {
        return (String[])Arrays.stream(IndexOptions.values()).map(Enum::name).toArray(String[]::new);
    }

    private static String[] availableDocValuesType() {
        return (String[])Arrays.stream(DocValuesType.values()).map(Enum::name).toArray(String[]::new);
    }
}

