/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.luke.app.desktop.components;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.custom.CustomAnalyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.luke.app.desktop.MessageBroker;
import org.apache.lucene.luke.app.desktop.components.AnalysisTabOperator;
import org.apache.lucene.luke.app.desktop.components.ComponentOperatorRegistry;
import org.apache.lucene.luke.app.desktop.components.TableColumnInfo;
import org.apache.lucene.luke.app.desktop.components.TableModelBase;
import org.apache.lucene.luke.app.desktop.components.dialog.analysis.AnalysisChainDialogFactory;
import org.apache.lucene.luke.app.desktop.components.dialog.analysis.TokenAttributeDialogFactory;
import org.apache.lucene.luke.app.desktop.components.dialog.documents.AddDocumentDialogOperator;
import org.apache.lucene.luke.app.desktop.components.fragments.analysis.CustomAnalyzerPanelOperator;
import org.apache.lucene.luke.app.desktop.components.fragments.analysis.CustomAnalyzerPanelProvider;
import org.apache.lucene.luke.app.desktop.components.fragments.analysis.PresetAnalyzerPanelOperator;
import org.apache.lucene.luke.app.desktop.components.fragments.analysis.PresetAnalyzerPanelProvider;
import org.apache.lucene.luke.app.desktop.components.fragments.search.AnalyzerTabOperator;
import org.apache.lucene.luke.app.desktop.components.fragments.search.MLTTabOperator;
import org.apache.lucene.luke.app.desktop.util.DialogOpener;
import org.apache.lucene.luke.app.desktop.util.FontUtils;
import org.apache.lucene.luke.app.desktop.util.MessageUtils;
import org.apache.lucene.luke.app.desktop.util.StyleConstants;
import org.apache.lucene.luke.app.desktop.util.TableUtils;
import org.apache.lucene.luke.models.analysis.Analysis;
import org.apache.lucene.luke.models.analysis.AnalysisFactory;
import org.apache.lucene.luke.models.analysis.CustomAnalyzerConfig;
import org.apache.lucene.util.NamedThreadFactory;

public final class AnalysisPanelProvider
implements AnalysisTabOperator {
    private static final String TYPE_PRESET = "preset";
    private static final String TYPE_CUSTOM = "custom";
    private final ComponentOperatorRegistry operatorRegistry;
    private final AnalysisChainDialogFactory analysisChainDialogFactory;
    private final TokenAttributeDialogFactory tokenAttrDialogFactory;
    private final MessageBroker messageBroker;
    private final JPanel mainPanel = new JPanel();
    private final JPanel preset;
    private final JPanel custom;
    private final JRadioButton presetRB = new JRadioButton();
    private final JRadioButton customRB = new JRadioButton();
    private final JLabel analyzerNameLbl = new JLabel();
    private final JLabel showChainLbl = new JLabel();
    private final JTextArea inputArea = new JTextArea();
    private final JTable tokensTable = new JTable();
    private final ListenerFunctions listeners = new ListenerFunctions();
    private List<Analysis.Token> tokens;
    private Analysis analysisModel;

    public AnalysisPanelProvider() throws IOException {
        this.preset = new PresetAnalyzerPanelProvider().get();
        this.custom = new CustomAnalyzerPanelProvider().get();
        this.operatorRegistry = ComponentOperatorRegistry.getInstance();
        this.analysisChainDialogFactory = AnalysisChainDialogFactory.getInstance();
        this.tokenAttrDialogFactory = TokenAttributeDialogFactory.getInstance();
        this.messageBroker = MessageBroker.getInstance();
        this.analysisModel = new AnalysisFactory().newInstance();
        this.analysisModel.createAnalyzerFromClassName(StandardAnalyzer.class.getName());
        this.operatorRegistry.register(AnalysisTabOperator.class, this);
        this.operatorRegistry.get(PresetAnalyzerPanelOperator.class).ifPresent(operator -> {
            ExecutorService executorService = Executors.newFixedThreadPool(1, (ThreadFactory)new NamedThreadFactory("load-preset-analyzer-types"));
            executorService.execute(() -> {
                operator.setPresetAnalyzers(this.analysisModel.getPresetAnalyzerTypes());
                operator.setSelectedAnalyzer(this.analysisModel.currentAnalyzer().getClass());
            });
            executorService.shutdown();
        });
    }

    public JPanel get() {
        JPanel panel = new JPanel(new GridLayout(1, 1));
        panel.setOpaque(false);
        panel.setBorder(BorderFactory.createLineBorder(Color.gray));
        JSplitPane splitPane = new JSplitPane(0, this.initUpperPanel(), this.initLowerPanel());
        splitPane.setOpaque(false);
        splitPane.setDividerLocation(320);
        panel.add(splitPane);
        return panel;
    }

    private JPanel initUpperPanel() {
        this.mainPanel.setOpaque(false);
        this.mainPanel.setLayout(new BorderLayout());
        this.mainPanel.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.mainPanel.add((Component)this.initSwitcherPanel(), "First");
        this.mainPanel.add((Component)this.preset, "Center");
        return this.mainPanel;
    }

    private JPanel initSwitcherPanel() {
        JPanel panel = new JPanel(new FlowLayout(3));
        panel.setOpaque(false);
        this.presetRB.setText(MessageUtils.getLocalizedMessage("analysis.radio.preset"));
        this.presetRB.setActionCommand(TYPE_PRESET);
        this.presetRB.addActionListener(this.listeners::toggleMainPanel);
        this.presetRB.setOpaque(false);
        this.presetRB.setSelected(true);
        this.customRB.setText(MessageUtils.getLocalizedMessage("analysis.radio.custom"));
        this.customRB.setActionCommand(TYPE_CUSTOM);
        this.customRB.addActionListener(this.listeners::toggleMainPanel);
        this.customRB.setOpaque(false);
        this.customRB.setSelected(false);
        ButtonGroup group = new ButtonGroup();
        group.add(this.presetRB);
        group.add(this.customRB);
        panel.add(this.presetRB);
        panel.add(this.customRB);
        return panel;
    }

    private JPanel initLowerPanel() {
        JPanel inner1 = new JPanel(new BorderLayout());
        inner1.setOpaque(false);
        JPanel analyzerName = new JPanel(new FlowLayout(3, 10, 2));
        analyzerName.setOpaque(false);
        analyzerName.add(new JLabel(MessageUtils.getLocalizedMessage("analysis.label.selected_analyzer")));
        this.analyzerNameLbl.setText(this.analysisModel.currentAnalyzer().getClass().getName());
        analyzerName.add(this.analyzerNameLbl);
        this.showChainLbl.setText(MessageUtils.getLocalizedMessage("analysis.label.show_chain"));
        this.showChainLbl.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                AnalysisPanelProvider.this.listeners.showAnalysisChain(e);
            }
        });
        this.showChainLbl.setVisible(this.analysisModel.currentAnalyzer() instanceof CustomAnalyzer);
        analyzerName.add(FontUtils.toLinkText(this.showChainLbl));
        inner1.add((Component)analyzerName, "First");
        JPanel input = new JPanel(new FlowLayout(3, 5, 2));
        input.setOpaque(false);
        this.inputArea.setRows(3);
        this.inputArea.setColumns(50);
        this.inputArea.setLineWrap(true);
        this.inputArea.setWrapStyleWord(true);
        this.inputArea.setText(MessageUtils.getLocalizedMessage("analysis.textarea.prompt"));
        input.add(new JScrollPane(this.inputArea));
        JButton executeBtn = new JButton(FontUtils.elegantIconHtml("&#xe007;", MessageUtils.getLocalizedMessage("analysis.button.test")));
        executeBtn.setFont(StyleConstants.FONT_BUTTON_LARGE);
        executeBtn.setMargin(new Insets(3, 3, 3, 3));
        executeBtn.addActionListener(this.listeners::executeAnalysis);
        input.add(executeBtn);
        JButton clearBtn = new JButton(MessageUtils.getLocalizedMessage("button.clear"));
        clearBtn.setFont(StyleConstants.FONT_BUTTON_LARGE);
        clearBtn.setMargin(new Insets(5, 5, 5, 5));
        clearBtn.addActionListener(e -> {
            this.inputArea.setText("");
            TableUtils.setupTable(this.tokensTable, 0, new TokensTableModel(), null, TokensTableModel.Column.TERM.getColumnWidth(), TokensTableModel.Column.ATTR.getColumnWidth());
        });
        input.add(clearBtn);
        inner1.add((Component)input, "Center");
        JPanel inner2 = new JPanel(new BorderLayout());
        inner2.setOpaque(false);
        JPanel hint = new JPanel(new FlowLayout(3));
        hint.setOpaque(false);
        hint.add(new JLabel(MessageUtils.getLocalizedMessage("analysis.hint.show_attributes")));
        inner2.add((Component)hint, "First");
        TableUtils.setupTable(this.tokensTable, 0, new TokensTableModel(), new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                AnalysisPanelProvider.this.listeners.showAttributeValues(e);
            }
        }, TokensTableModel.Column.TERM.getColumnWidth(), TokensTableModel.Column.ATTR.getColumnWidth());
        inner2.add((Component)new JScrollPane(this.tokensTable), "Center");
        JPanel panel = new JPanel(new BorderLayout());
        panel.setOpaque(false);
        panel.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        panel.add((Component)inner1, "First");
        panel.add((Component)inner2, "Center");
        return panel;
    }

    void toggleMainPanel(String command) {
        if (command.equalsIgnoreCase(TYPE_PRESET)) {
            this.mainPanel.remove(this.custom);
            this.mainPanel.add((Component)this.preset, "Center");
            this.operatorRegistry.get(PresetAnalyzerPanelOperator.class).ifPresent(operator -> {
                operator.setPresetAnalyzers(this.analysisModel.getPresetAnalyzerTypes());
                operator.setSelectedAnalyzer(this.analysisModel.currentAnalyzer().getClass());
            });
        } else if (command.equalsIgnoreCase(TYPE_CUSTOM)) {
            this.mainPanel.remove(this.preset);
            this.mainPanel.add((Component)this.custom, "Center");
            this.operatorRegistry.get(CustomAnalyzerPanelOperator.class).ifPresent(operator -> {
                operator.setAnalysisModel(this.analysisModel);
                operator.resetAnalysisComponents();
            });
        }
        this.mainPanel.setVisible(false);
        this.mainPanel.setVisible(true);
    }

    void executeAnalysis() {
        String text = this.inputArea.getText();
        if (Objects.isNull(text) || text.isEmpty()) {
            this.messageBroker.showStatusMessage(MessageUtils.getLocalizedMessage("analysis.message.empry_input"));
        }
        this.tokens = this.analysisModel.analyze(text);
        this.tokensTable.setModel(new TokensTableModel(this.tokens));
        this.tokensTable.setShowGrid(true);
        this.tokensTable.getColumnModel().getColumn(TokensTableModel.Column.TERM.getIndex()).setPreferredWidth(TokensTableModel.Column.TERM.getColumnWidth());
        this.tokensTable.getColumnModel().getColumn(TokensTableModel.Column.ATTR.getIndex()).setPreferredWidth(TokensTableModel.Column.ATTR.getColumnWidth());
    }

    void showAnalysisChainDialog() {
        if (this.getCurrentAnalyzer() instanceof CustomAnalyzer) {
            CustomAnalyzer analyzer = (CustomAnalyzer)this.getCurrentAnalyzer();
            new DialogOpener<AnalysisChainDialogFactory>(this.analysisChainDialogFactory).open("Analysis chain", 600, 320, factory -> factory.setAnalyzer(analyzer), new String[0]);
        }
    }

    void showAttributeValues(int selectedIndex) {
        String term = this.tokens.get(selectedIndex).getTerm();
        List<Analysis.TokenAttribute> attributes = this.tokens.get(selectedIndex).getAttributes();
        new DialogOpener<TokenAttributeDialogFactory>(this.tokenAttrDialogFactory).open("Token Attributes", 650, 400, factory -> {
            factory.setTerm(term);
            factory.setAttributes(attributes);
        }, new String[0]);
    }

    @Override
    public void setAnalyzerByType(String analyzerType) {
        this.analysisModel.createAnalyzerFromClassName(analyzerType);
        this.analyzerNameLbl.setText(this.analysisModel.currentAnalyzer().getClass().getName());
        this.showChainLbl.setVisible(false);
        this.operatorRegistry.get(AnalyzerTabOperator.class).ifPresent(operator -> operator.setAnalyzer(this.analysisModel.currentAnalyzer()));
        this.operatorRegistry.get(MLTTabOperator.class).ifPresent(operator -> operator.setAnalyzer(this.analysisModel.currentAnalyzer()));
        this.operatorRegistry.get(AddDocumentDialogOperator.class).ifPresent(operator -> operator.setAnalyzer(this.analysisModel.currentAnalyzer()));
    }

    @Override
    public void setAnalyzerByCustomConfiguration(CustomAnalyzerConfig config) {
        this.analysisModel.buildCustomAnalyzer(config);
        this.analyzerNameLbl.setText(this.analysisModel.currentAnalyzer().getClass().getName());
        this.showChainLbl.setVisible(true);
        this.operatorRegistry.get(AnalyzerTabOperator.class).ifPresent(operator -> operator.setAnalyzer(this.analysisModel.currentAnalyzer()));
        this.operatorRegistry.get(MLTTabOperator.class).ifPresent(operator -> operator.setAnalyzer(this.analysisModel.currentAnalyzer()));
        this.operatorRegistry.get(AddDocumentDialogOperator.class).ifPresent(operator -> operator.setAnalyzer(this.analysisModel.currentAnalyzer()));
    }

    @Override
    public Analyzer getCurrentAnalyzer() {
        return this.analysisModel.currentAnalyzer();
    }

    static final class TokensTableModel
    extends TableModelBase<Column> {
        TokensTableModel() {
        }

        TokensTableModel(List<Analysis.Token> tokens) {
            super(tokens.size());
            for (int i = 0; i < tokens.size(); ++i) {
                Analysis.Token token = tokens.get(i);
                this.data[i][Column.TERM.getIndex()] = token.getTerm();
                List attValues = token.getAttributes().stream().flatMap(att -> att.getAttValues().entrySet().stream().map(e -> (String)e.getKey() + "=" + (String)e.getValue())).collect(Collectors.toList());
                this.data[i][Column.ATTR.getIndex()] = String.join((CharSequence)",", attValues);
            }
        }

        protected Column[] columnInfos() {
            return Column.values();
        }

        static enum Column implements TableColumnInfo
        {
            TERM("Term", 0, String.class, 150),
            ATTR("Attributes", 1, String.class, 1000);

            private final String colName;
            private final int index;
            private final Class<?> type;
            private final int width;

            private Column(String colName, int index, Class<?> type, int width) {
                this.colName = colName;
                this.index = index;
                this.type = type;
                this.width = width;
            }

            @Override
            public String getColName() {
                return this.colName;
            }

            @Override
            public int getIndex() {
                return this.index;
            }

            @Override
            public Class<?> getType() {
                return this.type;
            }

            @Override
            public int getColumnWidth() {
                return this.width;
            }
        }
    }

    private class ListenerFunctions {
        private ListenerFunctions() {
        }

        void toggleMainPanel(ActionEvent e) {
            AnalysisPanelProvider.this.toggleMainPanel(e.getActionCommand());
        }

        void showAnalysisChain(MouseEvent e) {
            AnalysisPanelProvider.this.showAnalysisChainDialog();
        }

        void executeAnalysis(ActionEvent e) {
            AnalysisPanelProvider.this.executeAnalysis();
        }

        void showAttributeValues(MouseEvent e) {
            if (e.getClickCount() != 2 || e.isConsumed()) {
                return;
            }
            int selectedIndex = AnalysisPanelProvider.this.tokensTable.rowAtPoint(e.getPoint());
            if (selectedIndex < 0 || selectedIndex >= AnalysisPanelProvider.this.tokensTable.getRowCount()) {
                return;
            }
            AnalysisPanelProvider.this.showAttributeValues(selectedIndex);
        }
    }
}

