/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.spatial4j.util;

import java.lang.reflect.Array;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.Iterator;
import java.util.Locale;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.PrecisionModel;

public class GeomBuilder {
    GeometryFactory factory;
    Deque<Coordinate> cstack = new ArrayDeque<Coordinate>();
    Deque<Geometry> gstack = new ArrayDeque<Geometry>();

    public GeomBuilder() {
        this(new GeometryFactory());
    }

    public GeomBuilder(GeometryFactory factory) {
        this.factory = factory;
    }

    public GeomBuilder(int srid) {
        this.factory = new GeometryFactory(new PrecisionModel(), srid);
    }

    public GeomBuilder point(double x, double y) {
        this.cstack.push(new Coordinate(x, y));
        return this;
    }

    public GeomBuilder pointz(double x, double y, double z) {
        this.cstack.push(new Coordinate(x, y, z));
        return this;
    }

    public GeomBuilder points(double ... ord) {
        if (ord.length % 2 != 0) {
            throw new IllegalArgumentException("Must specify even number of ordinates");
        }
        for (int i = 0; i < ord.length; i += 2) {
            this.point(ord[i], ord[i + 1]);
        }
        return this;
    }

    public GeomBuilder pointsz(double ... ord) {
        if (ord.length % 3 != 0) {
            throw new IllegalArgumentException("Must specify ordinates as triples");
        }
        for (int i = 0; i < ord.length; i += 3) {
            this.pointz(ord[i], ord[i + 1], ord[i + 2]);
        }
        return this;
    }

    public GeomBuilder point() {
        this.gstack.push((Geometry)this.factory.createPoint(this.cpop()));
        return this;
    }

    public GeomBuilder lineString() {
        this.gstack.push((Geometry)this.factory.createLineString(this.cpopAll()));
        return this;
    }

    public GeomBuilder ring() {
        Coordinate[] coords = this.cpopAll();
        if (coords.length > 1 && !coords[0].equals((Object)coords[coords.length - 1])) {
            Coordinate[] tmp = new Coordinate[coords.length + 1];
            System.arraycopy(coords, 0, tmp, 0, coords.length);
            tmp[tmp.length - 1] = new Coordinate(tmp[0]);
            coords = tmp;
        }
        this.gstack.push((Geometry)this.factory.createLinearRing(coords));
        return this;
    }

    public GeomBuilder polygon() {
        if (this.gstack.isEmpty() || !(this.gstack.peek() instanceof LinearRing)) {
            this.ring();
        }
        LinearRing[] rings = (LinearRing[])this.gpopAll(LinearRing.class);
        LinearRing outer = rings[0];
        LinearRing[] inner = null;
        if (rings.length > 1) {
            inner = Arrays.copyOfRange(rings, 1, rings.length);
        }
        this.gstack.push((Geometry)this.factory.createPolygon(outer, inner));
        return this;
    }

    public GeomBuilder multiPoint() {
        if (!this.cstack.isEmpty()) {
            this.gstack.push((Geometry)this.factory.createMultiPoint(this.cpopAll()));
        } else {
            this.gstack.push((Geometry)this.factory.createMultiPoint((Point[])this.gpopAll(Point.class)));
        }
        return this;
    }

    public GeomBuilder multiLineString() {
        this.gstack.push((Geometry)this.factory.createMultiLineString((LineString[])this.gpopAll(LineString.class)));
        return this;
    }

    public GeomBuilder multiPolygon() {
        this.gstack.push((Geometry)this.factory.createMultiPolygon((Polygon[])this.gpopAll(Polygon.class)));
        return this;
    }

    public GeomBuilder collection() {
        this.gstack.push((Geometry)this.factory.createGeometryCollection(this.gpopAll(Geometry.class)));
        return this;
    }

    public GeomBuilder buffer(double amt) {
        this.gstack.push(this.gpop(Geometry.class).buffer(amt));
        return this;
    }

    public Geometry get() {
        return this.gpop(Geometry.class);
    }

    public Point toPoint() {
        return this.point().gpop(Point.class);
    }

    public LineString toLineString() {
        return this.lineString().gpop(LineString.class);
    }

    public LinearRing toLinearRing() {
        return this.ring().gpop(LinearRing.class);
    }

    public Polygon toPolygon() {
        return this.polygon().gpop(Polygon.class);
    }

    public MultiPoint toMultiPoint() {
        return this.multiPoint().gpop(MultiPoint.class);
    }

    public MultiLineString toMultiLineString() {
        return this.multiLineString().gpop(MultiLineString.class);
    }

    public MultiPolygon toMultiPolygon() {
        return this.multiPolygon().gpop(MultiPolygon.class);
    }

    public GeometryCollection toCollection() {
        return this.collection().gpop(GeometryCollection.class);
    }

    Coordinate cpop() {
        return this.cpop(1)[0];
    }

    Coordinate[] cpop(int n) {
        if (this.cstack.size() < n) {
            throw new IllegalStateException(String.format(Locale.ROOT, "Expected %d values on coordinate stack, but found %d", n, this.cstack.size()));
        }
        Coordinate[] c = new Coordinate[n];
        for (int i = 0; i < n; ++i) {
            c[n - i - 1] = this.cstack.pop();
        }
        return c;
    }

    Coordinate[] cpopAll() {
        if (this.cstack.isEmpty()) {
            throw new IllegalStateException("Coordinate stack is empty");
        }
        return this.cpop(this.cstack.size());
    }

    <T extends Geometry> T gpop(Class<T> clazz) {
        return (T)this.gpop(1, clazz)[0];
    }

    <T extends Geometry> T[] gpop(int n, Class<T> clazz) {
        if (this.gstack.size() < n) {
            throw new IllegalStateException(String.format(Locale.ROOT, "Expected %d values on geometry stack, but found %d", n, this.gstack.size()));
        }
        Geometry[] l = (Geometry[])Array.newInstance(clazz, n);
        for (int i = 0; i < n; ++i) {
            Geometry g = this.gstack.pop();
            if (!clazz.isInstance(g)) {
                throw new IllegalStateException(String.format(Locale.ROOT, "Expected %s on geometry stack, but found %s", clazz.getSimpleName(), g.getClass().getSimpleName()));
            }
            l[n - i - 1] = (Geometry)clazz.cast(g);
        }
        return l;
    }

    <T extends Geometry> T[] gpopAll(Class<T> clazz) {
        if (this.gstack.isEmpty()) {
            throw new IllegalArgumentException("Geometry stack is empty");
        }
        int n = 0;
        Iterator<Geometry> it = this.gstack.iterator();
        while (it.hasNext() && clazz.isInstance(it.next())) {
            ++n;
        }
        if (n == 0) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected %s on geometry stack", clazz.getSimpleName()));
        }
        return this.gpop(n, clazz);
    }
}

