/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import java.util.Arrays;
import org.apache.lucene.document.LatLonShape;
import org.apache.lucene.document.LatLonShapeQuery;
import org.apache.lucene.geo.GeoEncodingUtils;
import org.apache.lucene.geo.GeoUtils;
import org.apache.lucene.geo.Rectangle;
import org.apache.lucene.geo.Tessellator;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.util.FutureArrays;
import org.apache.lucene.util.NumericUtils;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
final class LatLonShapeBoundingBoxQuery
extends LatLonShapeQuery {
    final byte[] bbox = new byte[32];
    final byte[] west;
    final int minX;
    final int maxX;
    final int minY;
    final int maxY;

    public LatLonShapeBoundingBoxQuery(String field, LatLonShape.QueryRelation queryRelation, double minLat, double maxLat, double minLon, double maxLon) {
        super(field, queryRelation);
        int minXenc = GeoEncodingUtils.encodeLongitudeCeil((double)minLon);
        int maxXenc = GeoEncodingUtils.encodeLongitude((double)maxLon);
        int minYenc = GeoEncodingUtils.encodeLatitudeCeil((double)minLat);
        int maxYenc = GeoEncodingUtils.encodeLatitude((double)maxLat);
        if (minYenc > maxYenc) {
            minYenc = maxYenc;
        }
        this.minY = minYenc;
        this.maxY = maxYenc;
        if (minLon > maxLon) {
            this.west = new byte[32];
            this.minX = minXenc;
            this.maxX = maxXenc;
            LatLonShapeBoundingBoxQuery.encode(GeoEncodingUtils.MIN_LON_ENCODED, this.maxX, this.minY, this.maxY, this.west);
            LatLonShapeBoundingBoxQuery.encode(this.minX, GeoEncodingUtils.MAX_LON_ENCODED, this.minY, this.maxY, this.bbox);
        } else {
            if (minXenc > maxXenc) {
                minXenc = maxXenc;
            }
            this.west = null;
            this.minX = minXenc;
            this.maxX = maxXenc;
            LatLonShapeBoundingBoxQuery.encode(this.minX, this.maxX, this.minY, this.maxY, this.bbox);
        }
    }

    private static void encode(int minX, int maxX, int minY, int maxY, byte[] b) {
        if (b == null) {
            b = new byte[32];
        }
        LatLonShape.encodeTriangleBoxVal(minY, b, 0);
        LatLonShape.encodeTriangleBoxVal(minX, b, 8);
        LatLonShape.encodeTriangleBoxVal(maxY, b, 16);
        LatLonShape.encodeTriangleBoxVal(maxX, b, 24);
    }

    @Override
    protected PointValues.Relation relateRangeBBoxToQuery(int minXOffset, int minYOffset, byte[] minTriangle, int maxXOffset, int maxYOffset, byte[] maxTriangle) {
        PointValues.Relation eastRelation = LatLonShapeBoundingBoxQuery.compareBBoxToRangeBBox(this.bbox, minXOffset, minYOffset, minTriangle, maxXOffset, maxYOffset, maxTriangle);
        if (this.crossesDateline() && eastRelation == PointValues.Relation.CELL_OUTSIDE_QUERY) {
            return LatLonShapeBoundingBoxQuery.compareBBoxToRangeBBox(this.west, minXOffset, minYOffset, minTriangle, maxXOffset, maxYOffset, maxTriangle);
        }
        return eastRelation;
    }

    protected static PointValues.Relation compareBBoxToRangeBBox(byte[] bbox, int minXOffset, int minYOffset, byte[] minTriangle, int maxXOffset, int maxYOffset, byte[] maxTriangle) {
        if (FutureArrays.compareUnsigned((byte[])minTriangle, (int)minXOffset, (int)(minXOffset + 8), (byte[])bbox, (int)24, (int)32) > 0 || FutureArrays.compareUnsigned((byte[])maxTriangle, (int)maxXOffset, (int)(maxXOffset + 8), (byte[])bbox, (int)8, (int)16) < 0 || FutureArrays.compareUnsigned((byte[])minTriangle, (int)minYOffset, (int)(minYOffset + 8), (byte[])bbox, (int)16, (int)24) > 0 || FutureArrays.compareUnsigned((byte[])maxTriangle, (int)maxYOffset, (int)(maxYOffset + 8), (byte[])bbox, (int)0, (int)8) < 0) {
            return PointValues.Relation.CELL_OUTSIDE_QUERY;
        }
        if (FutureArrays.compareUnsigned((byte[])minTriangle, (int)minXOffset, (int)(minXOffset + 8), (byte[])bbox, (int)8, (int)16) >= 0 && FutureArrays.compareUnsigned((byte[])maxTriangle, (int)maxXOffset, (int)(maxXOffset + 8), (byte[])bbox, (int)24, (int)32) <= 0 && FutureArrays.compareUnsigned((byte[])minTriangle, (int)minYOffset, (int)(minYOffset + 8), (byte[])bbox, (int)0, (int)8) >= 0 && FutureArrays.compareUnsigned((byte[])maxTriangle, (int)maxYOffset, (int)(maxYOffset + 8), (byte[])bbox, (int)16, (int)24) <= 0) {
            return PointValues.Relation.CELL_INSIDE_QUERY;
        }
        return PointValues.Relation.CELL_CROSSES_QUERY;
    }

    @Override
    protected boolean queryMatches(byte[] t) {
        long a = NumericUtils.sortableBytesToLong((byte[])t, (int)32);
        long b = NumericUtils.sortableBytesToLong((byte[])t, (int)40);
        long c = NumericUtils.sortableBytesToLong((byte[])t, (int)48);
        int aX = (int)(a >>> 32 & 0xFFFFFFFFL);
        int bX = (int)(b >>> 32 & 0xFFFFFFFFL);
        int cX = (int)(c >>> 32 & 0xFFFFFFFFL);
        int aY = (int)(a & 0xFFFFFFFFL);
        int bY = (int)(b & 0xFFFFFFFFL);
        int cY = (int)(c & 0xFFFFFFFFL);
        if (this.queryRelation == LatLonShape.QueryRelation.WITHIN) {
            return this.queryContainsTriangle(aX, aY, bX, bY, cX, cY);
        }
        return this.queryMatches(aX, aY, bX, bY, cX, cY);
    }

    private boolean queryContainsTriangle(int ax, int ay, int bx, int by, int cx, int cy) {
        if (this.crossesDateline()) {
            return LatLonShapeBoundingBoxQuery.bboxContainsTriangle(ax, ay, bx, by, cx, cy, GeoEncodingUtils.MIN_LON_ENCODED, this.maxX, this.minY, this.maxY) || LatLonShapeBoundingBoxQuery.bboxContainsTriangle(ax, ay, bx, by, cx, cy, this.minX, GeoEncodingUtils.MAX_LON_ENCODED, this.minY, this.maxY);
        }
        return LatLonShapeBoundingBoxQuery.bboxContainsTriangle(ax, ay, bx, by, cx, cy, this.minX, this.maxX, this.minY, this.maxY);
    }

    private static boolean bboxContainsPoint(int x, int y, int minX, int maxX, int minY, int maxY) {
        return !(x < minX || x > maxX || y < minY || y > maxY);
    }

    private static boolean bboxContainsTriangle(int ax, int ay, int bx, int by, int cx, int cy, int minX, int maxX, int minY, int maxY) {
        return LatLonShapeBoundingBoxQuery.bboxContainsPoint(ax, ay, minX, maxX, minY, maxY) && LatLonShapeBoundingBoxQuery.bboxContainsPoint(bx, by, minX, maxX, minY, maxY) && LatLonShapeBoundingBoxQuery.bboxContainsPoint(cx, cy, minX, maxX, minY, maxY);
    }

    private boolean queryContainsPoint(int x, int y) {
        if (this.crossesDateline()) {
            return LatLonShapeBoundingBoxQuery.bboxContainsPoint(x, y, GeoEncodingUtils.MIN_LON_ENCODED, this.maxX, this.minY, this.maxY) || LatLonShapeBoundingBoxQuery.bboxContainsPoint(x, y, this.minX, GeoEncodingUtils.MAX_LON_ENCODED, this.minY, this.maxY);
        }
        return LatLonShapeBoundingBoxQuery.bboxContainsPoint(x, y, this.minX, this.maxX, this.minY, this.maxY);
    }

    protected boolean queryMatches(int aX, int aY, int bX, int bY, int cX, int cY) {
        if (this.queryContainsPoint(aX, aY) || this.queryContainsPoint(bX, bY) || this.queryContainsPoint(cX, cY)) {
            return true;
        }
        int tMinX = StrictMath.min(StrictMath.min(aX, bX), cX);
        int tMaxX = StrictMath.max(StrictMath.max(aX, bX), cX);
        int tMinY = StrictMath.min(StrictMath.min(aY, bY), cY);
        int tMaxY = StrictMath.max(StrictMath.max(aY, bY), cY);
        if (this.crossesDateline() ? LatLonShapeBoundingBoxQuery.boxesAreDisjoint(tMinX, tMaxX, tMinY, tMaxY, GeoEncodingUtils.MIN_LON_ENCODED, this.maxX, this.minY, this.maxY) && LatLonShapeBoundingBoxQuery.boxesAreDisjoint(tMinX, tMaxX, tMinY, tMaxY, this.minX, GeoEncodingUtils.MAX_LON_ENCODED, this.minY, this.maxY) : tMaxX < this.minX || tMinX > this.maxX || tMinY > this.maxY || tMaxY < this.minY) {
            return false;
        }
        if (Tessellator.pointInTriangle(this.minX, this.minY, aX, aY, bX, bY, cX, cY)) {
            return true;
        }
        if (Tessellator.pointInTriangle(this.maxX, this.minY, aX, aY, bX, bY, cX, cY)) {
            return true;
        }
        if (Tessellator.pointInTriangle(this.maxX, this.maxY, aX, aY, bX, bY, cX, cY)) {
            return true;
        }
        if (Tessellator.pointInTriangle(this.minX, this.maxY, aX, aY, bX, bY, cX, cY)) {
            return true;
        }
        return this.queryIntersects(aX, aY, bX, bY, cX, cY);
    }

    private static boolean edgeIntersectsBox(int ax, int ay, int bx, int by, int minX, int maxX, int minY, int maxY) {
        if (ax == bx && ay == by) {
            return Rectangle.containsPoint((double)ay, (double)ax, (double)minY, (double)maxY, (double)minX, (double)maxX);
        }
        if (LatLonShapeBoundingBoxQuery.bboxContainsPoint(ax, ay, minX, maxX, minY, maxY) || LatLonShapeBoundingBoxQuery.bboxContainsPoint(bx, by, minX, maxX, minY, maxY)) {
            return true;
        }
        if (LatLonShapeBoundingBoxQuery.boxesAreDisjoint(Math.min(ax, bx), Math.max(ax, bx), Math.min(ay, by), Math.max(ay, by), minX, maxX, minY, maxY)) {
            return false;
        }
        if (ax == bx && ay == by) {
            return false;
        }
        if (GeoUtils.orient((double)ax, (double)ay, (double)bx, (double)by, (double)minX, (double)maxY) * GeoUtils.orient((double)ax, (double)ay, (double)bx, (double)by, (double)maxX, (double)maxY) <= 0 && GeoUtils.orient((double)minX, (double)maxY, (double)maxX, (double)maxY, (double)ax, (double)ay) * GeoUtils.orient((double)minX, (double)maxY, (double)maxX, (double)maxY, (double)bx, (double)by) <= 0) {
            return true;
        }
        if (GeoUtils.orient((double)ax, (double)ay, (double)bx, (double)by, (double)maxX, (double)maxY) * GeoUtils.orient((double)ax, (double)ay, (double)bx, (double)by, (double)maxX, (double)minY) <= 0 && GeoUtils.orient((double)maxX, (double)maxY, (double)maxX, (double)minY, (double)ax, (double)ay) * GeoUtils.orient((double)maxX, (double)maxY, (double)maxX, (double)minY, (double)bx, (double)by) <= 0) {
            return true;
        }
        if (GeoUtils.orient((double)ax, (double)ay, (double)bx, (double)by, (double)maxX, (double)minY) * GeoUtils.orient((double)ax, (double)ay, (double)bx, (double)by, (double)minX, (double)minY) <= 0 && GeoUtils.orient((double)maxX, (double)minY, (double)minX, (double)minY, (double)ax, (double)ay) * GeoUtils.orient((double)maxX, (double)minY, (double)minX, (double)minY, (double)bx, (double)by) <= 0) {
            return true;
        }
        return GeoUtils.orient((double)ax, (double)ay, (double)bx, (double)by, (double)minX, (double)minY) * GeoUtils.orient((double)ax, (double)ay, (double)bx, (double)by, (double)minX, (double)maxY) <= 0 && GeoUtils.orient((double)minX, (double)minY, (double)minX, (double)maxY, (double)ax, (double)ay) * GeoUtils.orient((double)minX, (double)minY, (double)minX, (double)maxY, (double)bx, (double)by) <= 0;
    }

    private boolean edgeIntersectsQuery(int ax, int ay, int bx, int by) {
        if (this.crossesDateline()) {
            return LatLonShapeBoundingBoxQuery.edgeIntersectsBox(ax, ay, bx, by, GeoEncodingUtils.MIN_LON_ENCODED, this.maxX, this.minY, this.maxY) || LatLonShapeBoundingBoxQuery.edgeIntersectsBox(ax, ay, bx, by, this.minX, GeoEncodingUtils.MAX_LON_ENCODED, this.minY, this.maxY);
        }
        return LatLonShapeBoundingBoxQuery.edgeIntersectsBox(ax, ay, bx, by, this.minX, this.maxX, this.minY, this.maxY);
    }

    private boolean queryIntersects(int ax, int ay, int bx, int by, int cx, int cy) {
        return this.edgeIntersectsQuery(ax, ay, bx, by) || this.edgeIntersectsQuery(bx, by, cx, cy) || this.edgeIntersectsQuery(cx, cy, ax, ay);
    }

    public static boolean boxesAreDisjoint(int aMinX, int aMaxX, int aMinY, int aMaxY, int bMinX, int bMaxX, int bMinY, int bMaxY) {
        return aMaxX < bMinX || aMinX > bMaxX || aMaxY < bMinY || aMinY > bMaxY;
    }

    public boolean crossesDateline() {
        return this.minX > this.maxX;
    }

    @Override
    public boolean equals(Object o) {
        return this.sameClassAs(o) && this.equalsTo(((Object)((Object)this)).getClass().cast(o));
    }

    @Override
    protected boolean equalsTo(Object o) {
        return super.equalsTo(o) && Arrays.equals(this.bbox, ((LatLonShapeBoundingBoxQuery)((Object)o)).bbox) && Arrays.equals(this.west, ((LatLonShapeBoundingBoxQuery)((Object)o)).west);
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = 31 * hash + Arrays.hashCode(this.bbox);
        hash = 31 * hash + Arrays.hashCode(this.west);
        return hash;
    }

    public String toString(String field) {
        StringBuilder sb = new StringBuilder();
        sb.append(((Object)((Object)this)).getClass().getSimpleName());
        sb.append(':');
        if (!this.field.equals(field)) {
            sb.append(" field=");
            sb.append(this.field);
            sb.append(':');
        }
        sb.append("Rectangle(lat=");
        sb.append(GeoEncodingUtils.decodeLatitude((int)this.minY));
        sb.append(" TO ");
        sb.append(GeoEncodingUtils.decodeLatitude((int)this.maxY));
        sb.append(" lon=");
        sb.append(GeoEncodingUtils.decodeLongitude((int)this.minX));
        sb.append(" TO ");
        sb.append(GeoEncodingUtils.decodeLongitude((int)this.maxX));
        if (this.maxX < this.minX) {
            sb.append(" [crosses dateline!]");
        }
        sb.append(")");
        return sb.toString();
    }
}

