/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ko.dict;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import org.apache.lucene.analysis.ko.POS;
import org.apache.lucene.analysis.ko.dict.Dictionary;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.InputStreamDataInput;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.IntsRef;

public abstract class BinaryDictionary
implements Dictionary {
    public static final String TARGETMAP_FILENAME_SUFFIX = "$targetMap.dat";
    public static final String DICT_FILENAME_SUFFIX = "$buffer.dat";
    public static final String POSDICT_FILENAME_SUFFIX = "$posDict.dat";
    public static final String DICT_HEADER = "ko_dict";
    public static final String TARGETMAP_HEADER = "ko_dict_map";
    public static final String POSDICT_HEADER = "ko_dict_pos";
    public static final int VERSION = 1;
    private final ByteBuffer buffer;
    private final int[] targetMapOffsets;
    private final int[] targetMap;
    private final POS.Tag[] posDict;
    public static final int HAS_SINGLE_POS = 1;
    public static final int HAS_READING = 2;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BinaryDictionary() throws IOException {
        ByteBuffer buffer;
        int[] targetMap;
        int[] targetMapOffsets;
        block10: {
            InputStream dictIS;
            InputStream mapIS;
            block9: {
                mapIS = null;
                dictIS = null;
                InputStream posIS = null;
                targetMapOffsets = null;
                targetMap = null;
                buffer = null;
                boolean success = false;
                try {
                    mapIS = this.getResource(TARGETMAP_FILENAME_SUFFIX);
                    mapIS = new BufferedInputStream(mapIS);
                    InputStreamDataInput in = new InputStreamDataInput(mapIS);
                    CodecUtil.checkHeader((DataInput)in, (String)TARGETMAP_HEADER, (int)1, (int)1);
                    targetMap = new int[in.readVInt()];
                    targetMapOffsets = new int[in.readVInt()];
                    int accum = 0;
                    int sourceId = 0;
                    for (int ofs = 0; ofs < targetMap.length; ++ofs) {
                        int val = in.readVInt();
                        if ((val & 1) != 0) {
                            targetMapOffsets[sourceId] = ofs;
                            ++sourceId;
                        }
                        targetMap[ofs] = accum += val >>> 1;
                    }
                    if (sourceId + 1 != targetMapOffsets.length) {
                        throw new IOException("targetMap file format broken");
                    }
                    targetMapOffsets[sourceId] = targetMap.length;
                    mapIS.close();
                    mapIS = null;
                    posIS = this.getResource(POSDICT_FILENAME_SUFFIX);
                    posIS = new BufferedInputStream(posIS);
                    in = new InputStreamDataInput(posIS);
                    CodecUtil.checkHeader((DataInput)in, (String)POSDICT_HEADER, (int)1, (int)1);
                    int posSize = in.readVInt();
                    this.posDict = new POS.Tag[posSize];
                    for (int j = 0; j < posSize; ++j) {
                        this.posDict[j] = POS.resolveTag(in.readByte());
                    }
                    posIS.close();
                    posIS = null;
                    dictIS = this.getResource(DICT_FILENAME_SUFFIX);
                    in = new InputStreamDataInput(dictIS);
                    CodecUtil.checkHeader((DataInput)in, (String)DICT_HEADER, (int)1, (int)1);
                    int size = in.readVInt();
                    ByteBuffer tmpBuffer = ByteBuffer.allocateDirect(size);
                    ReadableByteChannel channel = Channels.newChannel(dictIS);
                    int read = channel.read(tmpBuffer);
                    if (read != size) {
                        throw new EOFException("Cannot read whole dictionary");
                    }
                    dictIS.close();
                    dictIS = null;
                    buffer = tmpBuffer.asReadOnlyBuffer();
                    success = true;
                    if (!success) break block9;
                }
                catch (Throwable throwable) {
                    if (success) {
                        IOUtils.close((Closeable[])new Closeable[]{mapIS, dictIS});
                    } else {
                        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{mapIS, dictIS});
                    }
                    throw throwable;
                }
                IOUtils.close((Closeable[])new Closeable[]{mapIS, dictIS});
                break block10;
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{mapIS, dictIS});
        }
        this.targetMap = targetMap;
        this.targetMapOffsets = targetMapOffsets;
        this.buffer = buffer;
    }

    protected final InputStream getResource(String suffix) throws IOException {
        return BinaryDictionary.getClassResource(this.getClass(), suffix);
    }

    public static final InputStream getClassResource(Class<?> clazz, String suffix) throws IOException {
        InputStream is = clazz.getResourceAsStream(clazz.getSimpleName() + suffix);
        if (is == null) {
            throw new FileNotFoundException("Not in classpath: " + clazz.getName().replace('.', '/') + suffix);
        }
        return is;
    }

    public void lookupWordIds(int sourceId, IntsRef ref) {
        ref.ints = this.targetMap;
        ref.offset = this.targetMapOffsets[sourceId];
        ref.length = this.targetMapOffsets[sourceId + 1] - ref.offset;
    }

    @Override
    public int getLeftId(int wordId) {
        return this.buffer.getShort(wordId) >>> 2;
    }

    @Override
    public int getRightId(int wordId) {
        return this.buffer.getShort(wordId + 2) >>> 2;
    }

    @Override
    public int getWordCost(int wordId) {
        return this.buffer.getShort(wordId + 4);
    }

    @Override
    public POS.Type getPOSType(int wordId) {
        byte value = (byte)(this.buffer.getShort(wordId) & 3);
        return POS.resolveType(value);
    }

    @Override
    public POS.Tag getLeftPOS(int wordId) {
        return this.posDict[this.getLeftId(wordId)];
    }

    @Override
    public POS.Tag getRightPOS(int wordId) {
        POS.Type type = this.getPOSType(wordId);
        if (type == POS.Type.MORPHEME || type == POS.Type.COMPOUND || this.hasSinglePOS(wordId)) {
            return this.getLeftPOS(wordId);
        }
        byte value = this.buffer.get(wordId + 6);
        return POS.resolveTag(value);
    }

    @Override
    public String getReading(int wordId) {
        if (this.hasReadingData(wordId)) {
            int offset = wordId + 6;
            return this.readString(offset);
        }
        return null;
    }

    @Override
    public Dictionary.Morpheme[] getMorphemes(int wordId, char[] surfaceForm, int off, int len) {
        POS.Type posType = this.getPOSType(wordId);
        if (posType == POS.Type.MORPHEME) {
            return null;
        }
        int offset = wordId + 6;
        boolean hasSinglePos = this.hasSinglePOS(wordId);
        if (!hasSinglePos) {
            // empty if block
        }
        int n = ++offset;
        ++offset;
        int length = this.buffer.get(n);
        if (length == 0) {
            return null;
        }
        Dictionary.Morpheme[] morphemes = new Dictionary.Morpheme[length];
        int surfaceOffset = 0;
        POS.Tag leftPOS = this.getLeftPOS(wordId);
        for (int i = 0; i < length; ++i) {
            String form;
            POS.Tag tag;
            POS.Tag tag2 = tag = hasSinglePos ? leftPOS : POS.resolveTag(this.buffer.get(offset++));
            if (posType == POS.Type.INFLECT) {
                form = this.readString(offset);
                offset += form.length() * 2 + 1;
            } else {
                byte formLen = this.buffer.get(offset++);
                form = new String(surfaceForm, off + surfaceOffset, (int)formLen);
                surfaceOffset += formLen;
            }
            morphemes[i] = new Dictionary.Morpheme(tag, form);
        }
        return morphemes;
    }

    private String readString(int offset) {
        int strOffset = offset;
        int len = this.buffer.get(strOffset++);
        char[] text = new char[len];
        for (int i = 0; i < len; ++i) {
            text[i] = this.buffer.getChar(strOffset + (i << 1));
        }
        return new String(text);
    }

    private boolean hasSinglePOS(int wordId) {
        return (this.buffer.getShort(wordId + 2) & 1) != 0;
    }

    private boolean hasReadingData(int wordId) {
        return (this.buffer.getShort(wordId + 2) & 2) != 0;
    }
}

