/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.spatial4j.io;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.locationtech.spatial4j.context.jts.JtsSpatialContext;
import org.locationtech.spatial4j.io.GeneralReadWriteShapeTest;
import org.locationtech.spatial4j.io.ShapeReader;
import org.locationtech.spatial4j.io.ShapeWriter;
import org.locationtech.spatial4j.shape.Shape;

public class GeneralGeoJSONTest
extends GeneralReadWriteShapeTest {
    ShapeReader reader;
    ShapeWriter writer;
    ShapeWriter writerForTests;

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.reader = ((JtsSpatialContext)this.ctx).getFormats().getReader("GeoJSON");
        this.writerForTests = this.writer = ((JtsSpatialContext)this.ctx).getFormats().getWriter("GeoJSON");
        Assert.assertNotNull((Object)this.reader);
        Assert.assertNotNull((Object)this.writer);
        Assert.assertNotNull((Object)this.writerForTests);
    }

    @Override
    protected ShapeReader getShapeReader() {
        return this.reader;
    }

    @Override
    protected ShapeWriter getShapeWriter() {
        return this.writer;
    }

    @Override
    protected ShapeWriter getShapeWriterForTests() {
        return this.writerForTests;
    }

    @Override
    @Test
    public void testWriteThenReadCircle() throws Exception {
        this.assertRoundTrip(this.circle(), false);
    }

    @Override
    @Test
    public void testWriteThenReadBufferedLine() throws Exception {
        this.assertRoundTrip(this.bufferedLine(), false);
    }

    @Test
    public void testParsePoint() throws Exception {
        Shape v = this.reader.read((Object)this.pointText());
        Assert.assertTrue((boolean)this.point().equals(v));
    }

    @Test
    public void testEncodePoint() throws Exception {
        Assert.assertEquals((Object)this.pointText(), (Object)this.writer.toString((Shape)this.point()));
    }

    @Test
    public void testParseLineString() throws Exception {
        Assert.assertEquals((Object)this.line(), (Object)this.reader.read((Object)this.lineText()));
    }

    @Test
    public void testEncodeLineString() throws Exception {
        Assert.assertEquals((Object)this.lineText(), (Object)this.strip(this.writer.toString(this.line())));
    }

    @Test
    public void testParsePolygon() throws Exception {
        Assert.assertEquals((Object)this.polygon1(), (Object)this.reader.read((Object)this.polygonText1()));
        Assert.assertEquals((Object)this.polygon2(), (Object)this.reader.read((Object)this.polygonText2()));
    }

    @Test
    public void testEncodePolygon() throws Exception {
        Assert.assertEquals((Object)this.polygonText1(), (Object)this.writer.toString(this.polygon1()));
        Assert.assertEquals((Object)this.polygonText2(), (Object)this.writer.toString(this.polygon2()));
    }

    @Test
    public void testParseMultiPoint() throws Exception {
        Assert.assertEquals((Object)this.multiPoint(), (Object)this.reader.read((Object)this.multiPointText()));
    }

    @Test
    public void testEncodeMultiPoint() throws Exception {
        Assert.assertEquals((Object)this.multiPointText(), (Object)this.writer.toString(this.multiPoint()));
    }

    @Test
    public void testParseMultiLineString() throws Exception {
        Assert.assertEquals((Object)this.multiLine(), (Object)this.reader.read((Object)this.multiLineText()));
    }

    @Test
    public void testEncodeMultiLineString() throws Exception {
        Assert.assertEquals((Object)this.multiLineText(), (Object)this.writer.toString(this.multiLine()));
    }

    @Test
    public void testParseMultiPolygon() throws Exception {
        Assert.assertEquals((Object)this.multiPolygon(), (Object)this.reader.read((Object)this.multiPolygonText()));
    }

    @Test
    public void testEncodeMultiPolygon() throws Exception {
        Assert.assertEquals((Object)this.multiPolygonText(), (Object)this.writer.toString(this.multiPolygon()));
    }

    @Test
    public void testEncodeRectangle() throws Exception {
        Assert.assertEquals((Object)this.rectangleText(), (Object)this.strip(this.writer.toString((Shape)this.rectangle())));
    }

    @Test
    public void testParseGeometryCollection() throws Exception {
        Assert.assertEquals((Object)this.collection(), (Object)this.reader.read((Object)this.collectionText()));
    }

    @Test
    public void testEncodeGeometryCollection() throws Exception {
        Assert.assertEquals((Object)this.collectionText(), (Object)this.strip(this.writer.toString(this.collection())));
    }

    @Test
    public void testEncodeBufferedLineString() throws Exception {
        Assert.assertEquals((Object)this.bufferedLineText(), (Object)this.strip(this.writer.toString(this.bufferedLine())));
    }
}

