/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.Closeable;
import java.io.IOException;
import java.util.HashSet;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.MergeScheduler;
import org.apache.lucene.index.MultiDocValues;
import org.apache.lucene.index.MultiFields;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SerialMergeScheduler;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SimpleCollector;
import org.apache.lucene.store.BaseDirectoryWrapper;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.LuceneTestCase;

public abstract class BaseRangeFieldQueryTestCase
extends LuceneTestCase {
    protected abstract Field newRangeField(Range var1);

    protected abstract Query newIntersectsQuery(Range var1);

    protected abstract Query newContainsQuery(Range var1);

    protected abstract Query newWithinQuery(Range var1);

    protected abstract Query newCrossesQuery(Range var1);

    protected abstract Range nextRange(int var1) throws Exception;

    protected int dimension() {
        return BaseRangeFieldQueryTestCase.random().nextInt(4) + 1;
    }

    public void testRandomTiny() throws Exception {
        for (int i = 0; i < 10; ++i) {
            this.doTestRandom(10, false);
        }
    }

    public void testRandomMedium() throws Exception {
        this.doTestRandom(10000, false);
    }

    @LuceneTestCase.Nightly
    public void testRandomBig() throws Exception {
        this.doTestRandom(200000, false);
    }

    public void testMultiValued() throws Exception {
        this.doTestRandom(10000, true);
    }

    private void doTestRandom(int count, boolean multiValued) throws Exception {
        int numDocs = BaseRangeFieldQueryTestCase.atLeast(count);
        int dimensions = this.dimension();
        if (VERBOSE) {
            System.out.println("TEST: numDocs=" + numDocs);
        }
        Range[][] ranges = new Range[numDocs][];
        boolean haveRealDoc = true;
        for (int id = 0; id < numDocs; ++id) {
            int oldID;
            int x;
            block11: {
                int i;
                x = BaseRangeFieldQueryTestCase.random().nextInt(20);
                if (ranges[id] == null) {
                    ranges[id] = new Range[]{this.nextRange(dimensions)};
                }
                if (x == 17) {
                    ranges[id][0].isMissing = true;
                    if (!VERBOSE) continue;
                    System.out.println("  id=" + id + " is missing");
                    continue;
                }
                if (multiValued && BaseRangeFieldQueryTestCase.random().nextBoolean()) {
                    int n = BaseRangeFieldQueryTestCase.random().nextInt(2) + 1;
                    ranges[id] = new Range[n];
                    for (i = 0; i < n; ++i) {
                        ranges[id][i] = this.nextRange(dimensions);
                    }
                }
                if (id <= 0 || x >= 9 || !haveRealDoc) continue;
                i = 0;
                do {
                    oldID = BaseRangeFieldQueryTestCase.random().nextInt(id);
                    if (!ranges[oldID][0].isMissing) break block11;
                } while (++i <= id);
                continue;
            }
            if (x == dimensions * 2) {
                for (int d = 0; d < dimensions; ++d) {
                    ranges[id][0].setMin(d, ranges[oldID][0].getMin(d));
                    ranges[id][0].setMax(d, ranges[oldID][0].getMax(d));
                }
                if (!VERBOSE) continue;
                System.out.println("  id=" + id + " box=" + ranges[id] + " (same box as doc=" + oldID + ")");
                continue;
            }
            int even = dimensions % 2;
            for (int m = 0; m < dimensions * 2; ++m) {
                if (x != m) continue;
                int d = (int)Math.floor(m / 2);
                if (even == 0) {
                    ranges[id][0].setMin(d, ranges[oldID][0].getMin(d));
                    if (!VERBOSE) continue;
                    System.out.println("  id=" + id + " box=" + ranges[id] + " (same min[" + d + "] as doc=" + oldID + ")");
                    continue;
                }
                ranges[id][0].setMax(d, ranges[oldID][0].getMax(d));
                if (!VERBOSE) continue;
                System.out.println("  id=" + id + " box=" + ranges[id] + " (same max[" + d + "] as doc=" + oldID + ")");
            }
        }
        this.verify(ranges);
    }

    private void verify(Range[][] ranges) throws Exception {
        IndexWriterConfig iwc = BaseRangeFieldQueryTestCase.newIndexWriterConfig();
        iwc.setMergeScheduler((MergeScheduler)new SerialMergeScheduler());
        int mbd = iwc.getMaxBufferedDocs();
        if (mbd != -1 && mbd < ranges.length / 100) {
            iwc.setMaxBufferedDocs(ranges.length / 100);
        }
        BaseDirectoryWrapper dir = ranges.length > 50000 ? BaseRangeFieldQueryTestCase.newFSDirectory(BaseRangeFieldQueryTestCase.createTempDir(((Object)((Object)this)).getClass().getSimpleName())) : BaseRangeFieldQueryTestCase.newDirectory();
        HashSet<Integer> deleted = new HashSet<Integer>();
        IndexWriter w = new IndexWriter((Directory)dir, iwc);
        for (int id = 0; id < ranges.length; ++id) {
            Document doc = new Document();
            doc.add((IndexableField)BaseRangeFieldQueryTestCase.newStringField("id", "" + id, Field.Store.NO));
            doc.add((IndexableField)new NumericDocValuesField("id", (long)id));
            if (!ranges[id][0].isMissing) {
                for (int n = 0; n < ranges[id].length; ++n) {
                    doc.add((IndexableField)this.newRangeField(ranges[id][n]));
                }
            }
            w.addDocument((Iterable)doc);
            if (id <= 0 || BaseRangeFieldQueryTestCase.random().nextInt(100) != 1) continue;
            int idToDelete = BaseRangeFieldQueryTestCase.random().nextInt(id);
            w.deleteDocuments(new Term[]{new Term("id", "" + idToDelete)});
            deleted.add(idToDelete);
            if (!VERBOSE) continue;
            System.out.println("  delete id=" + idToDelete);
        }
        if (BaseRangeFieldQueryTestCase.random().nextBoolean()) {
            w.forceMerge(1);
        }
        DirectoryReader r = DirectoryReader.open((IndexWriter)w);
        w.close();
        IndexSearcher s = BaseRangeFieldQueryTestCase.newSearcher((IndexReader)r);
        int dimensions = ranges[0][0].numDimensions();
        int iters = BaseRangeFieldQueryTestCase.atLeast(25);
        NumericDocValues docIDToID = MultiDocValues.getNumericValues((IndexReader)r, (String)"id");
        Bits liveDocs = MultiFields.getLiveDocs((IndexReader)s.getIndexReader());
        int maxDoc = s.getIndexReader().maxDoc();
        for (int iter = 0; iter < iters; ++iter) {
            Query query;
            Range.QueryType queryType;
            if (VERBOSE) {
                System.out.println("\nTEST: iter=" + iter + " s=" + s);
            }
            Range queryRange = this.nextRange(dimensions);
            int rv = BaseRangeFieldQueryTestCase.random().nextInt(4);
            if (rv == 0) {
                queryType = Range.QueryType.INTERSECTS;
                query = this.newIntersectsQuery(queryRange);
            } else if (rv == 1) {
                queryType = Range.QueryType.CONTAINS;
                query = this.newContainsQuery(queryRange);
            } else if (rv == 2) {
                queryType = Range.QueryType.WITHIN;
                query = this.newWithinQuery(queryRange);
            } else {
                queryType = Range.QueryType.CROSSES;
                query = this.newCrossesQuery(queryRange);
            }
            if (VERBOSE) {
                System.out.println("  query=" + query);
            }
            final FixedBitSet hits = new FixedBitSet(maxDoc);
            s.search(query, (Collector)new SimpleCollector(){
                private int docBase;

                public void collect(int doc) {
                    hits.set(this.docBase + doc);
                }

                protected void doSetNextReader(LeafReaderContext context) throws IOException {
                    this.docBase = context.docBase;
                }

                public boolean needsScores() {
                    return false;
                }
            });
            for (int docID = 0; docID < maxDoc; ++docID) {
                int id = (int)docIDToID.get(docID);
                boolean expected = liveDocs != null && !liveDocs.get(docID) ? false : (ranges[id][0].isMissing ? false : this.expectedResult(queryRange, ranges[id], queryType));
                if (hits.get(docID) == expected) continue;
                StringBuilder b = new StringBuilder();
                b.append("FAIL (iter " + iter + "): ");
                if (expected) {
                    b.append("id=" + id + (ranges[id].length > 1 ? " (MultiValue) " : " ") + "should match but did not\n");
                } else {
                    b.append("id=" + id + " should not match but did\n");
                }
                b.append(" queryRange=" + queryRange + "\n");
                b.append(" box" + (ranges[id].length > 1 ? "es=" : "=") + ranges[id][0]);
                for (int n = 1; n < ranges[id].length; ++n) {
                    b.append(", ");
                    b.append(ranges[id][n]);
                }
                b.append("\n queryType=" + (Object)((Object)queryType) + "\n");
                b.append(" deleted?=" + (liveDocs != null && !liveDocs.get(docID)));
                BaseRangeFieldQueryTestCase.fail((String)("wrong hit (first of possibly more):\n\n" + b));
            }
        }
        IOUtils.close((Closeable[])new Closeable[]{r, dir});
    }

    protected boolean expectedResult(Range queryRange, Range[] range, Range.QueryType queryType) {
        for (int i = 0; i < range.length; ++i) {
            if (!this.expectedBBoxQueryResult(queryRange, range[i], queryType)) continue;
            return true;
        }
        return false;
    }

    protected boolean expectedBBoxQueryResult(Range queryRange, Range range, Range.QueryType queryType) {
        if (queryRange.isEqual(range) && queryType != Range.QueryType.CROSSES) {
            return true;
        }
        Range.QueryType relation = range.relate(queryRange);
        if (queryType == Range.QueryType.INTERSECTS) {
            return relation != null;
        }
        if (queryType == Range.QueryType.CROSSES) {
            return relation == queryType || relation == Range.QueryType.CONTAINS;
        }
        return relation == queryType;
    }

    protected static abstract class Range {
        protected boolean isMissing = false;

        protected Range() {
        }

        protected abstract int numDimensions();

        protected abstract Object getMin(int var1);

        protected abstract void setMin(int var1, Object var2);

        protected abstract Object getMax(int var1);

        protected abstract void setMax(int var1, Object var2);

        protected abstract boolean isEqual(Range var1);

        protected abstract boolean isDisjoint(Range var1);

        protected abstract boolean isWithin(Range var1);

        protected abstract boolean contains(Range var1);

        protected QueryType relate(Range other) {
            if (this.isDisjoint(other)) {
                return null;
            }
            if (this.isWithin(other)) {
                return QueryType.WITHIN;
            }
            if (this.contains(other)) {
                return QueryType.CONTAINS;
            }
            return QueryType.CROSSES;
        }

        protected static enum QueryType {
            INTERSECTS,
            WITHIN,
            CONTAINS,
            CROSSES;

        }
    }
}

