/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.spatial4j.io;

import org.junit.Assert;
import org.junit.Test;
import org.locationtech.spatial4j.context.SpatialContext;
import org.locationtech.spatial4j.io.GeohashUtils;
import org.locationtech.spatial4j.shape.Point;

public class TestGeohashUtils {
    SpatialContext ctx = SpatialContext.GEO;

    @Test
    public void testEncode() {
        String hash = GeohashUtils.encodeLatLon((double)42.6, (double)-5.6);
        Assert.assertEquals((Object)"ezs42e44yx96", (Object)hash);
        hash = GeohashUtils.encodeLatLon((double)57.64911, (double)10.40744);
        Assert.assertEquals((Object)"u4pruydqqvj8", (Object)hash);
    }

    @Test
    public void testDecodePreciseLongitudeLatitude() {
        String hash = GeohashUtils.encodeLatLon((double)52.3738007, (double)4.8909347);
        Point point = GeohashUtils.decode((String)hash, (SpatialContext)this.ctx);
        Assert.assertEquals((double)52.3738007, (double)point.getY(), (double)1.0E-5);
        Assert.assertEquals((double)4.8909347, (double)point.getX(), (double)1.0E-5);
    }

    @Test
    public void testDecodeImpreciseLongitudeLatitude() {
        String hash = GeohashUtils.encodeLatLon((double)84.6, (double)10.5);
        Point point = GeohashUtils.decode((String)hash, (SpatialContext)this.ctx);
        Assert.assertEquals((double)84.6, (double)point.getY(), (double)1.0E-5);
        Assert.assertEquals((double)10.5, (double)point.getX(), (double)1.0E-5);
    }

    @Test
    public void testDecodeEncode() {
        String geoHash = "u173zq37x014";
        Assert.assertEquals((Object)geoHash, (Object)GeohashUtils.encodeLatLon((double)52.3738007, (double)4.8909347));
        Point point = GeohashUtils.decode((String)geoHash, (SpatialContext)this.ctx);
        Assert.assertEquals((double)52.37380061, (double)point.getY(), (double)1.0E-6);
        Assert.assertEquals((double)4.8909343, (double)point.getX(), (double)1.0E-6);
        Assert.assertEquals((Object)geoHash, (Object)GeohashUtils.encodeLatLon((double)point.getY(), (double)point.getX()));
        geoHash = "u173";
        point = GeohashUtils.decode((String)"u173", (SpatialContext)this.ctx);
        geoHash = GeohashUtils.encodeLatLon((double)point.getY(), (double)point.getX());
        Point point2 = GeohashUtils.decode((String)geoHash, (SpatialContext)this.ctx);
        Assert.assertEquals((double)point.getY(), (double)point2.getY(), (double)1.0E-6);
        Assert.assertEquals((double)point.getX(), (double)point2.getX(), (double)1.0E-6);
    }

    @Test
    public void testHashLenToWidth() {
        double[] boxOdd = GeohashUtils.lookupDegreesSizeForHashLen((int)3);
        Assert.assertEquals((double)1.40625, (double)boxOdd[0], (double)1.0E-4);
        Assert.assertEquals((double)1.40625, (double)boxOdd[1], (double)1.0E-4);
        double[] boxEven = GeohashUtils.lookupDegreesSizeForHashLen((int)4);
        Assert.assertEquals((double)0.1757, (double)boxEven[0], (double)1.0E-4);
        Assert.assertEquals((double)0.3515, (double)boxEven[1], (double)1.0E-4);
    }

    @Test
    public void testLookupHashLenForWidthHeight() {
        Assert.assertEquals((long)1L, (long)GeohashUtils.lookupHashLenForWidthHeight((double)999.0, (double)999.0));
        Assert.assertEquals((long)1L, (long)GeohashUtils.lookupHashLenForWidthHeight((double)999.0, (double)46.0));
        Assert.assertEquals((long)1L, (long)GeohashUtils.lookupHashLenForWidthHeight((double)46.0, (double)999.0));
        Assert.assertEquals((long)2L, (long)GeohashUtils.lookupHashLenForWidthHeight((double)44.0, (double)999.0));
        Assert.assertEquals((long)2L, (long)GeohashUtils.lookupHashLenForWidthHeight((double)999.0, (double)44.0));
        Assert.assertEquals((long)2L, (long)GeohashUtils.lookupHashLenForWidthHeight((double)999.0, (double)5.7));
        Assert.assertEquals((long)2L, (long)GeohashUtils.lookupHashLenForWidthHeight((double)11.3, (double)999.0));
        Assert.assertEquals((long)3L, (long)GeohashUtils.lookupHashLenForWidthHeight((double)999.0, (double)5.5));
        Assert.assertEquals((long)3L, (long)GeohashUtils.lookupHashLenForWidthHeight((double)11.1, (double)999.0));
        Assert.assertEquals((long)24L, (long)GeohashUtils.lookupHashLenForWidthHeight((double)1.0E-19, (double)1.0E-19));
    }
}

