/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.impl;

import java.util.HashSet;
import java.util.Set;
import org.apache.uima.cas.CASRuntimeException;
import org.apache.uima.cas.FSTypeConstraint;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.impl.FeatureStructureImpl;
import org.apache.uima.cas.impl.TypeSystemImpl;
import org.apache.uima.internal.util.SortedIntSet;

class FSTypeConstraintImpl
implements FSTypeConstraint {
    private static final long serialVersionUID = 7557683109761796280L;
    private Set<String> nameSet = new HashSet<String>();
    private transient SortedIntSet typeSet = new SortedIntSet();
    private transient TypeSystem ts;

    FSTypeConstraintImpl() {
    }

    public boolean match(FeatureStructure fs) {
        this.compile(((FeatureStructureImpl)fs).getCAS().getTypeSystem());
        FeatureStructureImpl fsi = (FeatureStructureImpl)fs;
        int typeCode = fsi.getCASImpl().getHeapValue(fsi.getAddress());
        TypeSystemImpl tsi = (TypeSystemImpl)this.ts;
        for (int i = 0; i < this.typeSet.size(); ++i) {
            if (!tsi.subsumes(this.typeSet.get(i), typeCode)) continue;
            return true;
        }
        return false;
    }

    private final void compile(TypeSystem ts1) {
        if (this.ts == ts1) {
            return;
        }
        this.ts = ts1;
        TypeSystemImpl tsi = (TypeSystemImpl)ts1;
        for (String typeName : this.nameSet) {
            int typeCode = tsi.ll_getCodeForTypeName(typeName);
            if (typeCode < tsi.getSmallestType()) {
                CASRuntimeException e = new CASRuntimeException("UNKNOWN_CONSTRAINT_TYPE", new String[]{typeName});
                throw e;
            }
            this.typeSet.add(typeCode);
        }
    }

    public void add(Type type) {
        this.ts = null;
        this.nameSet.add(type.getName());
    }

    public void add(String type) {
        this.ts = null;
        this.nameSet.add(type);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("isa ( ");
        boolean start = true;
        for (String name : this.nameSet) {
            if (start) {
                start = false;
            } else {
                buf.append("| ");
            }
            buf.append(name);
            buf.append(" ");
        }
        buf.append(")");
        return buf.toString();
    }
}

