/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.spatial4j.shape;

import org.junit.Assert;
import org.locationtech.spatial4j.TestLog;
import org.locationtech.spatial4j.context.SpatialContext;
import org.locationtech.spatial4j.shape.Point;
import org.locationtech.spatial4j.shape.RandomizedShapeTest;
import org.locationtech.spatial4j.shape.Rectangle;
import org.locationtech.spatial4j.shape.Shape;
import org.locationtech.spatial4j.shape.SpatialRelation;
import org.locationtech.spatial4j.shape.impl.InfBufLine;
import org.locationtech.spatial4j.shape.impl.PointImpl;

public abstract class RectIntersectionTestHelper<S extends Shape>
extends RandomizedShapeTest {
    public RectIntersectionTestHelper(SpatialContext ctx) {
        super(ctx);
    }

    protected boolean isRandomShapeRectangular() {
        return false;
    }

    protected abstract S generateRandomShape(Point var1);

    protected abstract Point randomPointInEmptyShape(S var1);

    protected int getContainsMinimum(int laps) {
        return laps / 1000;
    }

    protected int getIntersectsMinimum(int laps) {
        return laps / 1000;
    }

    protected int getWithinMinimum(int laps) {
        return laps / 1000;
    }

    protected int getDisjointMinimum(int laps) {
        return laps / 1000;
    }

    protected int getBoundingMinimum(int laps) {
        return laps / 1000;
    }

    @Override
    protected Point randomPointInOrNull(Shape shape) {
        if (!shape.hasArea()) {
            Point pt = this.randomPointInEmptyShape(shape);
            assert (shape.relate((Shape)pt).intersects()) : "faulty randomPointInEmptyShape";
            return pt;
        }
        return super.randomPointInOrNull(shape);
    }

    public void testRelateWithRectangle() {
        int i_C = 0;
        int i_I = 0;
        int i_W = 0;
        int i_D = 0;
        int i_bboxD = 0;
        int laps = 0;
        int MINLAPS = RectIntersectionTestHelper.scaledRandomIntBetween((int)20000, (int)200000);
        block8: while (i_C < this.getContainsMinimum(MINLAPS) || i_I < this.getIntersectsMinimum(MINLAPS) || i_W < this.getWithinMinimum(MINLAPS) || !this.isRandomShapeRectangular() && i_D < this.getDisjointMinimum(MINLAPS) || i_bboxD < this.getBoundingMinimum(MINLAPS)) {
            TestLog.clear();
            if (++laps > MINLAPS) {
                Assert.fail((String)("Did not find enough contains/within/intersection/disjoint/bounds cases in a reasonable number of random attempts. CWIDbD: " + i_C + "(" + this.getContainsMinimum(MINLAPS) + ")," + i_W + "(" + this.getWithinMinimum(MINLAPS) + ")," + i_I + "(" + this.getIntersectsMinimum(MINLAPS) + ")," + i_D + "(" + this.getDisjointMinimum(MINLAPS) + ")," + i_bboxD + "(" + this.getBoundingMinimum(MINLAPS) + ")" + "  Laps exceeded " + MINLAPS));
            }
            Point nearP = this.randomPointIn(this.ctx.getWorldBounds());
            S s = this.generateRandomShape(nearP);
            Rectangle r = this.randomRectangle(s.getBoundingBox().getCenter());
            SpatialRelation ic = s.relate((Shape)r);
            TestLog.log("S-R Rel: {}, Shape {}, Rectangle {}", ic, s, r);
            if (ic != SpatialRelation.DISJOINT) {
                Assert.assertTrue((String)"if not disjoint then the shape's bbox shouldn't be disjoint", (boolean)s.getBoundingBox().relate((Shape)r).intersects());
            }
            try {
                int MAX_TRIES = RectIntersectionTestHelper.scaledRandomIntBetween((int)10, (int)100);
                block1 : switch (ic) {
                    case CONTAINS: {
                        Point p;
                        ++i_C;
                        for (int j = 0; j < MAX_TRIES; ++j) {
                            p = this.randomPointIn(r);
                            this.assertRelation(null, SpatialRelation.CONTAINS, (Shape)s, (Shape)p);
                        }
                        continue block8;
                    }
                    case WITHIN: {
                        Point p;
                        ++i_W;
                        for (int j = 0; j < MAX_TRIES; ++j) {
                            p = this.randomPointInOrNull((Shape)s);
                            if (p == null) break block1;
                            this.assertRelation(null, SpatialRelation.CONTAINS, (Shape)r, (Shape)p);
                        }
                        continue block8;
                    }
                    case DISJOINT: {
                        Point p;
                        if (!s.getBoundingBox().relate((Shape)r).intersects()) {
                            if (++i_bboxD >= this.getBoundingMinimum(MINLAPS)) {
                                break;
                            }
                        } else {
                            ++i_D;
                        }
                        for (int j = 0; j < MAX_TRIES; ++j) {
                            p = this.randomPointIn(r);
                            this.assertRelation(null, SpatialRelation.DISJOINT, (Shape)s, (Shape)p);
                        }
                        continue block8;
                    }
                    case INTERSECTS: {
                        ++i_I;
                        SpatialRelation pointR = null;
                        Rectangle randomPointSpace = null;
                        MAX_TRIES = 1000;
                        for (int j = 0; j < MAX_TRIES; ++j) {
                            Point p;
                            if (j < 4) {
                                p = new PointImpl(0.0, 0.0, this.ctx);
                                InfBufLine.cornerByQuadrant((Rectangle)r, (int)(j + 1), (Point)p);
                            } else {
                                if (randomPointSpace == null) {
                                    randomPointSpace = pointR == SpatialRelation.DISJOINT ? this.intersectRects(r, s.getBoundingBox()) : r;
                                }
                                p = this.randomPointIn(randomPointSpace);
                            }
                            SpatialRelation pointRNew = s.relate((Shape)p);
                            if (pointR == null) {
                                pointR = pointRNew;
                                continue;
                            }
                            if (pointR != pointRNew) break block1;
                        }
                        continue block8;
                    }
                    default: {
                        Assert.fail((String)("" + ic));
                    }
                }
            }
            catch (AssertionError e) {
                this.onAssertFail(e, s, r, ic);
            }
        }
        System.out.println("Laps: " + laps + " CWIDbD: " + i_C + "," + i_W + "," + i_I + "," + i_D + "," + i_bboxD);
    }

    protected void onAssertFail(AssertionError e, S s, Rectangle r, SpatialRelation ic) {
        throw e;
    }

    private Rectangle intersectRects(Rectangle r1, Rectangle r2) {
        assert (r1.relate((Shape)r2).intersects());
        double minX = r1.relateXRange(r2.getMinX(), r2.getMinX()).intersects() ? r2.getMinX() : r1.getMinX();
        double maxX = r1.relateXRange(r2.getMaxX(), r2.getMaxX()).intersects() ? r2.getMaxX() : r1.getMaxX();
        double minY = r1.relateYRange(r2.getMinY(), r2.getMinY()).intersects() ? r2.getMinY() : r1.getMinY();
        double maxY = r1.relateYRange(r2.getMaxY(), r2.getMaxY()).intersects() ? r2.getMaxY() : r1.getMaxY();
        return this.ctx.makeRectangle(minX, maxX, minY, maxY);
    }
}

