/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.spatial4j.shape;

import com.carrotsearch.randomizedtesting.RandomizedContext;
import com.carrotsearch.randomizedtesting.annotations.Repeat;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateFilter;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.IntersectionMatrix;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKTReader;
import io.jeo.geom.Geom;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.spatial4j.context.SpatialContext;
import org.locationtech.spatial4j.context.jts.JtsSpatialContext;
import org.locationtech.spatial4j.context.jts.JtsSpatialContextFactory;
import org.locationtech.spatial4j.shape.AbstractTestShapes;
import org.locationtech.spatial4j.shape.Point;
import org.locationtech.spatial4j.shape.Rectangle;
import org.locationtech.spatial4j.shape.Shape;
import org.locationtech.spatial4j.shape.SpatialRelation;
import org.locationtech.spatial4j.shape.impl.PointImpl;
import org.locationtech.spatial4j.shape.impl.RectangleImpl;
import org.locationtech.spatial4j.shape.jts.JtsGeometry;

public class JtsGeometryTest
extends AbstractTestShapes {
    private final String POLY_STR = "Polygon((-10 30, -40 40, -10 -20, 40 20, 0 0, -10 30))";
    private JtsGeometry POLY_SHAPE = (JtsGeometry)this.wkt(this.ctx, "Polygon((-10 30, -40 40, -10 -20, 40 20, 0 0, -10 30))");
    private final int DL_SHIFT = 180;
    private JtsGeometry POLY_SHAPE_DL;
    final JtsSpatialContext ctxNotGeo;

    public JtsGeometryTest() throws java.text.ParseException {
        super((SpatialContext)JtsSpatialContext.GEO);
        if (this.ctx.isGeo()) {
            this.POLY_SHAPE_DL = this.shiftPoly(this.POLY_SHAPE, 180);
            Assert.assertTrue((boolean)this.POLY_SHAPE_DL.getBoundingBox().getCrossesDateLine());
        }
        JtsSpatialContextFactory ctxFactory = new JtsSpatialContextFactory();
        ctxFactory.geo = false;
        ctxFactory.worldBounds = new RectangleImpl(-1000.0, 1000.0, -1000.0, 1000.0, null);
        this.ctxNotGeo = ctxFactory.newSpatialContext();
    }

    private JtsGeometry shiftPoly(JtsGeometry poly, final int lon_shift) throws java.text.ParseException {
        final Random random = RandomizedContext.current().getRandom();
        Geometry pGeom = poly.getGeom();
        Assert.assertTrue((boolean)pGeom.isValid());
        pGeom = (Geometry)pGeom.clone();
        pGeom.apply(new CoordinateFilter(){

            public void filter(Coordinate coord) {
                coord.x = JtsGeometryTest.this.normX(coord.x + (double)lon_shift);
                if (JtsGeometryTest.this.ctx.isGeo() && Math.abs(coord.x) == 180.0 && random.nextBoolean()) {
                    coord.x = -coord.x;
                }
            }
        });
        pGeom.geometryChanged();
        Assert.assertFalse((boolean)pGeom.isValid());
        return (JtsGeometry)this.wkt(this.ctx, pGeom.toText());
    }

    @Test
    public void testRelations() throws java.text.ParseException {
        this.testRelations(false);
        this.testRelations(true);
    }

    public void testRelations(boolean prepare) throws java.text.ParseException {
        assert (!((JtsSpatialContext)this.ctx).isAutoIndex());
        JtsGeometry base = (JtsGeometry)this.wkt(this.ctx, "POLYGON((0 0, 10 0, 5 5, 0 0))");
        JtsGeometry polyI = (JtsGeometry)this.wkt(this.ctx, "POLYGON((10 0, 20 0, 15 5, 10 0))");
        JtsGeometry polyW = (JtsGeometry)this.wkt(this.ctx, "POLYGON((0 0, 9 0, 5 5, 0 0))");
        Point pointB = this.ctx.makePoint(0.0, 0.0);
        JtsGeometry lineB = (JtsGeometry)this.wkt(this.ctx, "LINESTRING(0 0, 10 0)");
        JtsGeometry lineI = (JtsGeometry)this.wkt(this.ctx, "LINESTRING(10 0, 20 0)");
        if (prepare) {
            base.index();
        }
        this.assertRelation(SpatialRelation.CONTAINS, (Shape)base, (Shape)base);
        this.assertRelation(SpatialRelation.INTERSECTS, (Shape)base, (Shape)polyI);
        this.assertRelation(SpatialRelation.CONTAINS, (Shape)base, (Shape)polyW);
        this.assertRelation(SpatialRelation.CONTAINS, (Shape)base, (Shape)pointB);
        this.assertRelation(SpatialRelation.CONTAINS, (Shape)base, (Shape)lineB);
        this.assertRelation(SpatialRelation.INTERSECTS, (Shape)base, (Shape)lineI);
        if (prepare) {
            lineB.index();
        }
        this.assertRelation(SpatialRelation.CONTAINS, (Shape)lineB, (Shape)lineB);
        this.assertRelation(SpatialRelation.CONTAINS, (Shape)lineB, (Shape)pointB);
    }

    @Test
    public void testEmpty() throws java.text.ParseException {
        Shape emptyGeom = this.wkt(this.ctx, "POLYGON EMPTY");
        this.testEmptiness(emptyGeom);
        this.assertRelation("EMPTY", SpatialRelation.DISJOINT, emptyGeom, (Shape)this.POLY_SHAPE);
    }

    @Test
    public void testArea() {
        Rectangle r = this.randomRectangle(20);
        JtsSpatialContext ctxJts = (JtsSpatialContext)this.ctx;
        JtsGeometry rPoly = ctxJts.makeShape(ctxJts.getGeometryFrom((Shape)r), false, false);
        Assert.assertEquals((double)r.getArea(null), (double)rPoly.getArea(null), (double)0.0);
        Assert.assertEquals((double)r.getArea(this.ctx), (double)rPoly.getArea(this.ctx), (double)1.0E-6);
        Assert.assertEquals((double)1300.0, (double)this.POLY_SHAPE.getArea(null), (double)0.0);
        Assert.assertEquals((double)0.27, (double)(this.POLY_SHAPE.getArea(this.ctx) / this.POLY_SHAPE.getBoundingBox().getArea(this.ctx)), (double)0.009);
        Assert.assertTrue((this.POLY_SHAPE.getBoundingBox().getArea(this.ctx) > this.POLY_SHAPE.getArea(this.ctx) ? 1 : 0) != 0);
    }

    @Test
    @Repeat(iterations=100)
    public void testPointAndRectIntersect() {
        Rectangle r = this.randomRectangle(5);
        this.assertJtsConsistentRelate((Shape)r);
        this.assertJtsConsistentRelate((Shape)r.getCenter());
    }

    @Test
    public void testRegressions() {
        this.assertJtsConsistentRelate((Shape)new PointImpl(-10.0, 4.0, this.ctx));
        this.assertJtsConsistentRelate((Shape)new PointImpl(-15.0, -10.0, this.ctx));
        this.assertJtsConsistentRelate((Shape)this.ctx.makeRectangle(135.0, 180.0, -10.0, 10.0));
    }

    @Test
    public void testWidthGreaterThan180() throws java.text.ParseException {
        JtsGeometry jtsGeo = (JtsGeometry)this.wkt(this.ctx, "POLYGON((-161 49, 0 49, 20 49, 20 89.1, 0 89.1, -161 89.2, -161 49))");
        Assert.assertEquals((double)181.0, (double)jtsGeo.getBoundingBox().getWidth(), (double)0.001);
        jtsGeo = this.shiftPoly(jtsGeo, 180);
        Assert.assertEquals((double)181.0, (double)jtsGeo.getBoundingBox().getWidth(), (double)0.001);
    }

    private void assertJtsConsistentRelate(Shape shape) {
        IntersectionMatrix expectedM = this.POLY_SHAPE.getGeom().relate(((JtsSpatialContext)this.ctx).getGeometryFrom(shape));
        SpatialRelation expectedSR = JtsGeometry.intersectionMatrixToSpatialRelation((IntersectionMatrix)expectedM);
        if (expectedSR == SpatialRelation.INTERSECTS && shape instanceof Point) {
            expectedSR = SpatialRelation.CONTAINS;
        }
        this.assertRelation(null, expectedSR, (Shape)this.POLY_SHAPE, shape);
        if (this.ctx.isGeo()) {
            Rectangle shape2;
            if (shape instanceof Rectangle) {
                Rectangle r = (Rectangle)shape;
                shape2 = this.makeNormRect(r.getMinX() + 180.0, r.getMaxX() + 180.0, r.getMinY(), r.getMaxY());
            } else if (shape instanceof Point) {
                Point p = (Point)shape;
                shape2 = this.ctx.makePoint(this.normX(p.getX() + 180.0), p.getY());
            } else {
                throw new RuntimeException("" + shape);
            }
            this.assertRelation(null, expectedSR, (Shape)this.POLY_SHAPE_DL, (Shape)shape2);
        }
    }

    @Test
    public void testRussia() throws IOException, java.text.ParseException {
        String wktStr = this.readFirstLineFromRsrc("/russia.wkt.txt");
        JtsSpatialContextFactory factory = new JtsSpatialContextFactory();
        factory.normWrapLongitude = true;
        if (JtsGeometryTest.randomBoolean()) {
            factory.allowMultiOverlap = true;
        } else {
            factory.useJtsMulti = false;
        }
        JtsSpatialContext ctx = factory.newSpatialContext();
        Shape shape = this.wkt((SpatialContext)ctx, wktStr);
    }

    @Test
    public void testFiji() throws IOException, java.text.ParseException {
        String wktStr = this.readFirstLineFromRsrc("/fiji.wkt.txt");
        JtsSpatialContextFactory factory = new JtsSpatialContextFactory();
        factory.normWrapLongitude = true;
        JtsSpatialContext ctx = factory.newSpatialContext();
        Shape shape = this.wkt((SpatialContext)ctx, wktStr);
        this.assertRelation(null, SpatialRelation.CONTAINS, shape, (Shape)ctx.makePoint(-179.99, -16.9));
        this.assertRelation(null, SpatialRelation.CONTAINS, shape, (Shape)ctx.makePoint(179.99, -16.9));
        Assert.assertTrue((shape.getBoundingBox().getWidth() < 5.0 ? 1 : 0) != 0);
        System.out.println("Fiji Area: " + shape.getArea((SpatialContext)ctx));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readFirstLineFromRsrc(String wktRsrcPath) throws IOException {
        Assert.assertNotNull((Object)is);
        try (InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream(wktRsrcPath);){
            BufferedReader br = new BufferedReader(new InputStreamReader(is, "UTF-8"));
            String string = br.readLine();
            return string;
        }
    }

    @Test
    public void testNarrowGeometryCollection() {
        GeometryCollection gcol = Geom.build().point(1.0, 1.0).point().point(2.0, 3.0).point().toCollection();
        Assert.assertFalse((boolean)(gcol instanceof MultiPoint));
        JtsGeometry geom = JtsSpatialContext.GEO.makeShape((Geometry)gcol);
        Assert.assertTrue((boolean)(geom.getGeom() instanceof MultiPoint));
        gcol = Geom.build().point(1.0, 1.0).point(2.0, 2.0).lineString().point(3.0, 3.0).point(4.0, 4.0).lineString().toCollection();
        geom = JtsSpatialContext.GEO.makeShape((Geometry)gcol);
        Assert.assertTrue((boolean)(geom.getGeom() instanceof MultiLineString));
        gcol = Geom.build().point(1.0, 1.0).point().buffer(1.0).point(2.0, 3.0).point().buffer(1.0).toCollection();
        geom = JtsSpatialContext.GEO.makeShape((Geometry)gcol);
        Assert.assertTrue((boolean)(geom.getGeom() instanceof MultiPolygon));
        gcol = Geom.build().point(0.0, 0.0).point().point(1.0, 1.0).point(2.0, 2.0).lineString().toCollection();
        try {
            JtsSpatialContext.GEO.makeShape((Geometry)gcol);
            Assert.fail((String)"heterogenous geometry collection should throw exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testPolyRelatesToCircle() throws java.text.ParseException {
        Shape poly = this.wkt((SpatialContext)this.ctxNotGeo, "POLYGON ((1 1, 1 50, 50 1, 1 1), (10 10, 10 15, 15 15, 15 10, 10 10))");
        this.assertRelation(SpatialRelation.WITHIN, poly, (Shape)this.ctxNotGeo.makeCircle(25.0, 25.0, 40.0));
        this.assertRelation(SpatialRelation.CONTAINS, poly, (Shape)this.ctxNotGeo.makeCircle(10.0, 25.0, 5.0));
        this.assertRelation(SpatialRelation.DISJOINT, poly, (Shape)this.ctxNotGeo.makeCircle(35.0, 35.0, 5.0));
        this.assertRelation(SpatialRelation.DISJOINT, poly, (Shape)this.ctxNotGeo.makeCircle(12.0, 12.0, 1.0));
        this.assertRelation(SpatialRelation.INTERSECTS, poly, (Shape)this.ctxNotGeo.makeCircle(25.0, 25.0, 34.0));
        this.assertRelation(SpatialRelation.INTERSECTS, poly, (Shape)this.ctxNotGeo.makeCircle(30.0, 30.0, 10.0));
        this.assertRelation(SpatialRelation.DISJOINT, poly, (Shape)this.ctxNotGeo.makeCircle(30.0, 30.0, 5.0));
        this.assertRelation(SpatialRelation.INTERSECTS, poly, (Shape)this.ctxNotGeo.makeCircle(25.0, -5.0, 10.0));
        this.assertRelation(SpatialRelation.DISJOINT, poly, (Shape)this.ctxNotGeo.makeCircle(25.0, -5.0, 1.0));
        this.assertRelation(SpatialRelation.INTERSECTS, poly, (Shape)this.ctxNotGeo.makeCircle(0.0, 0.0, 10.0));
        this.assertRelation(SpatialRelation.INTERSECTS, poly, (Shape)this.ctxNotGeo.makeCircle(10.0, 35.0, 5.0));
        this.assertRelation(SpatialRelation.INTERSECTS, poly, (Shape)this.ctxNotGeo.makeCircle(12.0, 12.0, 10.0));
    }

    @Test
    public void testMultiLineStringRelatesToCircle() throws ParseException {
        WKTReader wktReader = new WKTReader();
        JtsGeometry poly = this.ctxNotGeo.makeShape(wktReader.read("MULTILINESTRING ((5 20, 5 5, 20 5), (20 25, 30 15))"));
        Assert.assertEquals(JtsGeometry.class, poly.getClass());
        this.assertRelation(SpatialRelation.WITHIN, (Shape)poly, (Shape)this.ctxNotGeo.makeCircle(15.0, 15.0, 20.0));
        this.assertRelation(SpatialRelation.DISJOINT, (Shape)poly, (Shape)this.ctxNotGeo.makeCircle(15.0, 15.0, 5.0));
        this.assertRelation(SpatialRelation.INTERSECTS, (Shape)poly, (Shape)this.ctxNotGeo.makeCircle(5.0, 5.0, 16.0));
        this.assertRelation(SpatialRelation.INTERSECTS, (Shape)poly, (Shape)this.ctxNotGeo.makeCircle(25.0, 20.0, 10.0));
        this.assertRelation(SpatialRelation.INTERSECTS, (Shape)poly, (Shape)this.ctxNotGeo.makeCircle(5.0, 20.0, 1.0));
        this.assertRelation(SpatialRelation.INTERSECTS, (Shape)poly, (Shape)this.ctxNotGeo.makeCircle(26.0, 21.0, 2.0));
    }

    private Shape wkt(SpatialContext ctx, String wkt) throws java.text.ParseException {
        return ((org.locationtech.spatial4j.io.WKTReader)ctx.getFormats().getWktReader()).parse(wkt);
    }
}

