/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial3d.geom;

import org.apache.lucene.spatial3d.geom.BaseXYZSolid;
import org.apache.lucene.spatial3d.geom.GeoPoint;
import org.apache.lucene.spatial3d.geom.GeoShape;
import org.apache.lucene.spatial3d.geom.Plane;
import org.apache.lucene.spatial3d.geom.PlanetModel;
import org.apache.lucene.spatial3d.geom.SidedPlane;

class XYdZSolid
extends BaseXYZSolid {
    protected final SidedPlane minXPlane;
    protected final SidedPlane maxXPlane;
    protected final SidedPlane minYPlane;
    protected final SidedPlane maxYPlane;
    protected final Plane zPlane;
    protected final GeoPoint[] edgePoints;
    protected final GeoPoint[] notableZPoints;

    public XYdZSolid(PlanetModel planetModel, double minX, double maxX, double minY, double maxY, double Z) {
        super(planetModel);
        GeoPoint intPoint;
        if (maxX - minX < 1.0E-12) {
            throw new IllegalArgumentException("X values in wrong order or identical");
        }
        if (maxY - minY < 1.0E-12) {
            throw new IllegalArgumentException("Y values in wrong order or identical");
        }
        double worldMinZ = planetModel.getMinimumZValue();
        double worldMaxZ = planetModel.getMaximumZValue();
        this.minXPlane = new SidedPlane(maxX, 0.0, 0.0, xUnitVector, -minX);
        this.maxXPlane = new SidedPlane(minX, 0.0, 0.0, xUnitVector, -maxX);
        this.minYPlane = new SidedPlane(0.0, maxY, 0.0, yUnitVector, -minY);
        this.maxYPlane = new SidedPlane(0.0, minY, 0.0, yUnitVector, -maxY);
        this.zPlane = new Plane(zUnitVector, -Z);
        GeoPoint[] minXZ = this.minXPlane.findIntersections(planetModel, this.zPlane, this.maxXPlane, this.minYPlane, this.maxYPlane);
        GeoPoint[] maxXZ = this.maxXPlane.findIntersections(planetModel, this.zPlane, this.minXPlane, this.minYPlane, this.maxYPlane);
        GeoPoint[] minYZ = this.minYPlane.findIntersections(planetModel, this.zPlane, this.maxYPlane, this.minXPlane, this.maxXPlane);
        GeoPoint[] maxYZ = this.maxYPlane.findIntersections(planetModel, this.zPlane, this.minYPlane, this.minXPlane, this.maxXPlane);
        this.notableZPoints = XYdZSolid.glueTogether(minXZ, maxXZ, minYZ, maxYZ);
        boolean minXminYZ = planetModel.pointOutside(minX, minY, Z);
        boolean minXmaxYZ = planetModel.pointOutside(minX, maxY, Z);
        boolean maxXminYZ = planetModel.pointOutside(maxX, minY, Z);
        boolean maxXmaxYZ = planetModel.pointOutside(maxX, maxY, Z);
        GeoPoint[] zEdges = Z - worldMinZ >= -1.0E-12 && Z - worldMaxZ <= 1.0E-12 && minX < 0.0 && maxX > 0.0 && minY < 0.0 && maxY > 0.0 && minXminYZ && minXmaxYZ && maxXminYZ && maxXmaxYZ ? ((intPoint = this.zPlane.getSampleIntersectionPoint(planetModel, xVerticalPlane)) != null ? new GeoPoint[]{intPoint} : EMPTY_POINTS) : EMPTY_POINTS;
        this.edgePoints = XYdZSolid.glueTogether(minXZ, maxXZ, minYZ, maxYZ, zEdges);
    }

    @Override
    protected GeoPoint[] getEdgePoints() {
        return this.edgePoints;
    }

    @Override
    public boolean isWithin(double x, double y, double z) {
        return this.minXPlane.isWithin(x, y, z) && this.maxXPlane.isWithin(x, y, z) && this.minYPlane.isWithin(x, y, z) && this.maxYPlane.isWithin(x, y, z) && this.zPlane.evaluateIsZero(x, y, z);
    }

    @Override
    public int getRelationship(GeoShape path) {
        int insideRectangle = this.isShapeInsideArea(path);
        if (insideRectangle == 1) {
            return 2;
        }
        int insideShape = this.isAreaInsideShape(path);
        if (insideShape == 1) {
            return 2;
        }
        if (insideRectangle == 0 && insideShape == 0) {
            return 2;
        }
        if (path.intersects(this.zPlane, this.notableZPoints, this.minXPlane, this.maxXPlane, this.minYPlane, this.maxYPlane)) {
            return 2;
        }
        if (insideRectangle == 0) {
            return 1;
        }
        if (insideShape == 0) {
            return 0;
        }
        return 3;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof XYdZSolid)) {
            return false;
        }
        XYdZSolid other = (XYdZSolid)o;
        if (!super.equals(other)) {
            return false;
        }
        return other.minXPlane.equals(this.minXPlane) && other.maxXPlane.equals(this.maxXPlane) && other.minYPlane.equals(this.minYPlane) && other.maxYPlane.equals(this.maxYPlane) && other.zPlane.equals(this.zPlane);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.minXPlane.hashCode();
        result = 31 * result + this.maxXPlane.hashCode();
        result = 31 * result + this.minYPlane.hashCode();
        result = 31 * result + this.maxYPlane.hashCode();
        result = 31 * result + this.zPlane.hashCode();
        return result;
    }

    public String toString() {
        return "XYdZSolid: {planetmodel=" + this.planetModel + ", minXplane=" + this.minXPlane + ", maxXplane=" + this.maxXPlane + ", minYplane=" + this.minYPlane + ", maxYplane=" + this.maxYPlane + ", zplane=" + this.zPlane + "}";
    }
}

