/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.memory;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.fst.Outputs;

class FSTTermOutputs
extends Outputs<TermData> {
    private static final TermData NO_OUTPUT = new TermData();
    private final boolean hasPos;
    private final int longsSize;

    protected FSTTermOutputs(FieldInfo fieldInfo, int longsSize) {
        this.hasPos = fieldInfo.getIndexOptions() != IndexOptions.DOCS;
        this.longsSize = longsSize;
    }

    public long ramBytesUsed(TermData output) {
        return output.ramBytesUsed();
    }

    public TermData common(TermData t1, TermData t2) {
        TermData ret;
        int pos;
        if (t1 == NO_OUTPUT || t2 == NO_OUTPUT) {
            return NO_OUTPUT;
        }
        assert (t1.longs.length == t2.longs.length);
        long[] min = t1.longs;
        long[] max = t2.longs;
        for (pos = 0; pos < this.longsSize && min[pos] == max[pos]; ++pos) {
        }
        if (pos < this.longsSize) {
            if (min[pos] > max[pos]) {
                min = t2.longs;
                max = t1.longs;
            }
            while (pos < this.longsSize && min[pos] <= max[pos]) {
                ++pos;
            }
            ret = pos < this.longsSize || FSTTermOutputs.allZero(min) ? NO_OUTPUT : new TermData(min, null, 0, -1L);
        } else {
            ret = FSTTermOutputs.statsEqual(t1, t2) && FSTTermOutputs.bytesEqual(t1, t2) ? t1 : (FSTTermOutputs.allZero(min) ? NO_OUTPUT : new TermData(min, null, 0, -1L));
        }
        return ret;
    }

    public TermData subtract(TermData t1, TermData t2) {
        if (t2 == NO_OUTPUT) {
            return t1;
        }
        assert (t1.longs.length == t2.longs.length);
        long diff = 0L;
        long[] share = new long[this.longsSize];
        for (int pos = 0; pos < this.longsSize; ++pos) {
            share[pos] = t1.longs[pos] - t2.longs[pos];
            diff += share[pos];
        }
        TermData ret = diff == 0L && FSTTermOutputs.statsEqual(t1, t2) && FSTTermOutputs.bytesEqual(t1, t2) ? NO_OUTPUT : new TermData(share, t1.bytes, t1.docFreq, t1.totalTermFreq);
        return ret;
    }

    public TermData add(TermData t1, TermData t2) {
        if (t1 == NO_OUTPUT) {
            return t2;
        }
        if (t2 == NO_OUTPUT) {
            return t1;
        }
        assert (t1.longs.length == t2.longs.length);
        long[] accum = new long[this.longsSize];
        for (int pos = 0; pos < this.longsSize; ++pos) {
            accum[pos] = t1.longs[pos] + t2.longs[pos];
        }
        TermData ret = t2.bytes != null || t2.docFreq > 0 ? new TermData(accum, t2.bytes, t2.docFreq, t2.totalTermFreq) : new TermData(accum, t1.bytes, t1.docFreq, t1.totalTermFreq);
        return ret;
    }

    public void write(TermData data, DataOutput out) throws IOException {
        assert (this.hasPos || data.totalTermFreq == -1L);
        int bit0 = FSTTermOutputs.allZero(data.longs) ? 0 : 1;
        int bit1 = (data.bytes == null || data.bytes.length == 0 ? 0 : 1) << 1;
        int bit2 = (data.docFreq == 0 ? 0 : 1) << 2;
        int bits = bit0 | bit1 | bit2;
        if (bit1 > 0) {
            if (data.bytes.length < 32) {
                out.writeByte((byte)(bits |= data.bytes.length << 3));
            } else {
                out.writeByte((byte)bits);
                out.writeVInt(data.bytes.length);
            }
        } else {
            out.writeByte((byte)bits);
        }
        if (bit0 > 0) {
            for (int pos = 0; pos < this.longsSize; ++pos) {
                out.writeVLong(data.longs[pos]);
            }
        }
        if (bit1 > 0) {
            out.writeBytes(data.bytes, 0, data.bytes.length);
        }
        if (bit2 > 0) {
            if (this.hasPos) {
                if ((long)data.docFreq == data.totalTermFreq) {
                    out.writeVInt(data.docFreq << 1 | 1);
                } else {
                    out.writeVInt(data.docFreq << 1);
                    out.writeVLong(data.totalTermFreq - (long)data.docFreq);
                }
            } else {
                out.writeVInt(data.docFreq);
            }
        }
    }

    public TermData read(DataInput in) throws IOException {
        long[] longs = new long[this.longsSize];
        byte[] bytes = null;
        int docFreq = 0;
        long totalTermFreq = -1L;
        int bits = in.readByte() & 0xFF;
        int bit0 = bits & 1;
        int bit1 = bits & 2;
        int bit2 = bits & 4;
        int bytesSize = bits >>> 3;
        if (bit1 > 0 && bytesSize == 0) {
            bytesSize = in.readVInt();
        }
        if (bit0 > 0) {
            for (int pos = 0; pos < this.longsSize; ++pos) {
                longs[pos] = in.readVLong();
            }
        }
        if (bit1 > 0) {
            bytes = new byte[bytesSize];
            in.readBytes(bytes, 0, bytesSize);
        }
        if (bit2 > 0) {
            int code = in.readVInt();
            if (this.hasPos) {
                docFreq = code >>> 1;
                totalTermFreq = docFreq;
                if ((code & 1) == 0) {
                    totalTermFreq += in.readVLong();
                }
            } else {
                docFreq = code;
            }
        }
        return new TermData(longs, bytes, docFreq, totalTermFreq);
    }

    public void skipOutput(DataInput in) throws IOException {
        int bits = in.readByte() & 0xFF;
        int bit0 = bits & 1;
        int bit1 = bits & 2;
        int bit2 = bits & 4;
        int bytesSize = bits >>> 3;
        if (bit1 > 0 && bytesSize == 0) {
            bytesSize = in.readVInt();
        }
        if (bit0 > 0) {
            for (int pos = 0; pos < this.longsSize; ++pos) {
                in.readVLong();
            }
        }
        if (bit1 > 0) {
            in.skipBytes((long)bytesSize);
        }
        if (bit2 > 0) {
            int code = in.readVInt();
            if (this.hasPos && (code & 1) == 0) {
                in.readVLong();
            }
        }
    }

    public TermData getNoOutput() {
        return NO_OUTPUT;
    }

    public String outputToString(TermData data) {
        return data.toString();
    }

    static boolean statsEqual(TermData t1, TermData t2) {
        return t1.docFreq == t2.docFreq && t1.totalTermFreq == t2.totalTermFreq;
    }

    static boolean bytesEqual(TermData t1, TermData t2) {
        if (t1.bytes == null && t2.bytes == null) {
            return true;
        }
        return t1.bytes != null && t2.bytes != null && Arrays.equals(t1.bytes, t2.bytes);
    }

    static boolean longsEqual(TermData t1, TermData t2) {
        if (t1.longs == null && t2.longs == null) {
            return true;
        }
        return t1.longs != null && t2.longs != null && Arrays.equals(t1.longs, t2.longs);
    }

    static boolean allZero(long[] l) {
        for (int i = 0; i < l.length; ++i) {
            if (l[i] == 0L) continue;
            return false;
        }
        return true;
    }

    static class TermData
    implements Accountable {
        private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(TermData.class);
        long[] longs;
        byte[] bytes;
        int docFreq;
        long totalTermFreq;

        TermData() {
            this.longs = null;
            this.bytes = null;
            this.docFreq = 0;
            this.totalTermFreq = -1L;
        }

        TermData(long[] longs, byte[] bytes, int docFreq, long totalTermFreq) {
            this.longs = longs;
            this.bytes = bytes;
            this.docFreq = docFreq;
            this.totalTermFreq = totalTermFreq;
        }

        public long ramBytesUsed() {
            long ramBytesUsed = BASE_RAM_BYTES_USED;
            if (this.longs != null) {
                ramBytesUsed += RamUsageEstimator.sizeOf((long[])this.longs);
            }
            if (this.bytes != null) {
                ramBytesUsed += RamUsageEstimator.sizeOf((byte[])this.bytes);
            }
            return ramBytesUsed;
        }

        public int hashCode() {
            int i;
            int end;
            int hash = 0;
            if (this.longs != null) {
                end = this.longs.length;
                for (i = 0; i < end; ++i) {
                    hash = (int)((long)hash - this.longs[i]);
                }
            }
            if (this.bytes != null) {
                hash = -hash;
                end = this.bytes.length;
                for (i = 0; i < end; ++i) {
                    hash += this.bytes[i];
                }
            }
            hash = (int)((long)hash + ((long)this.docFreq + this.totalTermFreq));
            return hash;
        }

        public String toString() {
            return "FSTTermOutputs$TermData longs=" + Arrays.toString(this.longs) + " bytes=" + Arrays.toString(this.bytes) + " docFreq=" + this.docFreq + " totalTermFreq=" + this.totalTermFreq;
        }

        public boolean equals(Object other_) {
            if (other_ == this) {
                return true;
            }
            if (!(other_ instanceof TermData)) {
                return false;
            }
            TermData other = (TermData)other_;
            return FSTTermOutputs.statsEqual(this, other) && FSTTermOutputs.longsEqual(this, other) && FSTTermOutputs.bytesEqual(this, other);
        }
    }
}

