/*
 * Decompiled with CFR 0.152.
 */
package com.spatial4j.core.shape.impl;

import com.carrotsearch.randomizedtesting.annotations.Repeat;
import com.spatial4j.core.context.SpatialContext;
import com.spatial4j.core.shape.RandomizedShapeTest;
import com.spatial4j.core.shape.Rectangle;
import com.spatial4j.core.shape.Shape;
import com.spatial4j.core.shape.SpatialRelation;
import com.spatial4j.core.shape.impl.BBoxCalculator;
import java.util.ArrayList;
import java.util.List;
import org.junit.Test;

public class BBoxCalculatorTest
extends RandomizedShapeTest {
    public BBoxCalculatorTest() {
        super(SpatialContext.GEO);
    }

    @Test
    @Repeat(iterations=100)
    public void testGeoLongitude() {
        BBoxCalculator calc = new BBoxCalculator(this.ctx);
        int numShapes = BBoxCalculatorTest.randomIntBetween((int)1, (int)4);
        ArrayList<Rectangle> rects = new ArrayList<Rectangle>(numShapes);
        for (int i = 0; i < numShapes; ++i) {
            Rectangle rect = this.randomRectangle(30);
            rects.add(rect);
            calc.expandRange(rect);
        }
        Rectangle boundary = calc.getBoundary();
        if (numShapes == 1) {
            BBoxCalculatorTest.assertEquals(rects.get(0), (Object)boundary);
            return;
        }
        if (boundary.getMinX() == -180.0 && boundary.getMaxX() == 180.0) {
            for (int lon = -180; lon <= 180; ++lon) {
                BBoxCalculatorTest.assertTrue((boolean)this.atLeastOneRectHasLon(rects, lon));
            }
            return;
        }
        for (Rectangle rect : rects) {
            this.assertRelation(SpatialRelation.CONTAINS, (Shape)boundary, (Shape)rect);
        }
        BBoxCalculatorTest.assertTrue((boolean)this.atLeastOneRectHasLon(rects, boundary.getMinX()));
        BBoxCalculatorTest.assertFalse((boolean)this.atLeastOneRectHasLon(rects, this.normX(boundary.getMinX() - 0.5)));
        BBoxCalculatorTest.assertTrue((boolean)this.atLeastOneRectHasLon(rects, boundary.getMaxX()));
        BBoxCalculatorTest.assertFalse((boolean)this.atLeastOneRectHasLon(rects, this.normX(boundary.getMaxX() + 0.5)));
        if (boundary.getWidth() > 180.0) {
            double biggerGap = 360.0 - boundary.getWidth() + 0.5;
            for (Rectangle rect : rects) {
                double gapRectLeft = rect.getMaxX() + 0.25;
                double gapRectRight = gapRectLeft + biggerGap;
                Rectangle testGap = this.makeNormRect(gapRectLeft, gapRectRight, -90.0, 90.0);
                boolean fits = true;
                for (Rectangle rect2 : rects) {
                    if (!rect2.relate((Shape)testGap).intersects()) continue;
                    fits = false;
                    break;
                }
                BBoxCalculatorTest.assertFalse((boolean)fits);
            }
        }
    }

    private boolean atLeastOneRectHasLon(List<Rectangle> rects, double lon) {
        for (Rectangle rect : rects) {
            if (!rect.relateXRange(lon, lon).intersects()) continue;
            return true;
        }
        return false;
    }
}

