/*
 * Decompiled with CFR 0.152.
 */
package com.spatial4j.core.shape;

import com.carrotsearch.randomizedtesting.annotations.ParametersFactory;
import com.carrotsearch.randomizedtesting.annotations.Repeat;
import com.spatial4j.core.context.SpatialContext;
import com.spatial4j.core.context.SpatialContextFactory;
import com.spatial4j.core.context.jts.JtsSpatialContextFactory;
import com.spatial4j.core.distance.DistanceCalculator;
import com.spatial4j.core.distance.DistanceUtils;
import com.spatial4j.core.distance.GeodesicSphereDistCalc;
import com.spatial4j.core.exception.InvalidShapeException;
import com.spatial4j.core.shape.AbstractTestShapes;
import com.spatial4j.core.shape.Rectangle;
import com.spatial4j.core.shape.RoundingDistCalc;
import com.spatial4j.core.shape.Shape;
import com.spatial4j.core.shape.SpatialRelation;
import com.spatial4j.core.shape.TestShapes2D;
import java.util.Arrays;
import org.junit.Test;

public class TestShapesGeo
extends AbstractTestShapes {
    @ParametersFactory
    public static Iterable<Object[]> parameters() {
        GeodesicSphereDistCalc.LawOfCosines distCalcL = new GeodesicSphereDistCalc.LawOfCosines();
        GeodesicSphereDistCalc.Haversine distCalcH = new GeodesicSphereDistCalc.Haversine();
        GeodesicSphereDistCalc.Vincenty distCalcV = new GeodesicSphereDistCalc.Vincenty();
        return Arrays.asList(TestShapesGeo.$$((Object[][])new Object[][]{TestShapesGeo.$((Object[])new Object[]{new SpatialContextFactory((DistanceCalculator)distCalcL){
            final /* synthetic */ DistanceCalculator val$distCalcL;
            {
                this.val$distCalcL = distanceCalculator;
                this.geo = true;
                this.distCalc = new RoundingDistCalc(this.val$distCalcL);
            }
        }.newSpatialContext()}), TestShapesGeo.$((Object[])new Object[]{new SpatialContextFactory((DistanceCalculator)distCalcH){
            final /* synthetic */ DistanceCalculator val$distCalcH;
            {
                this.val$distCalcH = distanceCalculator;
                this.geo = true;
                this.distCalc = new RoundingDistCalc(this.val$distCalcH);
            }
        }.newSpatialContext()}), TestShapesGeo.$((Object[])new Object[]{new SpatialContextFactory((DistanceCalculator)distCalcV){
            final /* synthetic */ DistanceCalculator val$distCalcV;
            {
                this.val$distCalcV = distanceCalculator;
                this.geo = true;
                this.distCalc = new RoundingDistCalc(this.val$distCalcV);
            }
        }.newSpatialContext()}), TestShapesGeo.$((Object[])new Object[]{new JtsSpatialContextFactory((DistanceCalculator)distCalcH){
            final /* synthetic */ DistanceCalculator val$distCalcH;
            {
                this.val$distCalcH = distanceCalculator;
                this.geo = true;
                this.distCalc = new RoundingDistCalc(this.val$distCalcH);
            }
        }.newSpatialContext()})}));
    }

    public TestShapesGeo(SpatialContext ctx) {
        super(ctx);
    }

    private static double degToKm(double deg) {
        return DistanceUtils.degrees2Dist((double)deg, (double)6371.0087714);
    }

    private static double kmToDeg(double km) {
        return DistanceUtils.dist2Degrees((double)km, (double)6371.0087714);
    }

    @Test
    @Repeat(iterations=1)
    public void testGeoRectangle() {
        double[] lons;
        double v = 200 * (TestShapesGeo.randomBoolean() ? -1 : 1);
        try {
            this.ctx.makeRectangle(v, 0.0, 0.0, 0.0);
            TestShapesGeo.fail();
        }
        catch (InvalidShapeException e) {
            // empty catch block
        }
        try {
            this.ctx.makeRectangle(0.0, v, 0.0, 0.0);
            TestShapesGeo.fail();
        }
        catch (InvalidShapeException e) {
            // empty catch block
        }
        try {
            this.ctx.makeRectangle(0.0, 0.0, v, 0.0);
            TestShapesGeo.fail();
        }
        catch (InvalidShapeException e) {
            // empty catch block
        }
        try {
            this.ctx.makeRectangle(0.0, 0.0, 0.0, v);
            TestShapesGeo.fail();
        }
        catch (InvalidShapeException e) {
            // empty catch block
        }
        try {
            this.ctx.makeRectangle(0.0, 0.0, 10.0, -10.0);
            TestShapesGeo.fail();
        }
        catch (InvalidShapeException e) {
            // empty catch block
        }
        TestShapesGeo.assertEquals((Object)SpatialRelation.INTERSECTS, (Object)this.ctx.makeRectangle(170.0, 180.0, 0.0, 0.0).relateXRange(-180.0, -170.0));
        TestShapesGeo.assertEquals((Object)SpatialRelation.INTERSECTS, (Object)this.ctx.makeRectangle(-90.0, -45.0, 0.0, 0.0).relateXRange(-45.0, -135.0));
        TestShapesGeo.assertEquals((Object)SpatialRelation.CONTAINS, (Object)this.ctx.getWorldBounds().relateXRange(-90.0, -135.0));
        TestShapesGeo.assertEquals((Object)SpatialRelation.CONTAINS, (Object)this.ctx.makeRectangle(170.0, 180.0, 0.0, 0.0).relate((Shape)this.ctx.makePoint(-180.0, 0.0)));
        TestShapesGeo.assertEquals((Object)this.ctx.makeRectangle(-180.0, -170.0, 0.0, 0.0), (Object)this.ctx.makeRectangle(180.0, -170.0, 0.0, 0.0));
        TestShapesGeo.assertEquals((Object)this.ctx.makeRectangle(170.0, 180.0, 0.0, 0.0), (Object)this.ctx.makeRectangle(170.0, -180.0, 0.0, 0.0));
        for (double lon : lons = new double[]{0.0, 45.0, 160.0, 180.0, -45.0, -175.0, -180.0}) {
            double[] lonWs;
            for (double lonW : lonWs = new double[]{0.0, 20.0, 180.0, 200.0, 355.0, 360.0}) {
                if (lonW == 360.0 && lon != -180.0) continue;
                this.testRectangle(lon, lonW, 0.0, 0.0);
                this.testRectangle(lon, lonW, -10.0, 10.0);
                this.testRectangle(lon, lonW, 80.0, 10.0);
                this.testRectangle(lon, lonW, -90.0, 180.0);
            }
        }
        this.testRectIntersect();
        this.assertRelation(SpatialRelation.WITHIN, (Shape)this.ctx.makeRectangle(-180.0, -180.0, -10.0, 10.0), (Shape)this.ctx.makeRectangle(180.0, 180.0, -30.0, 30.0));
        TestShapesGeo.assertEquals((Object)this.ctx.makeRectangle(-10.0, 10.0, -10.0, 10.0), (Object)this.ctx.makeRectangle(0.0, 0.0, 0.0, 0.0).getBuffered(10.0, this.ctx));
        int MAX_TRIES = TestShapesGeo.scaledRandomIntBetween((int)100, (int)1000);
        for (int i = 0; i < MAX_TRIES; ++i) {
            Rectangle r = this.randomRectangle(1);
            int buf = TestShapesGeo.randomIntBetween((int)0, (int)90);
            Rectangle br = (Rectangle)r.getBuffered((double)buf, this.ctx);
            this.assertRelation(null, SpatialRelation.CONTAINS, (Shape)br, (Shape)r);
            if (r.getWidth() + (double)(2 * buf) >= 360.0) {
                TestShapesGeo.assertEquals((double)360.0, (double)br.getWidth(), (double)0.0);
                continue;
            }
            TestShapesGeo.assertGreaterOrEqual(br.getWidth() - r.getWidth(), 2 * buf, 1.0E-8);
        }
        TestShapesGeo.assertTrue((this.ctx.makeRectangle(0.0, 10.0, 0.0, 89.0).getBuffered(0.5, this.ctx).getBoundingBox().getWidth() > 11.0 ? 1 : 0) != 0);
    }

    @Test
    public void testGeoCircle() {
        double[] theXs;
        TestShapesGeo.assertEquals((Object)"Circle(Pt(x=10.0,y=20.0), d=30.0\u00b0 3335.85km)", (Object)this.ctx.makeCircle(10.0, 20.0, 30.0).toString());
        double v = 200 * (TestShapesGeo.randomBoolean() ? -1 : 1);
        try {
            this.ctx.makeCircle(v, 0.0, 5.0);
            TestShapesGeo.fail();
        }
        catch (InvalidShapeException e) {
            // empty catch block
        }
        try {
            this.ctx.makeCircle(0.0, v, 5.0);
            TestShapesGeo.fail();
        }
        catch (InvalidShapeException e) {
            // empty catch block
        }
        this.ctx.makeCircle(110.0, -12.0, 102.0);
        this.ctx.makeCircle(-44.0, 16.0, 106.0);
        this.ctx.makeCircle(-36.0, -76.0, 14.0);
        this.ctx.makeCircle(107.0, 82.0, 172.0);
        TestShapesGeo.assertEquals((String)"bad proportion logic", (Object)SpatialRelation.INTERSECTS, (Object)this.ctx.makeCircle(64.0, -70.0, 18.0).relate((Shape)this.ctx.makeRectangle(46.0, 116.0, -86.0, -62.0)));
        TestShapesGeo.assertEquals((String)"Both touch pole", (Object)SpatialRelation.INTERSECTS, (Object)this.ctx.makeCircle(-90.0, 30.0, 60.0).relate((Shape)this.ctx.makeRectangle(-24.0, -16.0, 14.0, 90.0)));
        TestShapesGeo.assertEquals((String)"Spherical cap should contain enclosed band", (Object)SpatialRelation.CONTAINS, (Object)this.ctx.makeCircle(0.0, -90.0, 30.0).relate((Shape)this.ctx.makeRectangle(-180.0, 180.0, -90.0, -80.0)));
        TestShapesGeo.assertEquals((String)"touches pole", (Object)SpatialRelation.INTERSECTS, (Object)this.ctx.makeCircle(0.0, -88.0, 2.0).relate((Shape)this.ctx.makeRectangle(40.0, 60.0, -90.0, -86.0)));
        TestShapesGeo.assertEquals((String)"wrong farthest opp corner", (Object)SpatialRelation.INTERSECTS, (Object)this.ctx.makeCircle(92.0, 36.0, 46.0).relate((Shape)this.ctx.makeRectangle(134.0, 136.0, 32.0, 80.0)));
        TestShapesGeo.assertEquals((String)"edge rounding issue 2", (Object)SpatialRelation.INTERSECTS, (Object)this.ctx.makeCircle(84.0, -40.0, 136.0).relate((Shape)this.ctx.makeRectangle(-150.0, -80.0, 34.0, 84.0)));
        TestShapesGeo.assertEquals((String)"edge rounding issue", (Object)SpatialRelation.CONTAINS, (Object)this.ctx.makeCircle(0.0, 66.0, 156.0).relate((Shape)this.ctx.makePoint(0.0, -90.0)));
        TestShapesGeo.assertEquals((String)"nudge back circle", (Object)SpatialRelation.CONTAINS, (Object)this.ctx.makeCircle(-150.0, -90.0, 122.0).relate((Shape)this.ctx.makeRectangle(0.0, -132.0, 32.0, 32.0)));
        TestShapesGeo.assertEquals((String)"wrong estimate", (Object)SpatialRelation.DISJOINT, (Object)this.ctx.makeCircle(-166.0, 59.0, TestShapesGeo.kmToDeg(5226.2)).relate((Shape)this.ctx.makeRectangle(36.0, 66.0, 23.0, 23.0)));
        TestShapesGeo.assertEquals((String)"bad CONTAINS (dateline)", (Object)SpatialRelation.INTERSECTS, (Object)this.ctx.makeCircle(56.0, -50.0, TestShapesGeo.kmToDeg(12231.5)).relate((Shape)this.ctx.makeRectangle(108.0, 26.0, 39.0, 48.0)));
        TestShapesGeo.assertEquals((String)"bad CONTAINS (backwrap2)", (Object)SpatialRelation.INTERSECTS, (Object)this.ctx.makeCircle(112.0, -3.0, 91.0).relate((Shape)this.ctx.makeRectangle(-163.0, 29.0, -38.0, 10.0)));
        TestShapesGeo.assertEquals((String)"bad CONTAINS (r x-wrap)", (Object)SpatialRelation.INTERSECTS, (Object)this.ctx.makeCircle(-139.0, 47.0, 80.0).relate((Shape)this.ctx.makeRectangle(-180.0, 180.0, -3.0, 12.0)));
        TestShapesGeo.assertEquals((String)"bad CONTAINS (pwrap)", (Object)SpatialRelation.INTERSECTS, (Object)this.ctx.makeCircle(-139.0, 47.0, 80.0).relate((Shape)this.ctx.makeRectangle(-180.0, 179.0, -3.0, 12.0)));
        TestShapesGeo.assertEquals((String)"no-dist 1", (Object)SpatialRelation.WITHIN, (Object)this.ctx.makeCircle(135.0, 21.0, 0.0).relate((Shape)this.ctx.makeRectangle(-103.0, -154.0, -47.0, 52.0)));
        TestShapesGeo.assertEquals((String)"bbox <= >= -90 bug", (Object)SpatialRelation.CONTAINS, (Object)this.ctx.makeCircle(-64.0, -84.0, 124.0).relate((Shape)this.ctx.makeRectangle(-96.0, 96.0, -10.0, -10.0)));
        TestShapesGeo.assertEquals((String)"c's horiz axis doesn't pass through ctr", (Object)SpatialRelation.INTERSECTS, (Object)this.ctx.makeCircle(71.0, -44.0, 40.0).relate((Shape)this.ctx.makeRectangle(15.0, 27.0, -62.0, -34.0)));
        TestShapesGeo.assertEquals((String)"pole boundary", (Object)SpatialRelation.INTERSECTS, (Object)this.ctx.makeCircle(-100.0, -12.0, 102.0).relate((Shape)this.ctx.makeRectangle(143.0, 175.0, 4.0, 32.0)));
        TestShapesGeo.assertEquals((String)"full circle assert", (Object)SpatialRelation.CONTAINS, (Object)this.ctx.makeCircle(-64.0, 32.0, 180.0).relate((Shape)this.ctx.makeRectangle(47.0, 47.0, -14.0, 90.0)));
        TestShapes2D.testCircleReset(this.ctx);
        TestShapesGeo.assertEquals((Object)this.ctx.getWorldBounds(), (Object)this.ctx.makeCircle(0.0, 0.0, 180.0).getBoundingBox());
        for (double x : theXs = new double[]{-180.0, -45.0, 90.0}) {
            double[] theYs;
            for (double y : theYs = new double[]{-90.0, -45.0, 0.0, 45.0, 90.0}) {
                this.testCircle(x, y, 0.0);
                this.testCircle(x, y, TestShapesGeo.kmToDeg(500.0));
                this.testCircle(x, y, 90.0);
                this.testCircle(x, y, 180.0);
            }
        }
        this.testCircleIntersect();
    }
}

