/*
 * Decompiled with CFR 0.152.
 */
package com.spatial4j.core.shape;

import com.carrotsearch.randomizedtesting.annotations.ParametersFactory;
import com.spatial4j.core.context.SpatialContext;
import com.spatial4j.core.context.SpatialContextFactory;
import com.spatial4j.core.context.jts.JtsSpatialContextFactory;
import com.spatial4j.core.exception.InvalidShapeException;
import com.spatial4j.core.shape.AbstractTestShapes;
import com.spatial4j.core.shape.Circle;
import com.spatial4j.core.shape.Point;
import com.spatial4j.core.shape.Rectangle;
import com.spatial4j.core.shape.Shape;
import com.spatial4j.core.shape.ShapeCollection;
import com.spatial4j.core.shape.SpatialRelation;
import com.spatial4j.core.shape.impl.BufferedLine;
import com.spatial4j.core.shape.impl.BufferedLineString;
import com.spatial4j.core.shape.impl.CircleImpl;
import com.spatial4j.core.shape.impl.PointImpl;
import com.spatial4j.core.shape.impl.RectangleImpl;
import java.util.ArrayList;
import java.util.Collections;
import org.junit.Test;

public class TestShapes2D
extends AbstractTestShapes {
    @ParametersFactory
    public static Iterable<Object[]> parameters() {
        RectangleImpl WB = new RectangleImpl(-2000.0, 2000.0, -300.0, 300.0, null);
        ArrayList<Object[]> ctxs = new ArrayList<Object[]>();
        ctxs.add(TestShapes2D.$((Object[])new Object[]{new SpatialContextFactory((Rectangle)WB){
            final /* synthetic */ Rectangle val$WB;
            {
                this.val$WB = rectangle;
                this.geo = false;
                this.worldBounds = this.val$WB;
            }
        }.newSpatialContext()}));
        ctxs.add(TestShapes2D.$((Object[])new Object[]{new JtsSpatialContextFactory((Rectangle)WB){
            final /* synthetic */ Rectangle val$WB;
            {
                this.val$WB = rectangle;
                this.geo = false;
                this.worldBounds = this.val$WB;
            }
        }.newSpatialContext()}));
        return ctxs;
    }

    public TestShapes2D(SpatialContext ctx) {
        super(ctx);
    }

    @Test
    public void testSimplePoint() {
        try {
            this.ctx.makePoint(2001.0, 0.0);
            TestShapes2D.fail();
        }
        catch (InvalidShapeException e) {
            // empty catch block
        }
        try {
            this.ctx.makePoint(0.0, -301.0);
            TestShapes2D.fail();
        }
        catch (InvalidShapeException e) {
            // empty catch block
        }
        Point pt = this.ctx.makePoint(0.0, 0.0);
        String msg = pt.toString();
        Point pt2 = this.ctx.makePoint(0.0, 0.0);
        TestShapes2D.assertEquals((String)msg, (Object)pt, (Object)pt2);
        TestShapes2D.assertEquals((String)msg, (long)pt.hashCode(), (long)pt2.hashCode());
        TestShapes2D.assertFalse((String)msg, (boolean)pt.hasArea());
        TestShapes2D.assertEquals((String)msg, (Object)pt.getCenter(), (Object)pt);
        Rectangle bbox = pt.getBoundingBox();
        TestShapes2D.assertFalse((String)msg, (boolean)bbox.hasArea());
        TestShapes2D.assertEquals((String)msg, (Object)pt, (Object)bbox.getCenter());
        this.assertRelation(msg, SpatialRelation.CONTAINS, (Shape)pt, (Shape)pt2);
        this.assertRelation(msg, SpatialRelation.DISJOINT, (Shape)pt, (Shape)this.ctx.makePoint(0.0, 1.0));
        this.assertRelation(msg, SpatialRelation.DISJOINT, (Shape)pt, (Shape)this.ctx.makePoint(1.0, 0.0));
        this.assertRelation(msg, SpatialRelation.DISJOINT, (Shape)pt, (Shape)this.ctx.makePoint(1.0, 1.0));
        pt.reset(1.0, 2.0);
        TestShapes2D.assertEquals((Object)this.ctx.makePoint(1.0, 2.0), (Object)pt);
        TestShapes2D.assertEquals((Object)this.ctx.makeCircle(pt, 3.0), (Object)pt.getBuffered(3.0, this.ctx));
        this.testEmptiness((Shape)this.ctx.makePoint(Double.NaN, Double.NaN));
    }

    @Test
    public void testSimpleRectangle() {
        double[] minXs;
        double v = 2001 * (TestShapes2D.randomBoolean() ? -1 : 1);
        try {
            this.ctx.makeRectangle(v, 0.0, 0.0, 0.0);
            TestShapes2D.fail();
        }
        catch (InvalidShapeException e) {
            // empty catch block
        }
        try {
            this.ctx.makeRectangle(0.0, v, 0.0, 0.0);
            TestShapes2D.fail();
        }
        catch (InvalidShapeException e) {
            // empty catch block
        }
        try {
            this.ctx.makeRectangle(0.0, 0.0, v, 0.0);
            TestShapes2D.fail();
        }
        catch (InvalidShapeException e) {
            // empty catch block
        }
        try {
            this.ctx.makeRectangle(0.0, 0.0, 0.0, v);
            TestShapes2D.fail();
        }
        catch (InvalidShapeException e) {
            // empty catch block
        }
        try {
            this.ctx.makeRectangle(0.0, 0.0, 10.0, -10.0);
            TestShapes2D.fail();
        }
        catch (InvalidShapeException e) {
            // empty catch block
        }
        try {
            this.ctx.makeRectangle(10.0, -10.0, 0.0, 0.0);
            TestShapes2D.fail();
        }
        catch (InvalidShapeException e) {
            // empty catch block
        }
        for (double minX : minXs = new double[]{-1000.0, -360.0, -180.0, -20.0, 0.0, 20.0, 180.0, 1000.0}) {
            double[] widths;
            for (double width : widths = new double[]{0.0, 10.0, 180.0, 360.0, 400.0}) {
                this.testRectangle(minX, width, 0.0, 0.0);
                this.testRectangle(minX, width, -10.0, 10.0);
                this.testRectangle(minX, width, 5.0, 10.0);
            }
        }
        Rectangle r = this.ctx.makeRectangle(0.0, 0.0, 0.0, 0.0);
        r.reset(1.0, 2.0, 3.0, 4.0);
        TestShapes2D.assertEquals((Object)this.ctx.makeRectangle(1.0, 2.0, 3.0, 4.0), (Object)r);
        this.testRectIntersect();
        if (!this.ctx.isGeo()) {
            TestShapes2D.assertEquals((Object)this.ctx.makeRectangle(0.9, 2.1, 2.9, 4.1), (Object)this.ctx.makeRectangle(1.0, 2.0, 3.0, 4.0).getBuffered(0.1, this.ctx));
        }
        this.testEmptiness((Shape)this.ctx.makeRectangle(Double.NaN, Double.NaN, Double.NaN, Double.NaN));
    }

    @Test
    public void testSimpleCircle() {
        double[] theXs;
        for (double x : theXs = new double[]{-10.0, 0.0, 10.0}) {
            double[] theYs;
            for (double y : theYs = new double[]{-20.0, 0.0, 20.0}) {
                this.testCircle(x, y, 0.0);
                this.testCircle(x, y, 5.0);
            }
        }
        TestShapes2D.testCircleReset(this.ctx);
        TestShapes2D.assertEquals((String)"getX not getY", (Object)SpatialRelation.INTERSECTS, (Object)this.ctx.makeCircle(107.0, -81.0, 147.0).relate((Shape)this.ctx.makeRectangle(92.0, 121.0, -89.0, 74.0)));
        this.testCircleIntersect();
        TestShapes2D.assertEquals((Object)this.ctx.makeCircle(1.0, 2.0, 10.0), (Object)this.ctx.makeCircle(1.0, 2.0, 6.0).getBuffered(4.0, this.ctx));
        this.testEmptiness((Shape)this.ctx.makeCircle(Double.NaN, Double.NaN, TestShapes2D.randomBoolean() ? 0.0 : Double.NaN));
    }

    static void testCircleReset(SpatialContext ctx) {
        Circle c = ctx.makeCircle(3.0, 4.0, 5.0);
        Circle c2 = ctx.makeCircle(5.0, 6.0, 7.0);
        c2.reset(3.0, 4.0, 5.0);
        TestShapes2D.assertEquals((Object)c, (Object)c2);
        TestShapes2D.assertEquals((Object)c.getBoundingBox(), (Object)c2.getBoundingBox());
    }

    @Test
    public void testBufferedLineString() {
        this.testEmptiness(this.ctx.makeBufferedLineString(Collections.emptyList(), (double)TestShapes2D.randomInt((int)3)));
    }

    @Test
    public void testImplementsEqualsAndHash() throws Exception {
        TestShapes2D.checkShapesImplementEquals(new Class[]{PointImpl.class, CircleImpl.class, RectangleImpl.class, ShapeCollection.class, BufferedLineString.class, BufferedLine.class});
    }
}

